/*
 * Decompiled with CFR 0.152.
 */
package org.hypergraphdb.peer.log;

import java.util.HashMap;
import org.hypergraphdb.HGHandle;
import org.hypergraphdb.HGPersistentHandle;
import org.hypergraphdb.HyperGraph;
import org.hypergraphdb.peer.HGPeerIdentity;
import org.hypergraphdb.peer.StorageService;
import org.hypergraphdb.peer.log.Timestamp;
import org.hypergraphdb.storage.HGStoreSubgraph;
import org.hypergraphdb.storage.StorageGraph;

public class LogEntry
implements Comparable<LogEntry> {
    private StorageGraph data;
    private HGPersistentHandle logEntryHandle;
    private HashMap<HGPeerIdentity, Timestamp> lastTimestamps = new HashMap();
    Timestamp timestamp;
    StorageService.Operation operation;
    private HGPersistentHandle handle;

    public LogEntry(Object value, HyperGraph logDb, StorageService.Operation operation) {
        this(value, logDb, null, operation);
    }

    public LogEntry(Object value, HyperGraph logDb, HGPersistentHandle handle, StorageService.Operation operation) {
        this.handle = handle;
        if (operation != StorageService.Operation.Remove) {
            if (logDb.getStore().containsLink(handle)) {
                logDb.replace(handle, value);
            } else {
                logDb.define(handle, value);
            }
            this.logEntryHandle = logDb.getPersistentHandle(handle);
            this.data = new HGStoreSubgraph(this.logEntryHandle, logDb.getStore());
        } else {
            this.logEntryHandle = logDb.getPersistentHandle(handle);
        }
        this.operation = operation;
    }

    public LogEntry(HGHandle handle, HyperGraph logDb, Timestamp timestamp) {
        this.logEntryHandle = logDb.getPersistentHandle(handle);
        this.timestamp = timestamp;
        this.data = new HGStoreSubgraph(this.logEntryHandle, logDb.getStore());
    }

    public StorageGraph getData() {
        return this.data;
    }

    public void setData(StorageGraph data) {
        this.data = data;
    }

    public HGPersistentHandle getLogEntryHandle() {
        return this.logEntryHandle;
    }

    public void setLogEntryHandle(HGPersistentHandle logEntryHandle) {
        this.logEntryHandle = logEntryHandle;
    }

    public void setTimestamp(Timestamp timestamp) {
        this.timestamp = timestamp;
    }

    public Timestamp getTimestamp() {
        return this.timestamp;
    }

    public void setLastTimestamp(HGPeerIdentity targetId, Timestamp timestamp) {
        this.lastTimestamps.put(targetId, timestamp);
    }

    public Timestamp getLastTimestamp(HGPeerIdentity targetId) {
        return this.lastTimestamps.get(targetId);
    }

    public StorageService.Operation getOperation() {
        return this.operation;
    }

    public void setOperation(StorageService.Operation operation) {
        this.operation = operation;
    }

    public HGPersistentHandle getHandle() {
        return this.handle;
    }

    public void setHandle(HGPersistentHandle handle) {
        this.handle = handle;
    }

    @Override
    public int compareTo(LogEntry value) {
        if (value == null) {
            return 1;
        }
        return this.timestamp.compareTo(value.getTimestamp());
    }
}

