/*
 * Decompiled with CFR 0.152.
 */
package org.hypergraphdb.peer.log;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import org.hypergraphdb.HGHandle;
import org.hypergraphdb.HGPersistentHandle;
import org.hypergraphdb.HGPlainLink;
import org.hypergraphdb.HGQuery;
import org.hypergraphdb.HGSearchResult;
import org.hypergraphdb.HyperGraph;
import org.hypergraphdb.peer.HGPeerIdentity;
import org.hypergraphdb.peer.PeerInterface;
import org.hypergraphdb.peer.StorageService;
import org.hypergraphdb.peer.log.LogEntry;
import org.hypergraphdb.peer.log.Peer;
import org.hypergraphdb.peer.log.Timestamp;
import org.hypergraphdb.query.And;
import org.hypergraphdb.query.AtomPartCondition;
import org.hypergraphdb.query.AtomTypeCondition;
import org.hypergraphdb.query.ComparisonOperator;
import org.hypergraphdb.query.HGAtomPredicate;

public class Log {
    public static final HGPersistentHandle LATEST_VERSION_HANDLE = null;
    private HyperGraph logDb;
    private HashMap<HGPeerIdentity, Peer> peers = new HashMap();
    private HashMap<Object, HGHandle> peerHandles = new HashMap();
    private PeerInterface peerInterface;
    private HashMap<Object, HashMap<Timestamp, Timestamp>> peerQueues = new HashMap();
    private Timestamp timestamp;

    public Log(HyperGraph logDb, PeerInterface peerInterface) {
        this.logDb = logDb;
        this.peerInterface = peerInterface;
        byte[] data = logDb.getStore().getData(LATEST_VERSION_HANDLE);
        if (data == null) {
            System.out.println("LATEST_VERSION_HANDLE not found");
            this.timestamp = new Timestamp();
            HGPersistentHandle handle = logDb.getPersistentHandle(logDb.add(this.timestamp));
            logDb.getStore().store(LATEST_VERSION_HANDLE, handle.toByteArray());
        } else {
            HGPersistentHandle handle = logDb.getHandleFactory().makeHandle(data);
            this.timestamp = (Timestamp)logDb.get(handle);
            System.out.println("LATEST_VERSION_HANDLE : " + this.timestamp);
        }
        this.timestamp.moveNext();
    }

    public LogEntry createLogEntry(HGPersistentHandle handle, Object value, StorageService.Operation operation) {
        LogEntry entry = new LogEntry(value, this.logDb, handle, operation);
        return entry;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LogEntry addEntry(LogEntry entry, Iterator<Object> targets) {
        Timestamp timestamp = this.timestamp;
        synchronized (timestamp) {
            Timestamp entryTimestamp = this.timestamp.moveNext();
            entry.setTimestamp(entryTimestamp);
            HGHandle timestampHandle = this.logDb.add(entryTimestamp);
            this.logDb.getStore().store(LATEST_VERSION_HANDLE, this.logDb.getPersistentHandle(timestampHandle).toByteArray());
            HGHandle opHandle = this.logDb.add((Object)entry.operation);
            this.logDb.add(new HGPlainLink(timestampHandle, entry.getLogEntryHandle(), opHandle));
            while (targets.hasNext()) {
                Object target = targets.next();
                HGPeerIdentity targetId = this.peerInterface.getThisPeer().getIdentity(target);
                Peer peer = this.getPeer(targetId);
                HGPlainLink link = new HGPlainLink(this.peerHandles.get(targetId), entry.getLogEntryHandle());
                this.logDb.add(link);
                entry.setLastTimestamp(targetId, peer.getTimestamp());
                peer.setTimestamp(entryTimestamp);
                this.logDb.replace(this.peerHandles.get(targetId), peer);
                System.out.println(entry.getLastTimestamp(targetId));
            }
        }
        return entry;
    }

    public void purge() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void confirmFromPeer(HGPeerIdentity targetId, Timestamp timestamp) {
        Peer peer = this.getPeer(targetId);
        Timestamp timestamp2 = timestamp;
        synchronized (timestamp2) {
            Timestamp oldTimestamp = peer.getLastConfirmedTimestamp();
            if (oldTimestamp.compareTo(timestamp) < 0) {
                peer.setLastConfirmedTimestamp(timestamp);
                this.logDb.replace(this.peerHandles.get(targetId), peer);
            }
        }
    }

    private Peer getPeer(HGPeerIdentity targetId) {
        Peer peer = this.peers.get(targetId);
        if (peer == null) {
            HGHandle peerHandle;
            HGSearchResult peerSearchResult = this.logDb.find(new And(new AtomTypeCondition(Peer.class), new AtomPartCondition(new String[]{"peerId"}, targetId)));
            if (peerSearchResult.hasNext()) {
                peerHandle = (HGHandle)peerSearchResult.next();
                peer = (Peer)this.logDb.get(peerHandle);
            } else {
                peer = new Peer(targetId);
                peerHandle = this.logDb.add(peer);
            }
            this.peers.put(targetId, peer);
            this.peerHandles.put(targetId, peerHandle);
        }
        return peer;
    }

    public Timestamp getLastFrom(Object peer) {
        return this.getPeer(this.peerInterface.getThisPeer().getIdentity(peer)).getLastFrom();
    }

    public boolean registerRequest(HGPeerIdentity peerId, Timestamp last_version, Timestamp current_version) {
        Peer peer = this.getPeer(peerId);
        if (peer.getLastFrom().compareTo(last_version) != 0) {
            // empty if block
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void finishRequest(HGPeerIdentity peerId, Timestamp last_version, Timestamp current_version) {
        Timestamp timestamp = this.timestamp;
        synchronized (timestamp) {
            Peer peer = this.getPeer(peerId);
            peer.setLastFrom(current_version);
            this.logDb.replace(this.peerHandles.get(peerId), peer);
            HashMap<Timestamp, Timestamp> queue = this.getPeerQueue(peerId, false);
            if (queue != null && queue.containsKey(last_version)) {
                queue.get(last_version).notify();
                queue.remove(last_version);
            }
        }
    }

    private HashMap<Timestamp, Timestamp> getPeerQueue(Object peerId, boolean createNew) {
        HashMap<Timestamp, Timestamp> queue = this.peerQueues.get(peerId);
        if (queue == null && createNew) {
            queue = new HashMap();
            this.peerQueues.put(peerId, queue);
        }
        return queue;
    }

    public ArrayList<LogEntry> getLogEntries(Timestamp startingFrom, HGAtomPredicate interest) {
        ArrayList<LogEntry> result = new ArrayList<LogEntry>();
        HGSearchResult timestamps = this.logDb.find(HGQuery.hg.and(HGQuery.hg.type(Timestamp.class), HGQuery.hg.value(startingFrom, ComparisonOperator.LT)));
        while (timestamps.hasNext()) {
            HGHandle handle = (HGHandle)timestamps.next();
            for (HGHandle linkHandle : this.logDb.getIncidenceSet(handle)) {
                HGPlainLink link = (HGPlainLink)this.logDb.get(linkHandle);
                if (link.getArity() <= 1 || !interest.satisfies(this.logDb, link.getTargetAt(1))) continue;
                Timestamp ts = (Timestamp)this.logDb.get(handle);
                LogEntry entry = new LogEntry(link.getTargetAt(1), this.logDb, ts);
                entry.setOperation((StorageService.Operation)((Object)this.logDb.get(link.getTargetAt(2))));
                result.add(entry);
            }
        }
        return result;
    }
}

