/*
 * Decompiled with CFR 0.152.
 */
package org.hypergraphdb.peer.cact;

import java.util.UUID;
import org.hypergraphdb.HGPersistentHandle;
import org.hypergraphdb.algorithms.CopyGraphTraversal;
import org.hypergraphdb.algorithms.DefaultALGenerator;
import org.hypergraphdb.algorithms.HGTraversal;
import org.hypergraphdb.algorithms.HyperTraversal;
import org.hypergraphdb.peer.HGPeerIdentity;
import org.hypergraphdb.peer.HyperGraphPeer;
import org.hypergraphdb.peer.Message;
import org.hypergraphdb.peer.Messages;
import org.hypergraphdb.peer.Performative;
import org.hypergraphdb.peer.Structs;
import org.hypergraphdb.peer.SubgraphManager;
import org.hypergraphdb.peer.workflow.FSMActivity;
import org.hypergraphdb.peer.workflow.FromState;
import org.hypergraphdb.peer.workflow.OnMessage;
import org.hypergraphdb.peer.workflow.PossibleOutcome;
import org.hypergraphdb.peer.workflow.WorkflowState;
import org.hypergraphdb.peer.workflow.WorkflowStateConstant;
import org.hypergraphdb.util.Mapping;
import org.hypergraphdb.util.Pair;

public class TransferGraph
extends FSMActivity {
    public static final String TYPENAME = "transfer-graph";
    private HGPeerIdentity target;
    private HGTraversal traversal;
    private Mapping<Pair<HGPersistentHandle, Object>, HGPersistentHandle> atomFinder = null;
    private boolean trace = true;

    public TransferGraph(HyperGraphPeer thisPeer, UUID id) {
        super(thisPeer, id);
    }

    public TransferGraph(HyperGraphPeer thisPeer, HGTraversal traversal, HGPeerIdentity target) {
        super(thisPeer);
        this.traversal = traversal;
        this.target = target;
    }

    public TransferGraph(HyperGraphPeer thisPeer, HGTraversal traversal, HGPeerIdentity target, Mapping<Pair<HGPersistentHandle, Object>, HGPersistentHandle> atomFinder) {
        this(thisPeer, traversal, target);
        this.atomFinder = atomFinder;
    }

    @Override
    public void initiate() {
        Message msg = Messages.createMessage(Performative.QueryRef, this);
        Structs.combine(msg, Structs.struct("content", this.traversal));
        this.send(this.target, msg);
        if (this.trace) {
            this.getThisPeer().getGraph().getLogger().trace("Query graph transfer for : " + this.traversal);
        }
    }

    @FromState(value={"Started"})
    @OnMessage(performative="QueryRef")
    @PossibleOutcome(value={"Completed"})
    public WorkflowStateConstant onQueryRef(Message msg) throws Throwable {
        this.traversal = (HGTraversal)Structs.getPart(msg, "content");
        CopyGraphTraversal copyTraversal = null;
        if (this.traversal instanceof CopyGraphTraversal) {
            copyTraversal = (CopyGraphTraversal)this.traversal;
        } else if (this.traversal instanceof HyperTraversal) {
            ((HyperTraversal)this.traversal).setHyperGraph(this.getThisPeer().getGraph());
            copyTraversal = (CopyGraphTraversal)((HyperTraversal)this.traversal).getFlatTraversal();
        } else {
            throw new Exception("Expecting a CopyGraphTraversal or a HyperTraversal.");
        }
        if (this.trace) {
            this.getThisPeer().getGraph().getLogger().trace("Recevied request for traversal : " + copyTraversal);
        }
        ((DefaultALGenerator)copyTraversal.getAdjListGenerator()).setGraph(this.getThisPeer().getGraph());
        Message reply = Messages.getReply(msg, Performative.InformRef);
        Object subgraph = SubgraphManager.getTransferGraphRepresentation(this.getThisPeer().getGraph(), this.traversal);
        Structs.combine(reply, Structs.struct("content", subgraph));
        this.send(Messages.getSender(msg), reply);
        if (this.trace) {
            this.getThisPeer().getGraph().getLogger().trace("Sent response to traversal : " + copyTraversal);
        }
        return WorkflowState.Completed;
    }

    @FromState(value={"Started"})
    @OnMessage(performative="InformRef")
    @PossibleOutcome(value={"Completed"})
    public WorkflowStateConstant onInformRef(Message msg) throws ClassNotFoundException {
        if (this.trace) {
            this.getThisPeer().getGraph().getLogger().trace("Received response for traversal : " + this.traversal);
        }
        SubgraphManager.writeTransferedGraph(Structs.getPart(msg, "content"), this.getThisPeer().getGraph(), this.atomFinder);
        if (this.trace) {
            this.getThisPeer().getGraph().getLogger().trace("Successfully stored graph for : " + this.traversal);
        }
        return WorkflowState.Completed;
    }

    @Override
    public String getType() {
        return TYPENAME;
    }
}

