/*
 * Decompiled with CFR 0.152.
 */
package org.hypergraphdb.peer;

import java.io.File;
import java.io.FileWriter;
import java.lang.reflect.Array;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.Callable;
import org.hypergraphdb.HGException;
import org.hypergraphdb.HGHandle;
import org.hypergraphdb.HGIndex;
import org.hypergraphdb.HGLink;
import org.hypergraphdb.HGPersistentHandle;
import org.hypergraphdb.HGRandomAccessResult;
import org.hypergraphdb.HGStore;
import org.hypergraphdb.HyperGraph;
import org.hypergraphdb.ReadyRef;
import org.hypergraphdb.algorithms.CopyGraphTraversal;
import org.hypergraphdb.algorithms.HGTraversal;
import org.hypergraphdb.algorithms.HyperTraversal;
import org.hypergraphdb.peer.Structs;
import org.hypergraphdb.storage.BAtoHandle;
import org.hypergraphdb.storage.HGStoreSubgraph;
import org.hypergraphdb.storage.RAMStorageGraph;
import org.hypergraphdb.storage.StorageGraph;
import org.hypergraphdb.transaction.HGTransactionConfig;
import org.hypergraphdb.type.HGAtomType;
import org.hypergraphdb.util.FilterIterator;
import org.hypergraphdb.util.HGUtils;
import org.hypergraphdb.util.Mapping;
import org.hypergraphdb.util.Pair;

public class SubgraphManager {
    public static void dumpGraphToFile(File file, StorageGraph graph, boolean outputByteBuffers) {
        try {
            FileWriter out = new FileWriter(file);
            TreeMap<HGPersistentHandle, Object> sorted = new TreeMap<HGPersistentHandle, Object>();
            for (Pair<HGPersistentHandle, Object> p : graph) {
                sorted.put(p.getFirst(), p.getSecond());
            }
            for (HGPersistentHandle h : sorted.keySet()) {
                int i;
                out.write(h.toString() + "=[");
                Object x = sorted.get(h);
                if (x instanceof HGPersistentHandle[]) {
                    HGPersistentHandle[] link = (HGPersistentHandle[])x;
                    for (i = 0; i < link.length; ++i) {
                        out.write(link[i].toString());
                        if (i >= link.length - 1) continue;
                        out.write(",");
                    }
                } else {
                    byte[] A = (byte[])x;
                    if (outputByteBuffers) {
                        for (i = 0; i < A.length; ++i) {
                            out.write(Byte.toString(A[i]));
                            if (i >= A.length - 1) continue;
                            out.write(",");
                        }
                    } else {
                        out.write("byte[]");
                    }
                }
                out.write("]\n");
            }
            out.close();
        }
        catch (Exception ex) {
            System.err.println(ex);
        }
    }

    public static void store(StorageGraph subgraph, HGStore store) {
        SubgraphManager.store(subgraph, store, new HashMap<HGPersistentHandle, HGPersistentHandle>());
    }

    public static void store(final StorageGraph subgraph, final HGStore store, final Map<HGPersistentHandle, HGPersistentHandle> substitute) {
        store.getTransactionManager().transact(new Callable<Object>(){

            @Override
            public Object call() {
                for (Pair<HGPersistentHandle, Object> item : subgraph) {
                    if (substitute.containsKey(item.getFirst())) continue;
                    if (item.getSecond() instanceof byte[]) {
                        store.store(item.getFirst(), (byte[])item.getSecond());
                        continue;
                    }
                    HGPersistentHandle[] layout = (HGPersistentHandle[])item.getSecond();
                    for (int i = 0; i < layout.length; ++i) {
                        HGPersistentHandle h = (HGPersistentHandle)substitute.get(layout[i]);
                        if (h == null) continue;
                        layout[i] = h;
                    }
                    store.store(item.getFirst(), layout);
                }
                return null;
            }
        }, HGTransactionConfig.DEFAULT);
    }

    public static Object get(StorageGraph subgraph, HyperGraph graph) {
        SubgraphManager.store(subgraph, graph.getStore());
        HGPersistentHandle theRoot = subgraph.getRoots().iterator().next();
        Object result = graph.get(theRoot);
        graph.remove(theRoot);
        return result;
    }

    public static Object getTransferAtomRepresentation(HyperGraph graph, HGHandle atom) {
        HGPersistentHandle pHandle = graph.getPersistentHandle(atom);
        if (graph.getStore().containsLink(pHandle)) {
            HGStoreSubgraph rawGraph = new HGStoreSubgraph(pHandle, graph.getStore());
            AtomFilteringSubgraph atomGraph = new AtomFilteringSubgraph(graph, rawGraph);
            HashMap<String, String> types = new HashMap<String, String>();
            for (Pair<HGPersistentHandle, Object> p : rawGraph) {
                String clname;
                if (p == null || (clname = graph.getTypeSystem().getClassNameForType(p.getFirst())) == null) continue;
                types.put(p.getFirst().toString(), clname);
            }
            return Structs.struct("storage-graph", Structs.object(atomGraph), "type-classes", types);
        }
        return Structs.struct(new Object[0]);
    }

    public static Object getTransferGraphRepresentation(HyperGraph graph, HGTraversal traversal) {
        HGStoreSubgraph rawGraph;
        HashSet<HGPersistentHandle> roots = new HashSet<HGPersistentHandle>();
        CopyGraphTraversal copyTraversal = null;
        if (traversal instanceof CopyGraphTraversal) {
            copyTraversal = (CopyGraphTraversal)traversal;
        } else if (traversal instanceof HyperTraversal) {
            copyTraversal = (CopyGraphTraversal)((HyperTraversal)traversal).getFlatTraversal();
        } else {
            throw new RuntimeException("Expecting a CopyGraphTraversal or a HyperTraversal.");
        }
        roots.add(graph.getPersistentHandle(copyTraversal.getStartAtom()));
        while (traversal.hasNext()) {
            Pair<HGHandle, HGHandle> link = traversal.next();
            roots.add(graph.getPersistentHandle(link.getFirst()));
            roots.add(graph.getPersistentHandle(link.getSecond()));
        }
        HGStoreSubgraph atomGraph = rawGraph = new HGStoreSubgraph(roots, graph.getStore());
        HashMap<String, String> types = new HashMap<String, String>();
        for (Pair<HGPersistentHandle, Object> p : rawGraph) {
            String clname;
            if (p == null || (clname = graph.getTypeSystem().getClassNameForType(p.getFirst())) == null) continue;
            types.put(p.getFirst().toString(), clname);
        }
        return Structs.struct("storage-graph", Structs.object(atomGraph), "type-classes", types);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static int translateBatch(HyperGraph graph, Set<HGPersistentHandle> batch, RAMStorageGraph subgraph, Map<HGPersistentHandle, Object> objects, Mapping<Pair<HGPersistentHandle, Object>, HGPersistentHandle> atomFinder, Map<HGPersistentHandle, HGPersistentHandle> substitutes) {
        int replacements = 0;
        for (HGPersistentHandle atom : batch) {
            HGPersistentHandle existing;
            HGPersistentHandle[] layout = subgraph.getLink(atom);
            Object object = null;
            graph.getStore().attachOverlayGraph(subgraph);
            try {
                HGHandle[] targetSet = new HGHandle[layout.length - 2];
                System.arraycopy(layout, 2, targetSet, 0, layout.length - 2);
                HGAtomType type = (HGAtomType)graph.get(layout[0]);
                object = type.make(layout[1], new ReadyRef<HGHandle[]>(targetSet), null);
            }
            finally {
                graph.getStore().detachOverlayGraph();
            }
            HGPersistentHandle hGPersistentHandle = existing = atomFinder == null ? null : atomFinder.eval(new Pair<HGPersistentHandle, Object>(atom, object));
            if (existing != null) {
                substitutes.put(atom, existing);
                if (existing.equals(atom)) continue;
                ++replacements;
                continue;
            }
            objects.put(atom, object);
        }
        return replacements;
    }

    private static Set<HGPersistentHandle> translateAtoms(final HyperGraph graph, final RAMStorageGraph subgraph, final Map<HGPersistentHandle, Object> objects, final Mapping<Pair<HGPersistentHandle, Object>, HGPersistentHandle> atomFinder) {
        HashMap<HGPersistentHandle, HGPersistentHandle> substitutes = new HashMap<HGPersistentHandle, HGPersistentHandle>();
        final HashSet<HGPersistentHandle> batch = new HashSet<HGPersistentHandle>();
        final HashMap<HGPersistentHandle, HGPersistentHandle> currentChanges = new HashMap<HGPersistentHandle, HGPersistentHandle>();
        final int[] replacements = new int[]{0};
        do {
            currentChanges.clear();
            for (HGPersistentHandle theRoot : subgraph.getRoots()) {
                if (!substitutes.containsKey(theRoot)) {
                    batch.add(theRoot);
                }
                if (batch.size() < 200) continue;
                graph.getTransactionManager().transact(new Callable<Object>(){

                    @Override
                    public Object call() {
                        replacements[0] = replacements[0] + SubgraphManager.translateBatch(graph, batch, subgraph, objects, atomFinder, currentChanges);
                        batch.clear();
                        return null;
                    }
                }, HGTransactionConfig.DEFAULT);
            }
            graph.getTransactionManager().transact(new Callable<Object>(){

                @Override
                public Object call() {
                    replacements[0] = replacements[0] + SubgraphManager.translateBatch(graph, batch, subgraph, objects, atomFinder, currentChanges);
                    return null;
                }
            }, HGTransactionConfig.DEFAULT);
            subgraph.translateHandles(currentChanges);
            substitutes.putAll(currentChanges);
        } while (replacements[0] > 0);
        return substitutes.keySet();
    }

    public static Set<HGHandle> writeTransferedGraph(Object atom, HyperGraph graph) throws ClassNotFoundException {
        return SubgraphManager.writeTransferedGraph(atom, graph, null);
    }

    public static Set<HGHandle> writeTransferedGraph(Object atom, HyperGraph graph, Mapping<Pair<HGPersistentHandle, Object>, HGPersistentHandle> atomFinder) throws ClassNotFoundException {
        RAMStorageGraph subgraph = (RAMStorageGraph)Structs.getPart(atom, "storage-graph");
        Map typeClasses = (Map)Structs.getPart(atom, "type-classes");
        HashMap<HGPersistentHandle, HGPersistentHandle> substituteTypes = new HashMap<HGPersistentHandle, HGPersistentHandle>();
        for (Map.Entry e : typeClasses.entrySet()) {
            HGPersistentHandle typeHandle = graph.getHandleFactory().makeHandle((String)e.getKey());
            String classname = (String)e.getValue();
            if (graph.get(typeHandle) != null) continue;
            Class<Object> clazz = null;
            if (classname.startsWith("[L")) {
                classname = classname.substring(2, classname.length() - 1);
                clazz = Array.newInstance(HGUtils.loadClass(graph, classname), 0).getClass();
            } else {
                clazz = HGUtils.loadClass(graph, classname);
            }
            HGHandle localType = graph.getTypeSystem().getTypeHandle(clazz);
            if (localType == null) {
                throw new HGException("Unable to create local type for Java class '" + classname + "'");
            }
            substituteTypes.put(typeHandle, graph.getPersistentHandle(localType));
        }
        subgraph.translateHandles(substituteTypes);
        HashMap<HGPersistentHandle, Object> objects = new HashMap<HGPersistentHandle, Object>();
        Set<HGPersistentHandle> ignoreAtoms = SubgraphManager.translateAtoms(graph, subgraph, objects, atomFinder);
        return SubgraphManager.storeObjectsTransaction(graph, subgraph, objects, ignoreAtoms);
    }

    private static Set<HGHandle> storeObjectsTransaction(final HyperGraph graph, final RAMStorageGraph subgraph, final Map<HGPersistentHandle, Object> objects, Set<HGPersistentHandle> ignoreAtoms) {
        HashSet<HGHandle> result = new HashSet<HGHandle>();
        final HashSet<HGPersistentHandle> batch = new HashSet<HGPersistentHandle>();
        for (HGPersistentHandle theRoot : subgraph.getRoots()) {
            if (ignoreAtoms.contains(theRoot)) continue;
            batch.add(theRoot);
            if (batch.size() != 200) continue;
            graph.getTransactionManager().transact(new Callable<Object>(){

                @Override
                public Object call() {
                    for (HGPersistentHandle atom : batch) {
                        HGPersistentHandle[] layout = subgraph.getLink(atom);
                        Object x = objects.get(atom);
                        if (layout.length > 2) {
                            for (int i = 2; i < layout.length; ++i) {
                                ((HGLink)x).notifyTargetHandleUpdate(i - 2, layout[i]);
                            }
                        }
                        graph.define(atom, layout[0], x, (byte)0);
                    }
                    return null;
                }
            }, HGTransactionConfig.DEFAULT);
            result.addAll(batch);
            batch.clear();
        }
        graph.getTransactionManager().transact(new Callable<Object>(){

            @Override
            public Object call() {
                for (HGPersistentHandle atom : batch) {
                    HGPersistentHandle[] layout = subgraph.getLink(atom);
                    Object x = objects.get(atom);
                    if (layout.length > 2) {
                        for (int i = 2; i < layout.length; ++i) {
                            ((HGLink)x).notifyTargetHandleUpdate(i - 2, layout[i]);
                        }
                    }
                    graph.define(atom, layout[0], x, (byte)0);
                }
                return null;
            }
        }, HGTransactionConfig.DEFAULT);
        result.addAll(batch);
        return result;
    }

    private static class AtomFilteringSubgraph
    implements StorageGraph {
        StorageGraph wrapped;
        HGIndex<HGPersistentHandle, HGPersistentHandle> indexByValue;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        boolean shouldIgnore(HGPersistentHandle handle, HGPersistentHandle[] result) {
            if (this.wrapped.getRoots().contains(handle) || result == null || result.length <= 1) {
                return false;
            }
            HGRandomAccessResult<HGPersistentHandle> rs = this.indexByValue.find(result[1]);
            try {
                boolean bl = rs.goTo(handle, true) == HGRandomAccessResult.GotoResult.found;
                return bl;
            }
            finally {
                rs.close();
            }
        }

        AtomFilteringSubgraph(HyperGraph graph, StorageGraph wrapped) {
            this.wrapped = wrapped;
            this.indexByValue = graph.getStore().getIndex("HGATOMVALUE", BAtoHandle.getInstance(graph.getHandleFactory()), BAtoHandle.getInstance(graph.getHandleFactory()), null, true);
        }

        @Override
        public byte[] getData(HGPersistentHandle handle) {
            return this.wrapped.getData(handle);
        }

        @Override
        public HGPersistentHandle[] getLink(HGPersistentHandle handle) {
            HGPersistentHandle[] result = this.wrapped.getLink(handle);
            return this.shouldIgnore(handle, result) ? null : result;
        }

        @Override
        public Set<HGPersistentHandle> getRoots() {
            return this.wrapped.getRoots();
        }

        @Override
        public Iterator<Pair<HGPersistentHandle, Object>> iterator() {
            return new FilterIterator<Pair<HGPersistentHandle, Object>>(this.wrapped.iterator(), new Mapping<Pair<HGPersistentHandle, Object>, Boolean>(){

                @Override
                public Boolean eval(Pair<HGPersistentHandle, Object> n) {
                    return n.getSecond() instanceof HGPersistentHandle[] && AtomFilteringSubgraph.this.shouldIgnore(n.getFirst(), (HGPersistentHandle[])n.getSecond());
                }
            });
        }
    }
}

