/*
 * Decompiled with CFR 0.152.
 */
package org.hypergraphdb.peer;

import java.beans.PropertyDescriptor;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import org.hypergraphdb.HGHandle;
import org.hypergraphdb.HGPersistentHandle;
import org.hypergraphdb.algorithms.CopyGraphTraversal;
import org.hypergraphdb.algorithms.DefaultALGenerator;
import org.hypergraphdb.algorithms.HGBreadthFirstTraversal;
import org.hypergraphdb.algorithms.HGDepthFirstTraversal;
import org.hypergraphdb.algorithms.HyperTraversal;
import org.hypergraphdb.algorithms.SimpleALGenerator;
import org.hypergraphdb.handle.HGLiveHandle;
import org.hypergraphdb.handle.PhantomHandle;
import org.hypergraphdb.handle.PhantomManagedHandle;
import org.hypergraphdb.handle.UUIDPersistentHandle;
import org.hypergraphdb.handle.WeakHandle;
import org.hypergraphdb.handle.WeakManagedHandle;
import org.hypergraphdb.peer.Message;
import org.hypergraphdb.peer.Performative;
import org.hypergraphdb.peer.log.Timestamp;
import org.hypergraphdb.peer.serializer.CustomSerializedValue;
import org.hypergraphdb.query.And;
import org.hypergraphdb.query.AnyAtomCondition;
import org.hypergraphdb.query.ArityCondition;
import org.hypergraphdb.query.AtomPartCondition;
import org.hypergraphdb.query.AtomProjectionCondition;
import org.hypergraphdb.query.AtomTypeCondition;
import org.hypergraphdb.query.AtomValueCondition;
import org.hypergraphdb.query.BFSCondition;
import org.hypergraphdb.query.DFSCondition;
import org.hypergraphdb.query.HGAtomPredicate;
import org.hypergraphdb.query.HGQueryCondition;
import org.hypergraphdb.query.IncidentCondition;
import org.hypergraphdb.query.LinkCondition;
import org.hypergraphdb.query.MapCondition;
import org.hypergraphdb.query.Not;
import org.hypergraphdb.query.Nothing;
import org.hypergraphdb.query.Or;
import org.hypergraphdb.query.OrderedLinkCondition;
import org.hypergraphdb.query.SubsumedCondition;
import org.hypergraphdb.query.SubsumesCondition;
import org.hypergraphdb.query.TargetCondition;
import org.hypergraphdb.query.TypePlusCondition;
import org.hypergraphdb.query.TypedValueCondition;
import org.hypergraphdb.query.impl.LinkProjectionMapping;
import org.hypergraphdb.type.BonesOfBeans;
import org.hypergraphdb.util.HGUtils;
import org.hypergraphdb.util.Pair;

public class Structs {
    private static final String OBJECT_TOKEN = "hgdb-json-java-object";
    private static Map<Class<?>, String> hgClassNames = new HashMap();
    private static Map<String, Class<?>> hgInvertedClassNames = new HashMap();
    private static Map<Class<?>, Pair<StructsMapper, String>> hgMappers = new HashMap();
    private static Map<String, StructsMapper> hgInvertedMappers = new HashMap<String, StructsMapper>();

    public static Object svalue(Object x) {
        return Structs.svalue(x, false, true, null);
    }

    public static Map<String, Object> struct(Object bean) {
        return Structs.struct(bean, false);
    }

    public static Map<String, Object> struct(Object ... args) {
        if (args == null) {
            return null;
        }
        HashMap<String, Object> m = new HashMap<String, Object>();
        if (args.length % 2 != 0) {
            throw new IllegalArgumentException("The arguments array to struct must be of even size: a flattened list of name/value pairs");
        }
        for (int i = 0; i < args.length; i += 2) {
            if (!(args[i] instanceof String)) {
                throw new IllegalArgumentException("An argument at the even position " + i + " is not a string.");
            }
            m.put((String)args[i], Structs.svalue(args[i + 1], false, true, null));
        }
        return m;
    }

    public static List<Object> list(Object ... args) {
        ArrayList<Object> l = new ArrayList<Object>();
        if (args == null) {
            return l;
        }
        for (Object x : args) {
            l.add(Structs.svalue(x));
        }
        return l;
    }

    public static Object object(Object value) {
        return new CustomSerializedValue(value);
    }

    private static Class<?> loadClass(String name) {
        try {
            return Class.forName(name);
        }
        catch (Exception ex) {
            try {
                return Thread.currentThread().getContextClassLoader().loadClass(name);
            }
            catch (Exception ex2) {
                throw new RuntimeException(ex);
            }
        }
    }

    private static Object svalue(Object x, boolean skipSpecialClasses, boolean addClassName, Class<?> propertyType) {
        if (!skipSpecialClasses && (x instanceof HGQueryCondition || x instanceof HGAtomPredicate)) {
            return Structs.hgQueryOrPredicate(x);
        }
        if (x instanceof Performative) {
            return x.toString();
        }
        if (x instanceof byte[]) {
            return new CustomSerializedValue(x);
        }
        if (x instanceof CustomSerializedValue) {
            return x;
        }
        if (x == null || x instanceof Boolean || x instanceof String || x instanceof Map) {
            return x;
        }
        if (x instanceof Number) {
            if (propertyType != null && !x.getClass().isAssignableFrom(propertyType)) {
                String typeName = Structs.getNumberType(x.getClass());
                if (typeName == null) {
                    return x;
                }
                return Structs.list(OBJECT_TOKEN, typeName, x);
            }
            return x;
        }
        if (hgMappers.containsKey(x.getClass())) {
            Pair<StructsMapper, String> mapper = hgMappers.get(x.getClass());
            return Structs.list(OBJECT_TOKEN, mapper.getSecond(), mapper.getFirst().getStruct(x));
        }
        if (hgClassNames.containsKey(x.getClass())) {
            if (!addClassName) {
                if (x instanceof List) {
                    return x;
                }
                return Structs.struct(x, false);
            }
            if (x instanceof List) {
                ArrayList<Object> l = new ArrayList<Object>();
                for (Object i : (List)x) {
                    l.add(Structs.svalue(i, false, addClassName, null));
                }
                return Structs.list(OBJECT_TOKEN, Structs.getClassName(x.getClass()), l);
            }
            return Structs.list(OBJECT_TOKEN, Structs.getClassName(x.getClass()), Structs.struct(x, true));
        }
        if (x.getClass().isArray()) {
            ArrayList<Object> l = new ArrayList<Object>();
            for (int i = 0; i < Array.getLength(x); ++i) {
                l.add(Structs.svalue(Array.get(x, i), false, addClassName, null));
            }
            return l;
        }
        if (x instanceof Enum) {
            return x.toString();
        }
        if (x instanceof Class) {
            return ((Class)x).getName();
        }
        if (x instanceof List) {
            ArrayList<Object> l = new ArrayList<Object>();
            for (Object i : (List)x) {
                l.add(Structs.svalue(i, false, addClassName, null));
            }
            return l;
        }
        if (x instanceof Collection) {
            ArrayList<Object> l = new ArrayList<Object>();
            for (Object i : (Collection)x) {
                l.add(Structs.svalue(i, false, addClassName, null));
            }
            return l;
        }
        if (!addClassName) {
            return Structs.struct(x, false);
        }
        return Structs.list(OBJECT_TOKEN, Structs.getClassName(x.getClass()), Structs.struct(x, true));
    }

    private static String getNumberType(Class<?> numberClass) {
        if (numberClass.equals(Integer.TYPE) || numberClass.equals(Integer.class)) {
            return "int";
        }
        if (numberClass.equals(Short.TYPE) || numberClass.equals(Short.class)) {
            return "short";
        }
        if (numberClass.equals(Byte.TYPE) || numberClass.equals(Byte.class)) {
            return "byte";
        }
        if (numberClass.equals(Long.TYPE) || numberClass.equals(Long.class)) {
            return "long";
        }
        if (numberClass.equals(Float.TYPE) || numberClass.equals(Float.class)) {
            return "float";
        }
        if (numberClass.equals(Double.TYPE) || numberClass.equals(Double.class)) {
            return "double";
        }
        return null;
    }

    private static Number getNumber(List<?> list) {
        if (list.size() < 3 || !(list.get(2) instanceof Number)) {
            return null;
        }
        String typeName = list.get(1).toString();
        Number n = (Number)list.get(2);
        if ("int".equals(typeName)) {
            return n.intValue();
        }
        if ("short".equals(typeName)) {
            return n.shortValue();
        }
        if ("byte".equals(typeName)) {
            return n.byteValue();
        }
        if ("long".equals(typeName)) {
            return n.longValue();
        }
        if ("float".equals(typeName)) {
            return Float.valueOf(n.floatValue());
        }
        if ("double".equals(typeName)) {
            return n.doubleValue();
        }
        return null;
    }

    private static Map<String, Object> struct(Object bean, boolean addClassName) {
        if (bean == null) {
            return null;
        }
        HashMap<String, Object> m = new HashMap<String, Object>();
        for (PropertyDescriptor desc : BonesOfBeans.getAllPropertyDescriptors(bean.getClass()).values()) {
            if (desc.getReadMethod() == null || desc.getWriteMethod() == null) continue;
            Object propvalue = BonesOfBeans.getProperty(bean, desc);
            m.put(desc.getName(), Structs.svalue(propvalue, false, addClassName, desc.getPropertyType()));
        }
        return m;
    }

    public static String getClassName(Class<?> clazz) {
        String name = hgClassNames.get(clazz);
        return name == null ? clazz.getName() : name;
    }

    public static synchronized void addMapper(Class<?> clazz, StructsMapper mapper, String name) {
        hgMappers.put(clazz, new Pair<StructsMapper, String>(mapper, name));
        hgInvertedMappers.put(name, mapper);
    }

    public static synchronized Pair<StructsMapper, String> getMapper(Class<?> clazz) {
        return hgMappers.get(clazz);
    }

    public static HGQueryCondition getHGQueryCondition(Object value, Object ... args) {
        Object result = Structs.getPart(value, args);
        if (result instanceof HGQueryCondition) {
            return (HGQueryCondition)result;
        }
        return null;
    }

    public static HGAtomPredicate getHGAtomPredicate(Object value, Object ... args) {
        Object result = Structs.getPart(value, args);
        if (result instanceof HGAtomPredicate) {
            return (HGAtomPredicate)result;
        }
        return null;
    }

    public static <T> T getPart(Object source, Object ... args) {
        if (args == null) {
            return null;
        }
        if (args.length == 0) {
            return (T)Structs.createObject(source);
        }
        if (args.length == 1) {
            return (T)Structs.getStructPart(source, args[0]);
        }
        ArrayList<Object> l = new ArrayList<Object>();
        for (Object x : args) {
            l.add(x);
        }
        return (T)Structs.getStructPart(source, l, 0);
    }

    public static Map<String, Object> getStruct(Object source, Object ... args) {
        return (Map)Structs.getPart(source, args);
    }

    public static boolean hasPart(Object source, Object ... args) {
        if (args == null || source == null) {
            return false;
        }
        if (args.length == 0) {
            return true;
        }
        if (args.length == 1) {
            return Structs.hasStructPart(source, args[0]);
        }
        ArrayList<Object> l = new ArrayList<Object>();
        for (Object x : args) {
            l.add(x);
        }
        return Structs.hasStructPart(source, l, 0);
    }

    public static <T> T getOptPart(Object source, T defaultValue, Object ... args) {
        if (source == null) {
            return defaultValue;
        }
        if (Structs.hasPart(source, args)) {
            defaultValue = Structs.getPart(source, args);
        }
        return defaultValue;
    }

    private static boolean hasStructPart(Object source, Object path, int pos) {
        if (!(path instanceof List)) {
            return Structs.hasStructPart(source, path);
        }
        List list = (List)path;
        if (list.size() < pos || pos < 0) {
            return false;
        }
        boolean hasPart = Structs.hasStructPart(source, list.get(pos));
        if (hasPart) {
            if (pos == list.size()) {
                return true;
            }
            return Structs.hasStructPart(Structs.getStructPart(source, list.get(pos)), path, pos + 1);
        }
        return false;
    }

    private static Object getStructPart(Object source, Object path, int pos) {
        if (!(path instanceof List)) {
            return Structs.getStructPart(source, path);
        }
        List list = (List)path;
        if (list.size() < pos || pos < 0) {
            return null;
        }
        Object part = Structs.getStructPart(source, list.get(pos));
        if (++pos == list.size()) {
            return Structs.createObject(part);
        }
        return Structs.getStructPart(part, path, pos);
    }

    private static boolean hasStructPart(Object source, Object position) {
        if (source instanceof Map) {
            return ((Map)source).containsKey(position.toString());
        }
        if (source instanceof List) {
            Integer listPos = (Integer)position;
            return listPos >= 0 && listPos < ((List)source).size();
        }
        return false;
    }

    private static Object getStructPart(Object source, Object position) {
        if (source instanceof Map) {
            return Structs.createObject(((Map)source).get(position.toString()));
        }
        if (source instanceof List) {
            return Structs.createObject(((List)source).get((Integer)position));
        }
        return Structs.createObject(source);
    }

    private static Object createObject(Object source) {
        if (source == null) {
            return null;
        }
        if (source instanceof CustomSerializedValue) {
            return ((CustomSerializedValue)source).get();
        }
        if (source instanceof List) {
            List data = (List)source;
            if (data.size() == 3 && OBJECT_TOKEN.equals(data.get(0))) {
                String className = (String)data.get(1);
                if (hgInvertedMappers.containsKey(className)) {
                    return hgInvertedMappers.get(className).getObject(data.get(2));
                }
                Number num = Structs.getNumber(data);
                if (num != null) {
                    return num;
                }
                Class<?> clazz = Structs.getBeanClass(className);
                if (clazz == null) {
                    return source;
                }
                return Structs.createObject(data, clazz);
            }
            ArrayList<Object> result = new ArrayList<Object>();
            for (Object o : data) {
                result.add(Structs.createObject(o));
            }
            return result;
        }
        return source;
    }

    private static Class<?> getBeanClass(String className) {
        Class<?> result = null;
        result = hgInvertedClassNames.get(className);
        if (result == null) {
            result = Structs.loadClass(className);
        }
        return result;
    }

    private static Object createObject(List<Object> data, Class<?> clazz) {
        Object result = null;
        try {
            result = clazz.newInstance();
            if (data.get(2) instanceof Map) {
                Map properties = (Map)data.get(2);
                Structs.loadMapValues(result, properties);
            } else if (result instanceof List) {
                List values = (List)data.get(2);
                Structs.loadListValues(result, values);
            }
        }
        catch (Throwable e) {
            HGUtils.throwRuntimeException(e);
        }
        return result;
    }

    public static void loadListValues(List<Object> destination, List<Object> source) {
        for (Object x : source) {
            destination.add(Structs.createObject(x));
        }
    }

    public static void loadMapValues(Object bean, Map<String, Object> properties) {
        for (Map.Entry<String, Object> entry : properties.entrySet()) {
            PropertyDescriptor descriptor = BonesOfBeans.getPropertyDescriptor(bean, entry.getKey());
            Class<?> propertyClass = descriptor.getPropertyType();
            Object value = Structs.createObject(entry.getValue());
            if (value instanceof Long) {
                value = Structs.getValueForProperty(propertyClass, (Long)value);
            } else if (value instanceof ArrayList && !propertyClass.isAssignableFrom(value.getClass())) {
                value = Structs.getValueForProperty(propertyClass, (ArrayList)value);
            } else if (propertyClass.isEnum()) {
                value = Enum.valueOf(propertyClass, value.toString());
            } else if (propertyClass.equals(Class.class) && value != null) {
                value = Structs.loadClass(value.toString());
            }
            BonesOfBeans.setProperty(bean, entry.getKey(), value);
        }
    }

    private static Object getValueForProperty(Class<?> propertyClass, Long number) {
        if (propertyClass.equals(Long.class) || propertyClass.equals(Long.TYPE)) {
            return number;
        }
        if (propertyClass.equals(Integer.class) || propertyClass.equals(Integer.TYPE)) {
            return number.intValue();
        }
        if (propertyClass.equals(Short.class) || propertyClass.equals(Short.TYPE)) {
            return number.shortValue();
        }
        if (propertyClass.equals(Byte.class) || propertyClass.equals(Byte.TYPE)) {
            return number.byteValue();
        }
        return number;
    }

    private static Object getValueForProperty(Class<?> propertyClass, ArrayList list) {
        if (propertyClass.isArray()) {
            Object array = Array.newInstance(propertyClass.getComponentType(), list.size());
            for (int i = 0; i < list.size(); ++i) {
                Object elem = Structs.createObject(list.get(i));
                Array.set(array, i, elem);
            }
            return array;
        }
        if (Collection.class.isAssignableFrom(propertyClass)) {
            if (propertyClass.isAssignableFrom(List.class)) {
                return list;
            }
            if (propertyClass.isAssignableFrom(Set.class)) {
                HashSet<Object> set = new HashSet<Object>();
                for (Object x : list) {
                    set.add(Structs.createObject(x));
                }
                return set;
            }
            Collection col = null;
            try {
                col = (Collection)propertyClass.newInstance();
                for (Object x : list) {
                    col.add(Structs.createObject(x));
                }
            }
            catch (InstantiationException e) {
                e.printStackTrace();
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
            return col;
        }
        return Structs.createObject(list);
    }

    public static List<Object> hgQueryOrPredicate(Object x) {
        if (x == null) {
            return null;
        }
        String name = Structs.getClassName(x.getClass());
        if (name == null) {
            throw new IllegalArgumentException("Unknown HyperGraph query condition or atom predicate type '" + x.getClass().getName() + "'");
        }
        return (List)Structs.svalue(x, true, true, null);
    }

    public static List<Object> hgQuery(HGQueryCondition condition) {
        return Structs.hgQueryOrPredicate(condition);
    }

    public static List<Object> hgPredicate(HGAtomPredicate predicate) {
        return Structs.hgQueryOrPredicate(predicate);
    }

    public static Map<String, Object> merge(Map<String, Object> m1, Map<String, Object> m2) {
        HashMap<String, Object> m = new HashMap<String, Object>();
        if (m1 != null) {
            m.putAll(m1);
        }
        if (m2 != null) {
            m.putAll(m2);
        }
        return m;
    }

    public List<Object> append(List<Object> l1, List<Object> l2) {
        ArrayList<Object> l = new ArrayList<Object>();
        if (l1 != null) {
            l.addAll(l1);
        }
        if (l2 != null) {
            l.addAll(l2);
        }
        return l;
    }

    public static Message combine(Message msg, Map<String, Object> s) {
        msg.putAll((Map<? extends String, ? extends Object>)s);
        return msg;
    }

    public static <T> T combine(T o1, T o2) {
        if (o1 instanceof Map) {
            if (o2 instanceof Map) {
                ((Map)o1).putAll((Map)o2);
            }
        } else if (o1 instanceof List) {
            if (o2 instanceof List) {
                ((List)o1).addAll((List)o2);
            } else {
                ((List)o1).add(o2);
            }
        }
        return o1;
    }

    static {
        hgClassNames.put(And.class, "and");
        hgClassNames.put(AnyAtomCondition.class, "any");
        hgClassNames.put(ArityCondition.class, "arity");
        hgClassNames.put(AtomPartCondition.class, "part");
        hgClassNames.put(AtomProjectionCondition.class, "proj");
        hgClassNames.put(AtomTypeCondition.class, "type");
        hgClassNames.put(AtomValueCondition.class, "value");
        hgClassNames.put(BFSCondition.class, "bfs");
        hgClassNames.put(DFSCondition.class, "dfs");
        hgClassNames.put(IncidentCondition.class, "incident");
        hgClassNames.put(Not.class, "not");
        hgClassNames.put(Or.class, "or");
        hgClassNames.put(OrderedLinkCondition.class, "orderedLink");
        hgClassNames.put(SubsumedCondition.class, "subsumed");
        hgClassNames.put(SubsumesCondition.class, "subsumes");
        hgClassNames.put(TargetCondition.class, "target");
        hgClassNames.put(TypedValueCondition.class, "typedValue");
        hgClassNames.put(TypePlusCondition.class, "typePlus");
        hgClassNames.put(Nothing.class, "nothing");
        hgClassNames.put(MapCondition.class, "mapCond");
        hgClassNames.put(LinkProjectionMapping.class, "linkProj");
        hgClassNames.put(Timestamp.class, "time");
        hgClassNames.put(LinkCondition.class, "link");
        for (Map.Entry<Class<?>, String> entry : hgClassNames.entrySet()) {
            hgInvertedClassNames.put(entry.getValue(), entry.getKey());
        }
        Structs.addMapper(UUID.class, new UUIDStructsMapper(), "uuid");
        Structs.addMapper(UUIDPersistentHandle.class, new HandleMapper(), "persistent-handle");
        Structs.addMapper(PhantomManagedHandle.class, new HandleMapper(), "live-managed-handle");
        Structs.addMapper(PhantomHandle.class, new HandleMapper(), "live-handle");
        Structs.addMapper(WeakHandle.class, new HandleMapper(), "live-handle");
        Structs.addMapper(WeakManagedHandle.class, new HandleMapper(), "live-handle");
        Structs.addMapper(HGHandle.class, new HandleMapper(), "hg-handle");
        Structs.addMapper(SimpleALGenerator.class, new BeanMapper(new String[0]), "simple-al-generator");
        Structs.addMapper(DefaultALGenerator.class, new BeanMapper(new String[]{"linkPredicate", "siblingPredicate", "returnPreceeding", "returnSucceeding", "reverseOrder", "returnSource"}), "default-al-generator");
        Structs.addMapper(HGBreadthFirstTraversal.class, new BeanMapper(new String[]{"startAtom", "adjListGenerator"}), "breadth-first-traversal");
        Structs.addMapper(HGDepthFirstTraversal.class, new BeanMapper(new String[]{"startAtom", "adjListGenerator"}), "depth-first-traversal");
        Structs.addMapper(CopyGraphTraversal.class, new BeanMapper(new String[]{"startAtom", "adjListGenerator"}), "copy-graph-traversal");
        Structs.addMapper(HyperTraversal.class, new BeanMapper(new String[]{"flatTraversal", "linkPredicate"}), "hyper-traversal");
        Structs.addMapper(Date.class, new BeanMapper(new String[]{"time"}), "java-date");
        Structs.addMapper(java.sql.Timestamp.class, new StructsMapper(){

            @Override
            public Object getObject(Object struct) {
                return new java.sql.Timestamp(Long.parseLong(struct.toString()));
            }

            @Override
            public Object getStruct(Object value) {
                return Long.toString(((java.sql.Timestamp)value).getTime());
            }
        }, "java-sql-date");
    }

    public static class PerformativeMapper
    implements StructsMapper {
        @Override
        public Object getObject(Object struct) {
            return Performative.toConstant(struct.toString());
        }

        @Override
        public Object getStruct(Object value) {
            return value.toString();
        }
    }

    public static class BeanMapper
    implements StructsMapper {
        String[] props;

        public BeanMapper() {
            this.props = null;
        }

        public BeanMapper(String[] props) {
            this.props = props;
        }

        @Override
        public Object getObject(Object struct) {
            List L = (List)struct;
            String clName = (String)L.get(0);
            try {
                Map m = (Map)L.get(1);
                Class cl = Structs.loadClass(clName);
                Object bean = cl.newInstance();
                Structs.loadMapValues(bean, m);
                return bean;
            }
            catch (Throwable ex) {
                HGUtils.throwRuntimeException(ex);
                return null;
            }
        }

        @Override
        public Object getStruct(Object value) {
            ArrayList<Object> L = new ArrayList<Object>();
            L.add(value.getClass().getName());
            HashMap<String, Object> m = new HashMap<String, Object>();
            try {
                if (this.props != null) {
                    for (String propname : this.props) {
                        PropertyDescriptor desc = BonesOfBeans.getPropertyDescriptor(value, propname);
                        Object x = Structs.svalue(BonesOfBeans.getProperty(value, desc), false, true, desc.getPropertyType());
                        m.put(propname, x);
                    }
                } else {
                    for (PropertyDescriptor desc : BonesOfBeans.getAllPropertyDescriptors(value).values()) {
                        if (desc.getReadMethod() == null || desc.getWriteMethod() == null) continue;
                        Object x = Structs.svalue(BonesOfBeans.getProperty(value, desc), false, true, desc.getPropertyType());
                        m.put(desc.getName(), x);
                    }
                }
                L.add(m);
                return L;
            }
            catch (Throwable ex) {
                HGUtils.throwRuntimeException(ex);
                return null;
            }
        }
    }

    public static class HandleMapper
    implements StructsMapper {
        @Override
        public Object getObject(Object struct) {
            return UUIDPersistentHandle.makeHandle(struct.toString());
        }

        @Override
        public Object getStruct(Object value) {
            if (value instanceof HGPersistentHandle) {
                return value.toString();
            }
            if (value instanceof HGLiveHandle) {
                return ((HGLiveHandle)value).getPersistentHandle().toString();
            }
            throw new RuntimeException("Attempt to serialize something that is not a HG handle as a HG handle.");
        }
    }

    public static class UUIDStructsMapper
    implements StructsMapper {
        @Override
        public Object getObject(Object struct) {
            ArrayList data = (ArrayList)struct;
            return new UUID((Long)data.get(0), (Long)data.get(1));
        }

        @Override
        public Object getStruct(Object value) {
            UUID uuid = (UUID)value;
            return Structs.list(uuid.getMostSignificantBits(), uuid.getLeastSignificantBits());
        }
    }

    public static interface StructsMapper {
        public Object getStruct(Object var1);

        public Object getObject(Object var1);
    }
}

