/*
 * Decompiled with CFR 0.152.
 */
package org.hypergraphdb.peer;

import java.util.HashSet;
import java.util.Set;
import org.hypergraphdb.HGHandle;
import org.hypergraphdb.HGPersistentHandle;
import org.hypergraphdb.HGStore;
import org.hypergraphdb.HyperGraph;
import org.hypergraphdb.event.HGAtomAddedEvent;
import org.hypergraphdb.event.HGAtomRemovedEvent;
import org.hypergraphdb.event.HGAtomReplacedEvent;
import org.hypergraphdb.event.HGEvent;
import org.hypergraphdb.event.HGListener;
import org.hypergraphdb.peer.HyperGraphPeer;
import org.hypergraphdb.peer.SubgraphManager;
import org.hypergraphdb.peer.log.Log;
import org.hypergraphdb.peer.replication.RememberTaskClient;
import org.hypergraphdb.storage.StorageGraph;

public class StorageService {
    private HyperGraph graph;
    private HyperGraph logGraph;
    Set<HGHandle> ownAddedHandles = new HashSet<HGHandle>();
    Set<HGHandle> ownUpdatedHandles = new HashSet<HGHandle>();
    Set<HGHandle> ownRemovedHandles = new HashSet<HGHandle>();
    private HyperGraphPeer thisPeer;
    private Log log;
    private boolean autoSkip = false;

    public StorageService(HyperGraphPeer thisPeer) {
        this.thisPeer = thisPeer;
        this.graph = thisPeer.getGraph();
        this.logGraph = thisPeer.getTempDb();
        this.log = thisPeer.getLog();
    }

    public HGHandle storeSubgraph(StorageGraph subGraph, HGStore store) {
        SubgraphManager.store(subGraph, store);
        return subGraph.getRoots().iterator().next();
    }

    public HGHandle addSubgraph(StorageGraph subgraph) {
        HGStore store = this.logGraph.getStore();
        HGHandle handle = this.storeSubgraph(subgraph, store);
        Object value = this.logGraph.get(handle);
        this.logGraph.remove(handle, false);
        this.ownAddedHandles.add(handle);
        this.graph.define((HGPersistentHandle)handle, value);
        return handle;
    }

    public HGHandle updateSubgraph(StorageGraph subgraph) {
        HGStore store = this.logGraph.getStore();
        HGHandle handle = this.storeSubgraph(subgraph, store);
        Object value = this.logGraph.get(handle);
        this.logGraph.remove(handle, false);
        this.ownUpdatedHandles.add(handle);
        this.graph.replace((HGPersistentHandle)handle, value);
        return handle;
    }

    public HGHandle addOrReplaceSubgraph(StorageGraph subgraph) {
        HGPersistentHandle handle = subgraph.getRoots().iterator().next();
        if (this.graph.getStore().containsLink(handle)) {
            this.updateSubgraph(subgraph);
        } else {
            this.addSubgraph(subgraph);
        }
        return handle;
    }

    public void remove(HGHandle handle) {
        this.ownRemovedHandles.add(handle);
        this.graph.remove(handle);
    }

    public void registerType(HGPersistentHandle handle, Class<?> clazz) {
        if (this.graph != null && this.graph.getStore().getLink(handle) == null) {
            this.autoSkip = true;
            this.graph.getTypeSystem().defineTypeAtom(handle, clazz);
            this.autoSkip = false;
        }
        if (this.logGraph.getStore().getLink(handle) == null) {
            this.logGraph.getTypeSystem().defineTypeAtom(handle, clazz);
        }
    }

    private class AtomReplacedListener
    implements HGListener {
        private AtomReplacedListener() {
        }

        @Override
        public HGListener.Result handle(HyperGraph hg2, HGEvent event) {
            HGAtomReplacedEvent replacedEvent = (HGAtomReplacedEvent)event;
            HGHandle handle = replacedEvent.getAtomHandle();
            if (StorageService.this.autoSkip || StorageService.this.ownUpdatedHandles.contains(handle)) {
                System.out.println("Own replace detected: " + handle);
                StorageService.this.ownUpdatedHandles.remove(handle);
            } else {
                System.out.println("Replace to propagate: " + handle);
                RememberTaskClient client = new RememberTaskClient(StorageService.this.thisPeer, hg2.get(handle), StorageService.this.log, hg2, hg2.getPersistentHandle(handle), Operation.Update);
                client.run();
            }
            return HGListener.Result.ok;
        }
    }

    private class AtomRemovedListener
    implements HGListener {
        private AtomRemovedListener() {
        }

        @Override
        public HGListener.Result handle(HyperGraph hg2, HGEvent event) {
            HGAtomRemovedEvent removedEvent = (HGAtomRemovedEvent)event;
            HGHandle handle = removedEvent.getAtomHandle();
            if (StorageService.this.autoSkip || StorageService.this.ownRemovedHandles.contains(handle)) {
                System.out.println("own remove detected: " + handle);
                StorageService.this.ownRemovedHandles.remove(handle);
            } else {
                System.out.println("Remove to propagate: " + handle);
                RememberTaskClient client = new RememberTaskClient(StorageService.this.thisPeer, null, StorageService.this.log, hg2, hg2.getPersistentHandle(handle), Operation.Remove);
                client.run();
            }
            return HGListener.Result.ok;
        }
    }

    private class AtomAddedListener
    implements HGListener {
        private AtomAddedListener() {
        }

        @Override
        public HGListener.Result handle(HyperGraph hg2, HGEvent event) {
            HGAtomAddedEvent addedEvent = (HGAtomAddedEvent)event;
            HGHandle handle = addedEvent.getAtomHandle();
            if (StorageService.this.autoSkip || StorageService.this.ownAddedHandles.contains(handle)) {
                System.out.println("Own add detected: " + handle);
                StorageService.this.ownAddedHandles.remove(handle);
            } else {
                System.out.println("Add to propagate: " + handle);
                RememberTaskClient client = new RememberTaskClient(StorageService.this.thisPeer, hg2.get(handle), StorageService.this.log, hg2, hg2.getPersistentHandle(handle), Operation.Create);
                client.run();
            }
            return HGListener.Result.ok;
        }
    }

    public static enum Operation {
        Create,
        Update,
        Remove,
        Copy;

    }
}

