/*
 * Decompiled with CFR 0.152.
 */
package org.hypergraphdb.peer;

import java.util.ArrayList;
import java.util.List;
import org.hypergraphdb.HGHandle;
import org.hypergraphdb.HGPersistentHandle;
import org.hypergraphdb.peer.HyperGraphPeer;
import org.hypergraphdb.query.HGQueryCondition;

public abstract class RemotePeer {
    private String name;
    private HyperGraphPeer localPeer;
    private List<Object> operationsBatch;
    private boolean useBatch;

    public RemotePeer() {
        this.useBatch = false;
    }

    public RemotePeer(String name) {
        this.name = name;
        this.useBatch = false;
    }

    public abstract ArrayList<?> query(HGQueryCondition var1, boolean var2);

    public abstract Object get(HGHandle var1);

    public abstract HGHandle add(Object var1);

    public abstract void define(HGPersistentHandle var1, Object var2);

    public abstract void copyTo(HGHandle var1);

    public abstract void copyFrom(HGPersistentHandle var1);

    public abstract HGHandle remove(HGPersistentHandle var1);

    public abstract void replace(HGPersistentHandle var1, Object var2);

    public void startBatch() {
        this.operationsBatch = new ArrayList<Object>();
        this.useBatch = true;
    }

    public List<?> endBatch() {
        List<?> result = null;
        if (this.operationsBatch.size() > 0) {
            result = this.doFlush();
        }
        this.useBatch = false;
        this.operationsBatch = null;
        return result;
    }

    public List<?> flushBatch() {
        List<?> result = null;
        if (this.operationsBatch.size() > 0) {
            result = this.doFlush();
            this.operationsBatch.clear();
            return result;
        }
        return result;
    }

    protected abstract List<?> doFlush();

    public boolean insideBatch() {
        return this.useBatch;
    }

    protected void addToBatch(Object operation) {
        this.operationsBatch.add(operation);
    }

    protected List<Object> getBatch() {
        return this.operationsBatch;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public HyperGraphPeer getLocalPeer() {
        return this.localPeer;
    }

    public void setLocalPeer(HyperGraphPeer localPeer) {
        this.localPeer = localPeer;
    }

    public String toString() {
        String result = "RemotePeer(name=" + this.getName() + ")";
        return result;
    }
}

