/*
 * Decompiled with CFR 0.152.
 */
package org.hypergraphdb.peer;

import java.util.IdentityHashMap;
import java.util.Map;
import org.hypergraphdb.peer.PerformativeConstant;

public class Performative {
    private static Map<String, PerformativeConstant> constantPool = new IdentityHashMap<String, PerformativeConstant>();
    private String name;
    public static final PerformativeConstant AcceptProposal = Performative.makeConstant("AcceptProposal");
    public static final PerformativeConstant Agree = Performative.makeConstant("Agree");
    public static final PerformativeConstant Cancel = Performative.makeConstant("Cancel");
    public static final PerformativeConstant CallForProposal = Performative.makeConstant("CallForProposal");
    public static final PerformativeConstant Confirm = Performative.makeConstant("Confirm");
    public static final PerformativeConstant Disconfirm = Performative.makeConstant("Disconfirm");
    public static final PerformativeConstant Failure = Performative.makeConstant("Failure");
    public static final PerformativeConstant Inform = Performative.makeConstant("Inform");
    public static final PerformativeConstant InformIf = Performative.makeConstant("InformIf");
    public static final PerformativeConstant InformRef = Performative.makeConstant("InformRef");
    public static final PerformativeConstant NotUnderstood = Performative.makeConstant("NotUnderstood");
    public static final PerformativeConstant Propagate = Performative.makeConstant("Propagate");
    public static final PerformativeConstant Propose = Performative.makeConstant("Propose");
    public static final PerformativeConstant Proxy = Performative.makeConstant("Proxy");
    public static final PerformativeConstant QueryIf = Performative.makeConstant("QueryIf");
    public static final PerformativeConstant QueryRef = Performative.makeConstant("QueryRef");
    public static final PerformativeConstant Refuse = Performative.makeConstant("Refuse");
    public static final PerformativeConstant RejectProposal = Performative.makeConstant("RejectProposal");
    public static final PerformativeConstant Request = Performative.makeConstant("Request");
    public static final PerformativeConstant RequestWhen = Performative.makeConstant("RequestWhen");
    public static final PerformativeConstant RequestWhenever = Performative.makeConstant("RequestWhenever");
    public static final PerformativeConstant Subscribe = Performative.makeConstant("Subscribe");

    Performative(String name) {
        this.name = name;
    }

    public static synchronized PerformativeConstant makeConstant(String name) {
        String interned = name.intern();
        PerformativeConstant result = constantPool.get(interned);
        if (result == null) {
            result = new PerformativeConstant(interned);
            constantPool.put(interned, result);
        }
        return result;
    }

    public static synchronized PerformativeConstant toConstant(String name) {
        PerformativeConstant c = constantPool.get(name.intern());
        if (c == null) {
            throw new RuntimeException("Unknown performative constant: " + name);
        }
        return c;
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    public boolean equals(Object x) {
        if (x == this) {
            return true;
        }
        if (!(x instanceof Performative)) {
            return false;
        }
        return ((Performative)x).name == this.name;
    }

    public String toString() {
        return this.name;
    }
}

