/*
 * Decompiled with CFR 0.152.
 */
package org.hypergraphdb.peer;

import org.hypergraphdb.HGHandle;
import org.hypergraphdb.HyperGraph;
import org.hypergraphdb.peer.HGPeerIdentity;
import org.hypergraphdb.peer.PeerFilterEvaluator;
import org.hypergraphdb.peer.PeerInterface;
import org.hypergraphdb.peer.replication.Replication;
import org.hypergraphdb.query.HGAtomPredicate;

public class InterestEvaluator
implements PeerFilterEvaluator {
    private PeerInterface peerInterface;
    private HyperGraph hg;
    private HGHandle handle;

    public InterestEvaluator(PeerInterface peerInterface, HyperGraph hg2) {
        this.peerInterface = peerInterface;
        this.hg = hg2;
    }

    @Override
    public boolean shouldSend(Object target) {
        System.out.println("InterestsPeerFilterEvaluator: evaluating " + this.handle + " for " + target);
        HGPeerIdentity id = this.peerInterface.getThisPeer().getIdentity(target);
        if (id == null) {
            return false;
        }
        HGAtomPredicate pred = Replication.get(this.peerInterface.getThisPeer()).getOthersInterests().get(id);
        return pred != null && pred.satisfies(this.hg, this.handle);
    }

    public PeerInterface getPeerInterface() {
        return this.peerInterface;
    }

    public void setPeerInterface(PeerInterface peerInterface) {
        this.peerInterface = peerInterface;
    }

    public HyperGraph getHg() {
        return this.hg;
    }

    public void setHg(HyperGraph hg2) {
        this.hg = hg2;
    }

    public HGHandle getHandle() {
        return this.handle;
    }

    public void setHandle(HGHandle handle) {
        this.handle = handle;
    }
}

