/*
 * Decompiled with CFR 0.152.
 */
package org.hypergraphdb.maintenance;

import com.sleepycat.db.DeadlockException;
import java.util.ArrayList;
import java.util.List;
import org.hypergraphdb.HGHandle;
import org.hypergraphdb.HGIndex;
import org.hypergraphdb.HGPersistentHandle;
import org.hypergraphdb.HGQuery;
import org.hypergraphdb.HGRandomAccessResult;
import org.hypergraphdb.HyperGraph;
import org.hypergraphdb.indexing.HGIndexer;
import org.hypergraphdb.maintenance.MaintenanceException;
import org.hypergraphdb.maintenance.MaintenanceOperation;
import org.hypergraphdb.transaction.TransactionConflictException;
import org.hypergraphdb.util.HGUtils;

public class ApplyNewIndexer
implements MaintenanceOperation {
    private HGHandle hindexer;
    private List<HGHandle> typesAdded = new ArrayList<HGHandle>();
    private HGPersistentHandle lastProcessed = null;
    private int batchSize = 100;

    private void cleanupAfterFailure(HyperGraph graph, HGIndexer indexer, MaintenanceException ex) {
        try {
            graph.getIndexManager().unregister(indexer);
            graph.getIndexManager().register(indexer);
        }
        catch (Throwable t) {
            ex.setFatal(true);
        }
    }

    private void indexAtomsTypedWith(HyperGraph graph, HGIndex idx, HGIndexer indexer, HGHandle typeHandle) throws MaintenanceException {
        HGRandomAccessResult rs = null;
        while (true) {
            HGPersistentHandle txLastProcessed = this.lastProcessed;
            graph.getTransactionManager().beginTransaction();
            try {
                rs = (HGRandomAccessResult)graph.find(HGQuery.hg.type(typeHandle));
                if (txLastProcessed == null) {
                    if (!rs.hasNext()) {
                        rs.close();
                        graph.getTransactionManager().endTransaction(false);
                        return;
                    }
                    rs.next();
                } else {
                    HGRandomAccessResult.GotoResult gt = rs.goTo(txLastProcessed, false);
                    if (gt == HGRandomAccessResult.GotoResult.nothing) {
                        rs.close();
                        graph.getTransactionManager().endTransaction(false);
                        return;
                    }
                    if (gt == HGRandomAccessResult.GotoResult.found) {
                        if (!rs.hasNext()) {
                            rs.close();
                            graph.getTransactionManager().endTransaction(false);
                            return;
                        }
                        rs.next();
                    }
                }
                for (int i = 0; i < this.batchSize; ++i) {
                    Object atom = graph.get((HGHandle)rs.current());
                    indexer.index(graph, (HGHandle)rs.current(), atom, idx);
                    txLastProcessed = (HGPersistentHandle)rs.current();
                    if (!rs.hasNext()) break;
                    rs.next();
                }
                rs.close();
                rs = null;
                graph.update(this);
                graph.getTransactionManager().endTransaction(true);
                this.lastProcessed = txLastProcessed;
                continue;
            }
            catch (Throwable t) {
                Throwable cause = HGUtils.getRootCause(t);
                if (cause instanceof TransactionConflictException || cause instanceof DeadlockException) continue;
                try {
                    graph.getTransactionManager().endTransaction(false);
                }
                catch (Throwable tt) {
                    tt.printStackTrace(System.err);
                }
                MaintenanceException mex = new MaintenanceException(false, "While creating populating index for indexer : " + indexer, t);
                this.cleanupAfterFailure(graph, indexer, mex);
                throw mex;
            }
            finally {
                HGUtils.closeNoException(rs);
                continue;
            }
            break;
        }
    }

    public ApplyNewIndexer() {
    }

    public ApplyNewIndexer(HGHandle hIndexer) {
        this.hindexer = hIndexer;
    }

    @Override
    public void execute(HyperGraph graph) throws MaintenanceException {
        HGIndexer indexer = (HGIndexer)graph.get(this.hindexer);
        if (indexer == null) {
            return;
        }
        HGIndex idx = graph.getIndexManager().getIndex(indexer);
        if (idx == null) {
            throw new MaintenanceException(false, "Indexer " + indexer + " with handle " + this.hindexer + " present in graph, but no actual index has been created.");
        }
        for (HGHandle currentType : HGQuery.hg.typePlus(indexer.getType()).getSubTypes(graph)) {
            if (this.typesAdded.contains(currentType)) {
                if (!this.typesAdded.get(this.typesAdded.size() - 1).equals(currentType)) {
                    continue;
                }
            } else {
                this.typesAdded.add(currentType);
                this.lastProcessed = null;
            }
            this.indexAtomsTypedWith(graph, idx, indexer, currentType);
        }
    }

    public HGHandle getHindexer() {
        return this.hindexer;
    }

    public void setHindexer(HGHandle indexer) {
        this.hindexer = indexer;
    }

    public HGPersistentHandle getLastProcessed() {
        return this.lastProcessed;
    }

    public void setLastProcessed(HGPersistentHandle lastProcessed) {
        this.lastProcessed = lastProcessed;
    }

    public int getBatchSize() {
        return this.batchSize;
    }

    public void setBatchSize(int batchSize) {
        this.batchSize = batchSize;
    }
}

