/*
 * Decompiled with CFR 0.152.
 */
package org.hypergraphdb.indexing;

import java.util.Comparator;
import org.hypergraphdb.HGHandle;
import org.hypergraphdb.HGLink;
import org.hypergraphdb.HyperGraph;
import org.hypergraphdb.indexing.HGValueIndexer;
import org.hypergraphdb.storage.ByteArrayConverter;
import org.hypergraphdb.util.HGUtils;

public class TargetToTargetIndexer
extends HGValueIndexer {
    private int fromTarget;
    private int toTarget;

    public TargetToTargetIndexer() {
    }

    public TargetToTargetIndexer(HGHandle type, int fromTarget, int toTarget) {
        super(type);
        this.fromTarget = fromTarget;
        this.toTarget = toTarget;
    }

    public int getFromTarget() {
        return this.fromTarget;
    }

    public void setFromTarget(int fromTarget) {
        this.fromTarget = fromTarget;
    }

    public int getToTarget() {
        return this.toTarget;
    }

    public void setToTarget(int toTarget) {
        this.toTarget = toTarget;
    }

    @Override
    public Object getKey(HyperGraph graph, Object atom) {
        return ((HGLink)atom).getTargetAt(this.fromTarget);
    }

    @Override
    public Object getValue(HyperGraph graph, Object atom) {
        return ((HGLink)atom).getTargetAt(this.toTarget);
    }

    public ByteArrayConverter<HGHandle> getValueConverter(final HyperGraph graph) {
        return new ByteArrayConverter<HGHandle>(){

            @Override
            public byte[] toByteArray(HGHandle h) {
                return graph.getPersistentHandle(h).toByteArray();
            }

            @Override
            public HGHandle fromByteArray(byte[] A) {
                return graph.getHandleFactory().makeHandle(A);
            }
        };
    }

    @Override
    public Comparator<?> getComparator(HyperGraph graph) {
        return null;
    }

    @Override
    public ByteArrayConverter<?> getConverter(final HyperGraph graph) {
        return new ByteArrayConverter<HGHandle>(){

            @Override
            public byte[] toByteArray(HGHandle h) {
                return graph.getPersistentHandle(h).toByteArray();
            }

            @Override
            public HGHandle fromByteArray(byte[] A) {
                return graph.getHandleFactory().makeHandle(A);
            }
        };
    }

    @Override
    public int hashCode() {
        return HGUtils.hashThem(this.getType(), HGUtils.hashThem(this.fromTarget, this.toTarget));
    }

    @Override
    public boolean equals(Object other) {
        if (!(other instanceof TargetToTargetIndexer)) {
            return false;
        }
        TargetToTargetIndexer i = (TargetToTargetIndexer)other;
        return HGUtils.eq(this.getType(), i.getType()) && this.fromTarget == i.fromTarget && this.toTarget == i.toTarget;
    }
}

