/*
 * Decompiled with CFR 0.152.
 */
package org.hypergraphdb.indexing;

import java.util.Comparator;
import org.hypergraphdb.HGHandle;
import org.hypergraphdb.HyperGraph;
import org.hypergraphdb.indexing.HGKeyIndexer;
import org.hypergraphdb.storage.BAUtils;
import org.hypergraphdb.storage.BAtoBA;
import org.hypergraphdb.storage.ByteArrayConverter;
import org.hypergraphdb.util.HGUtils;

public class CompositeIndexer
extends HGKeyIndexer {
    private HGKeyIndexer[] indexerParts = null;

    public CompositeIndexer() {
    }

    public CompositeIndexer(HGHandle type, HGKeyIndexer[] indexerParts) {
        super(type);
        if (indexerParts == null || indexerParts.length == 0) {
            throw new IllegalArgumentException("Attempt to construct CompositeIndexer with null or empty parts.");
        }
        this.indexerParts = indexerParts;
    }

    @Override
    public boolean equals(Object other) {
        if (!(other instanceof CompositeIndexer)) {
            return false;
        }
        return HGUtils.eq(this.indexerParts, ((CompositeIndexer)other).indexerParts);
    }

    @Override
    public Comparator<?> getComparator(HyperGraph graph) {
        return null;
    }

    @Override
    public ByteArrayConverter<?> getConverter(HyperGraph graph) {
        return BAtoBA.getInstance();
    }

    @Override
    public Object getKey(HyperGraph graph, Object atom) {
        byte[][] keys = new byte[this.indexerParts.length][];
        int size = 1;
        for (int i = 0; i < this.indexerParts.length; ++i) {
            HGKeyIndexer ind = this.indexerParts[i];
            Object key = ind.getKey(graph, atom);
            keys[i] = ind.getConverter(graph).toByteArray(key);
            size += keys[i].length + 4;
        }
        byte[] B = new byte[size];
        B[1] = (byte)keys.length;
        int pos = 1;
        for (byte[] curr : keys) {
            BAUtils.writeInt(curr.length, B, pos);
            System.arraycopy(curr, 0, B, pos += 4, curr.length);
            pos += curr.length;
        }
        return B;
    }

    @Override
    public int hashCode() {
        if (this.indexerParts == null) {
            return 0;
        }
        int x = this.indexerParts.length;
        for (HGKeyIndexer ind : this.indexerParts) {
            x ^= ind.hashCode() >> 16;
        }
        return x;
    }

    public HGKeyIndexer[] getIndexerParts() {
        return this.indexerParts;
    }

    public void setIndexerParts(HGKeyIndexer[] indexerParts) {
        this.indexerParts = indexerParts;
    }
}

