/*
 * Decompiled with CFR 0.152.
 */
package org.hypergraphdb.indexing;

import java.util.Comparator;
import org.hypergraphdb.HGException;
import org.hypergraphdb.HGHandle;
import org.hypergraphdb.HGQuery;
import org.hypergraphdb.HyperGraph;
import org.hypergraphdb.atom.AtomProjection;
import org.hypergraphdb.atom.HGAtomRef;
import org.hypergraphdb.indexing.HGKeyIndexer;
import org.hypergraphdb.storage.ByteArrayConverter;
import org.hypergraphdb.type.AtomRefType;
import org.hypergraphdb.type.HGAtomType;
import org.hypergraphdb.type.HGCompositeType;
import org.hypergraphdb.type.HGProjection;
import org.hypergraphdb.util.HGUtils;

public class ByPartIndexer
extends HGKeyIndexer {
    private String[] dimensionPath;
    private HGProjection[] projections = null;
    private HGAtomType projectionType = null;

    private synchronized HGProjection[] getProjections(HyperGraph graph) {
        if (this.projections == null) {
            HGAtomType type = graph.getTypeSystem().getType(this.getType());
            if (type == null) {
                throw new HGException("Could not find type with handle " + this.getType());
            }
            this.projections = new HGProjection[this.dimensionPath.length];
            for (int j = 0; j < this.dimensionPath.length; ++j) {
                if (!(type instanceof HGCompositeType)) {
                    return null;
                }
                this.projections[j] = ((HGCompositeType)type).getProjection(this.dimensionPath[j]);
                if (this.projections[j] == null) {
                    throw new HGException("There's no projection '" + this.dimensionPath[j] + "' in type '" + type + "'");
                }
                type = (HGAtomType)graph.get(this.projections[j].getType());
            }
            HGProjection ours = this.projections[this.dimensionPath.length - 1];
            HGHandle enclosingType = this.dimensionPath.length > 1 ? this.projections[this.dimensionPath.length - 2].getType() : this.getType();
            HGHandle atomProj = (HGHandle)HGQuery.hg.findOne(graph, HGQuery.hg.and(HGQuery.hg.type(AtomProjection.class), HGQuery.hg.incident(enclosingType), HGQuery.hg.incident(ours.getType()), HGQuery.hg.eq("name", ours.getName())));
            this.projectionType = atomProj != null ? graph.getTypeSystem().getAtomType(HGAtomRef.class) : (HGAtomType)graph.get(ours.getType());
        }
        return this.projections;
    }

    public ByPartIndexer() {
    }

    public ByPartIndexer(HGHandle type, String dimensionPath) {
        this(type, dimensionPath.split("\\."));
    }

    public ByPartIndexer(HGHandle type, String[] dimensionPath) {
        super(type);
        this.dimensionPath = dimensionPath;
    }

    public String[] getDimensionPath() {
        return this.dimensionPath;
    }

    public void setDimensionPath(String[] dimensionPath) {
        this.dimensionPath = dimensionPath;
    }

    @Override
    public Comparator<?> getComparator(HyperGraph graph) {
        if (this.projectionType == null) {
            this.getProjections(graph);
        }
        if (this.projectionType.getClass().equals(AtomRefType.class)) {
            return null;
        }
        return (Comparator)((Object)this.projectionType);
    }

    @Override
    public ByteArrayConverter<?> getConverter(HyperGraph graph) {
        if (this.projectionType == null) {
            this.getProjections(graph);
        }
        return (ByteArrayConverter)((Object)this.projectionType);
    }

    @Override
    public Object getKey(HyperGraph graph, Object atom) {
        Object result = atom;
        for (HGProjection p : this.getProjections(graph)) {
            result = p.project(result);
        }
        return result;
    }

    @Override
    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof ByPartIndexer)) {
            return false;
        }
        ByPartIndexer idx = (ByPartIndexer)other;
        return this.getType().equals(idx.getType()) && HGUtils.eq(this.dimensionPath, idx.dimensionPath);
    }

    @Override
    public int hashCode() {
        return this.getType().hashCode();
    }
}

