/*
 * Decompiled with CFR 0.152.
 */
package org.hypergraphdb.handle;

import java.util.concurrent.atomic.AtomicLong;
import org.hypergraphdb.HGPersistentHandle;
import org.hypergraphdb.handle.UUIDHandleFactory;
import org.hypergraphdb.handle.UUIDPersistentHandle;

public class SequentialUUIDHandleFactory
extends UUIDHandleFactory {
    private static AtomicLong seed = new AtomicLong(System.currentTimeMillis());
    private byte[] data = new byte[16];
    private long base = 0L;

    public SequentialUUIDHandleFactory() {
        this.setBase(this.base);
    }

    public SequentialUUIDHandleFactory(long base, long seed) {
        this.setSeed(seed);
        this.setBase(base);
    }

    public long getBase() {
        return this.base;
    }

    public void setBase(long base) {
        this.base = base;
        this.data[0] = (byte)(base >>> 56);
        this.data[1] = (byte)(base >>> 48);
        this.data[2] = (byte)(base >>> 40);
        this.data[3] = (byte)(base >>> 32);
        this.data[4] = (byte)(base >>> 24);
        this.data[5] = (byte)(base >>> 16);
        this.data[6] = (byte)(base >>> 8);
        this.data[7] = (byte)(base >>> 0);
    }

    public long getSeed() {
        return seed.get();
    }

    public void setSeed(long newSeed) {
        seed.set(newSeed);
    }

    @Override
    public HGPersistentHandle makeHandle() {
        long v = seed.incrementAndGet();
        this.data[8] = (byte)(v >>> 56);
        this.data[9] = (byte)(v >>> 48);
        this.data[10] = (byte)(v >>> 40);
        this.data[11] = (byte)(v >>> 32);
        this.data[12] = (byte)(v >>> 24);
        this.data[13] = (byte)(v >>> 16);
        this.data[14] = (byte)(v >>> 8);
        this.data[15] = (byte)(v >>> 0);
        return UUIDPersistentHandle.makeHandle(this.data);
    }
}

