/*
 * Decompiled with CFR 0.152.
 */
package org.hypergraphdb.handle;

import java.lang.ref.PhantomReference;
import java.lang.ref.ReferenceQueue;
import java.lang.reflect.Field;
import org.hypergraphdb.HGException;
import org.hypergraphdb.HGHandle;
import org.hypergraphdb.HGPersistentHandle;
import org.hypergraphdb.handle.HGLiveHandle;

public class PhantomHandle
extends PhantomReference<Object>
implements HGLiveHandle,
Comparable<HGHandle> {
    private HGPersistentHandle persistentHandle;
    private byte flags;
    private static Field refField = null;
    public static ThreadLocal<Boolean> returnEnqueued;

    public PhantomHandle(Object ref, HGPersistentHandle persistentHandle, byte flags, ReferenceQueue<Object> refQueue) {
        super(ref, refQueue);
        this.persistentHandle = persistentHandle;
        this.flags = flags;
    }

    @Override
    public byte getFlags() {
        return this.flags;
    }

    @Override
    public HGPersistentHandle getPersistentHandle() {
        return this.persistentHandle;
    }

    public Object fetchRef() {
        try {
            return refField.get(this);
        }
        catch (Exception t) {
            throw new HGException(t);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void storeRef(Object ref) {
        while (this.isEnqueued()) {
            try {
                PhantomHandle phantomHandle = this;
                synchronized (phantomHandle) {
                    this.wait(100L);
                }
            }
            catch (InterruptedException ex) {
            }
        }
        try {
            refField.set(this, ref);
        }
        catch (Exception t) {
            throw new HGException(t);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object getRef() {
        Object x = this.fetchRef();
        if (this.isEnqueued()) {
            Boolean f = returnEnqueued.get();
            if (f != null && f.booleanValue()) {
                return x;
            }
            x = null;
            do {
                try {
                    PhantomHandle phantomHandle = this;
                    synchronized (phantomHandle) {
                        this.wait(100L);
                    }
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            } while (this.isEnqueued());
        }
        return x;
    }

    public void accessed() {
    }

    public final int hashCode() {
        return this.persistentHandle.hashCode();
    }

    public final boolean equals(Object other) {
        if (other == null || !(other instanceof HGHandle)) {
            return false;
        }
        if (other instanceof HGLiveHandle) {
            return this.persistentHandle.equals(((HGLiveHandle)other).getPersistentHandle());
        }
        return this.persistentHandle.equals((HGPersistentHandle)other);
    }

    public String toString() {
        return "phantomHandle(" + this.persistentHandle.toString() + ")";
    }

    @Override
    public int compareTo(HGHandle h) {
        if (h instanceof HGPersistentHandle) {
            return this.persistentHandle.compareTo((HGPersistentHandle)h);
        }
        return this.persistentHandle.compareTo(((HGLiveHandle)h).getPersistentHandle());
    }

    static {
        block0: for (Class clazz = PhantomReference.class; clazz != null && refField == null; clazz = clazz.getSuperclass()) {
            Field[] all = clazz.getDeclaredFields();
            for (int i = 0; i < all.length; ++i) {
                if (!all[i].getName().equals("referent")) continue;
                refField = all[i];
                refField.setAccessible(true);
                continue block0;
            }
        }
        returnEnqueued = new ThreadLocal();
    }
}

