/*
 * Decompiled with CFR 0.152.
 */
package org.hypergraphdb.handle;

import java.util.concurrent.atomic.AtomicInteger;
import org.hypergraphdb.HGHandleFactory;
import org.hypergraphdb.HGPersistentHandle;
import org.hypergraphdb.handle.IntPersistentHandle;
import org.hypergraphdb.storage.BAUtils;

public class IntHandleFactory
implements HGHandleFactory {
    private static final IntPersistentHandle any = new IntPersistentHandle(1);
    private static final IntPersistentHandle nil = new IntPersistentHandle(0);
    private AtomicInteger next = new AtomicInteger(1000);

    public int getNext() {
        return this.next.get();
    }

    public void setNext(int next) {
        this.next.set(next);
    }

    @Override
    public HGPersistentHandle anyHandle() {
        return any;
    }

    @Override
    public HGPersistentHandle makeHandle() {
        return new IntPersistentHandle(this.next.getAndIncrement());
    }

    @Override
    public HGPersistentHandle makeHandle(String handleAsString) {
        return new IntPersistentHandle(Integer.parseInt(handleAsString));
    }

    @Override
    public HGPersistentHandle makeHandle(byte[] buffer) {
        return new IntPersistentHandle(BAUtils.readInt(buffer, 0));
    }

    @Override
    public HGPersistentHandle makeHandle(byte[] buffer, int offset) {
        return new IntPersistentHandle(BAUtils.readInt(buffer, offset));
    }

    @Override
    public HGPersistentHandle nullHandle() {
        return nil;
    }
}

