/*
 * Decompiled with CFR 0.152.
 */
package org.hypergraphdb.event;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.hypergraphdb.HyperGraph;
import org.hypergraphdb.event.HGEvent;
import org.hypergraphdb.event.HGListener;
import org.hypergraphdb.transaction.TxList;
import org.hypergraphdb.transaction.TxMap;

public class HGEventManager {
    private HyperGraph graph;
    private Map<Class<?>, List<HGListener>> listenerMap = null;

    private List<HGListener> getListeners(Class<?> eventType) {
        List<HGListener> listeners = this.listenerMap.get(eventType);
        if (listeners == null) {
            listeners = new TxList<HGListener>(this.graph.getTransactionManager());
            this.listenerMap.put(eventType, listeners);
        }
        return listeners;
    }

    public HGEventManager(HyperGraph graph) {
        this.graph = graph;
        this.listenerMap = new TxMap(graph.getTransactionManager(), new HashMap());
    }

    public <T extends HGEvent> void addListener(Class<T> eventType, HGListener listener) {
        this.getListeners(eventType).add(listener);
    }

    public <T extends HGEvent> void removeListener(Class<T> eventType, HGListener listener) {
        this.getListeners(eventType).remove(listener);
    }

    public HGListener.Result dispatch(HyperGraph hg2, HGEvent event) {
        if (this.listenerMap.isEmpty()) {
            return HGListener.Result.ok;
        }
        for (Class<?> clazz = event.getClass(); clazz != null && HGEvent.class != clazz; clazz = clazz.getSuperclass()) {
            List<HGListener> listeners = this.listenerMap.get(clazz);
            if (listeners == null) continue;
            block5: for (HGListener l : listeners) {
                switch (l.handle(hg2, event)) {
                    case ok: {
                        continue block5;
                    }
                    case cancel: {
                        return HGListener.Result.cancel;
                    }
                }
            }
        }
        return HGListener.Result.ok;
    }

    public void clear() {
        this.listenerMap.clear();
    }
}

