/*
 * Decompiled with CFR 0.152.
 */
package org.hypergraphdb.cache;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.hypergraphdb.cache.HGCache;
import org.hypergraphdb.util.RefResolver;

public class SimpleCache<Key, Value>
implements HGCache<Key, Value> {
    ReentrantReadWriteLock lock = new ReentrantReadWriteLock();
    private RefResolver<Key, Value> resolver;
    private Map<Key, Value> map = new HashMap<Key, Value>();

    @Override
    public Value get(Key key) {
        this.lock.readLock().lock();
        Value v = this.map.get(key);
        this.lock.readLock().unlock();
        if (v == null) {
            v = this.resolver.resolve(key);
            this.lock.writeLock().lock();
            this.map.put(key, v);
            this.lock.writeLock().unlock();
            return v;
        }
        return v;
    }

    @Override
    public Value getIfLoaded(Key key) {
        this.lock.readLock().lock();
        Value v = this.map.get(key);
        this.lock.readLock().unlock();
        return v;
    }

    @Override
    public boolean isLoaded(Key key) {
        this.lock.readLock().lock();
        boolean b = this.map.containsKey(key);
        this.lock.readLock().unlock();
        return b;
    }

    @Override
    public void remove(Key key) {
        this.lock.writeLock().lock();
        this.map.remove(key);
        this.lock.writeLock().unlock();
    }

    @Override
    public RefResolver<Key, Value> getResolver() {
        return this.resolver;
    }

    @Override
    public void setResolver(RefResolver<Key, Value> resolver) {
        this.resolver = resolver;
    }

    @Override
    public void clear() {
        this.lock.writeLock().lock();
        this.map.clear();
        this.lock.writeLock().unlock();
    }

    @Override
    public int size() {
        return this.map.size();
    }
}

