/*
 * Decompiled with CFR 0.152.
 */
package org.hypergraphdb.cache;

import org.hypergraphdb.HGEnvironment;
import org.hypergraphdb.util.MemoryWarningSystem;
import org.hypergraphdb.util.SimplyLinkedQueue;

public class ColdAtoms {
    public static int DEFAULT_BUCKET_SIZE = 2000;
    int bucket_size;
    int evictFactor = 3;
    private SimplyLinkedQueue<Object[]> buckets = new SimplyLinkedQueue();
    int pos = 0;
    private MemoryWarningSystem.Listener memListener = new MemoryWarningSystem.Listener(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void memoryUsageLow(long usedMemory, long maxMemory) {
            SimplyLinkedQueue simplyLinkedQueue = ColdAtoms.this.buckets;
            synchronized (simplyLinkedQueue) {
                int cnt = ColdAtoms.this.buckets.size() / ColdAtoms.this.evictFactor;
                if (cnt == 0) {
                    int n = cnt = ColdAtoms.this.buckets.size() > 0 ? 1 : 0;
                }
                while (cnt-- > 0) {
                    ColdAtoms.this.buckets.fetch();
                }
            }
            System.gc();
        }
    };

    private void initMemoryListener() {
        HGEnvironment.getMemoryWarningSystem().addListener(this.memListener);
    }

    public ColdAtoms() {
        this(DEFAULT_BUCKET_SIZE);
        this.initMemoryListener();
    }

    public ColdAtoms(int bucket_size) {
        this.bucket_size = bucket_size;
        this.buckets.put(new Object[bucket_size]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(Object atom) {
        SimplyLinkedQueue<Object[]> simplyLinkedQueue = this.buckets;
        synchronized (simplyLinkedQueue) {
            if (this.pos >= this.bucket_size || this.buckets.size() == 0) {
                this.buckets.put(new Object[this.bucket_size]);
                this.pos = 0;
            }
            this.buckets.peekBack()[this.pos++] = atom;
        }
    }

    public int size() {
        return this.bucket_size * this.buckets.size();
    }
}

