/*
 * Decompiled with CFR 0.152.
 */
package org.hypergraphdb.atom;

import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.hypergraphdb.HGHandle;
import org.hypergraphdb.HGPersistentHandle;
import org.hypergraphdb.HGSearchResult;
import org.hypergraphdb.HGSearchable;
import org.hypergraphdb.HGSortIndex;
import org.hypergraphdb.HyperGraph;
import org.hypergraphdb.IncidenceSetRef;
import org.hypergraphdb.LazyRef;
import org.hypergraphdb.atom.HGRelType;
import org.hypergraphdb.storage.BAtoBA;
import org.hypergraphdb.storage.BAtoHandle;
import org.hypergraphdb.type.HGAtomType;
import org.hypergraphdb.type.HGCompositeType;
import org.hypergraphdb.type.HGProjection;

public class HGRelTypeConstructor
implements HGSearchable<HGRelType, HGPersistentHandle>,
HGCompositeType {
    public static final String INDEX_NAME = "hg_reltype_value_index";
    private HyperGraph graph = null;
    private HGSortIndex<byte[], HGPersistentHandle> valueIndex = null;
    private Map<String, HGProjection> projections = new HashMap<String, HGProjection>();

    private void initProjections() {
        this.projections.put("name", new HGProjection(){

            @Override
            public int[] getLayoutPath() {
                return new int[0];
            }

            @Override
            public String getName() {
                return "name";
            }

            @Override
            public HGHandle getType() {
                return HGRelTypeConstructor.this.graph.getTypeSystem().getTypeHandle(String.class);
            }

            @Override
            public void inject(Object atomValue, Object value) {
                ((HGRelType)atomValue).setName((String)value);
            }

            @Override
            public Object project(Object atomValue) {
                return ((HGRelType)atomValue).getName();
            }
        });
    }

    private final HGSortIndex<byte[], HGPersistentHandle> getIndex() {
        if (this.valueIndex == null) {
            Comparator<byte[]> comparator = new Comparator<byte[]>(){

                @Override
                public int compare(byte[] left, byte[] right) {
                    return new String(left).compareTo(new String(right));
                }
            };
            this.valueIndex = (HGSortIndex)this.graph.getStore().getIndex(INDEX_NAME, BAtoBA.getInstance(), BAtoHandle.getInstance(this.graph.getHandleFactory()), comparator, true);
        }
        return this.valueIndex;
    }

    @Override
    public Object make(HGPersistentHandle handle, LazyRef<HGHandle[]> targetSet, IncidenceSetRef incidenceSet) {
        Object sType = this.graph.getTypeSystem().getAtomType(String.class);
        String name = (String)sType.make(handle, null, null);
        return new HGRelType(name, targetSet.deref());
    }

    @Override
    public HGPersistentHandle store(Object instance) {
        HGRelType relType = (HGRelType)instance;
        Object sType = this.graph.getTypeSystem().getAtomType(String.class);
        HGPersistentHandle result = sType.store(relType.getName());
        if (this.getIndex().findFirst(relType.getName().getBytes()) == null) {
            this.getIndex().addEntry(relType.getName().getBytes(), result);
        }
        return result;
    }

    @Override
    public void release(HGPersistentHandle handle) {
        Object sType = this.graph.getTypeSystem().getAtomType(String.class);
        String s = (String)sType.make(handle, null, null);
        sType.release(handle);
        this.getIndex().removeEntry(s.getBytes(), handle);
    }

    @Override
    public boolean subsumes(Object general, Object specific) {
        HGRelType grel = (HGRelType)general;
        HGRelType srel = (HGRelType)specific;
        if (general == null || specific == null) {
            return general == specific;
        }
        if (!grel.getName().equals(srel.getName()) || grel.getArity() != srel.getArity()) {
            return false;
        }
        for (int i = 0; i < grel.getArity(); ++i) {
            HGAtomType st;
            HGAtomType gt;
            HGHandle s;
            HGHandle g = grel.getTargetAt(i);
            if (g.equals(s = srel.getTargetAt(i)) || (gt = this.graph.getTypeSystem().getAtomType(g)).equals(st = this.graph.getTypeSystem().getAtomType(s)) && gt.subsumes(this.graph.get(g), this.graph.get(s))) continue;
            return false;
        }
        return true;
    }

    @Override
    public HGSearchResult<HGPersistentHandle> find(HGRelType key) {
        if (key == null || key.getName() == null) {
            return HGSearchResult.EMPTY;
        }
        return this.getIndex().find(key.getName().getBytes());
    }

    @Override
    public Iterator<String> getDimensionNames() {
        return this.projections.keySet().iterator();
    }

    @Override
    public HGProjection getProjection(String dimensionName) {
        return this.projections.get(dimensionName);
    }

    @Override
    public void setHyperGraph(HyperGraph graph) {
        this.graph = graph;
        this.initProjections();
    }
}

