/*
 * Decompiled with CFR 0.152.
 */
package org.hypergraphdb.atom;

import org.hypergraphdb.HGException;
import org.hypergraphdb.HGHandle;
import org.hypergraphdb.HGLink;
import org.hypergraphdb.HGPersistentHandle;
import org.hypergraphdb.HyperGraph;
import org.hypergraphdb.IncidenceSetRef;
import org.hypergraphdb.LazyRef;
import org.hypergraphdb.atom.HGRel;
import org.hypergraphdb.type.HGAtomTypeBase;

public class HGRelType
extends HGAtomTypeBase
implements HGLink {
    private String name;
    private HGHandle[] targetTypes;

    private void init(String name, HGHandle ... targetTypes) {
        this.name = name;
        if (targetTypes == null) {
            targetTypes = HyperGraph.EMTPY_HANDLE_SET;
        }
        this.targetTypes = targetTypes;
    }

    public HGRelType() {
        this.init("", new HGHandle[0]);
    }

    public HGRelType(String name) {
        this.init(name, new HGHandle[0]);
    }

    public HGRelType(HGHandle ... targetTypes) {
        this.init("", targetTypes);
    }

    public HGRelType(String name, HGHandle ... targetTypes) {
        this.init(name, targetTypes);
    }

    @Override
    public Object make(HGPersistentHandle handle, LazyRef<HGHandle[]> targetSet, IncidenceSetRef incidenceSet) {
        if (targetSet == null) {
            if (this.targetTypes != null && this.targetTypes.length > 0) {
                throw new HGException("HGRelType.make: expected a target set of size " + this.targetTypes.length + " but got a null.");
            }
        } else if (targetSet.deref().length != this.targetTypes.length) {
            throw new HGException("HGRelType.make: expected a target set of size " + this.targetTypes.length + " but got size " + targetSet.deref().length);
        }
        return new HGRel(this.name, targetSet.deref());
    }

    @Override
    public void release(HGPersistentHandle handle) {
    }

    @Override
    public HGPersistentHandle store(Object instance) {
        return this.graph.getHandleFactory().nullHandle();
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @Override
    public int getArity() {
        return this.targetTypes.length;
    }

    @Override
    public HGHandle getTargetAt(int i) {
        return this.targetTypes[i];
    }

    @Override
    public void notifyTargetHandleUpdate(int i, HGHandle handle) {
        this.targetTypes[i] = handle;
    }

    @Override
    public void notifyTargetRemoved(int i) {
        HGHandle[] newOutgoing = new HGHandle[this.targetTypes.length - 1];
        System.arraycopy(this.targetTypes, 0, newOutgoing, 0, i);
        System.arraycopy(this.targetTypes, i + 1, newOutgoing, i, this.targetTypes.length - i - 1);
        this.targetTypes = newOutgoing;
    }

    public int hashCode() {
        return this.name == null ? 0 : this.name.hashCode();
    }

    public boolean equals(Object other) {
        if (!(other instanceof HGRelType)) {
            return false;
        }
        HGRelType rt = (HGRelType)other;
        if (!rt.getName().equals(this.name)) {
            return false;
        }
        if (this.targetTypes == rt.targetTypes) {
            return true;
        }
        if (this.targetTypes.length != rt.targetTypes.length) {
            return false;
        }
        for (int i = 0; i < this.targetTypes.length; ++i) {
            if (this.targetTypes[i].equals(rt.targetTypes[i])) continue;
            return false;
        }
        return true;
    }
}

