/*
 * Decompiled with CFR 0.152.
 */
package org.hypergraphdb.atom;

import org.hypergraphdb.HGHandle;
import org.hypergraphdb.HGPersistentHandle;
import org.hypergraphdb.HyperGraph;
import org.hypergraphdb.IncidenceSetRef;
import org.hypergraphdb.LazyRef;
import org.hypergraphdb.atom.HGAtomStack;
import org.hypergraphdb.atom.U;
import org.hypergraphdb.type.HGAtomType;

public class AtomStackType
implements HGAtomType {
    private HyperGraph hg;

    @Override
    public void setHyperGraph(HyperGraph hg2) {
        this.hg = hg2;
    }

    @Override
    public Object make(HGPersistentHandle handle, LazyRef<HGHandle[]> targetSet, IncidenceSetRef incidenceSet) {
        byte[] data = this.hg.getStore().getData(handle);
        HGAtomStack stack = new HGAtomStack();
        for (int i = 0; i < data.length; i += 16) {
            stack.push(this.hg.getHandleFactory().makeHandle(data, i));
        }
        return stack;
    }

    @Override
    public HGPersistentHandle store(Object instance) {
        HGAtomStack stack = (HGAtomStack)instance;
        byte[] data = new byte[stack.size * 16];
        int i = (stack.size - 1) * 16;
        U.HandleLink curr = stack.top;
        while (curr != null) {
            System.arraycopy(U.getBytes(curr.handle), 0, data, i, 16);
            curr = curr.next;
            i -= 16;
        }
        return this.hg.getStore().store(data);
    }

    @Override
    public void release(HGPersistentHandle handle) {
        this.hg.getStore().removeData(handle);
    }

    @Override
    public boolean subsumes(Object general, Object specific) {
        return general == specific;
    }
}

