/*
 * Decompiled with CFR 0.152.
 */
package org.hypergraphdb.atom;

import org.hypergraphdb.HGHandle;
import org.hypergraphdb.HGPersistentHandle;
import org.hypergraphdb.HyperGraph;
import org.hypergraphdb.IncidenceSetRef;
import org.hypergraphdb.LazyRef;
import org.hypergraphdb.atom.HGAtomSet;
import org.hypergraphdb.type.HGAtomType;

public class AtomSetType
implements HGAtomType {
    private HyperGraph graph;

    @Override
    public void setHyperGraph(HyperGraph hg2) {
        this.graph = hg2;
    }

    @Override
    public Object make(HGPersistentHandle handle, LazyRef<HGHandle[]> targetSet, IncidenceSetRef incidenceSet) {
        byte[] data = this.graph.getStore().getData(handle);
        HGAtomSet set = new HGAtomSet();
        for (int pos = 0; pos < data.length; pos += 16) {
            set.add(this.graph.getHandleFactory().makeHandle(data, pos));
        }
        return set;
    }

    @Override
    public HGPersistentHandle store(Object instance) {
        HGAtomSet set = (HGAtomSet)instance;
        HGPersistentHandle result = this.graph.getHandleFactory().makeHandle();
        byte[] A = new byte[set.size() * 16];
        int pos = 0;
        for (HGHandle h : set) {
            System.arraycopy(this.graph.getPersistentHandle(h).toByteArray(), 0, A, pos, 16);
            pos += 16;
        }
        this.graph.getStore().store(result, A);
        return result;
    }

    @Override
    public void release(HGPersistentHandle handle) {
        this.graph.getStore().removeData(handle);
    }

    @Override
    public boolean subsumes(Object general, Object specific) {
        return general == specific;
    }
}

