/*
 * Decompiled with CFR 0.152.
 */
package org.hypergraphdb.algorithms;

import java.util.Iterator;
import org.hypergraphdb.HGHandle;
import org.hypergraphdb.HGLink;
import org.hypergraphdb.HGSearchResult;
import org.hypergraphdb.HyperGraph;
import org.hypergraphdb.algorithms.HGALGenerator;
import org.hypergraphdb.util.Pair;
import org.hypergraphdb.util.TempLink;

public class SimpleALGenerator
implements HGALGenerator {
    private HyperGraph graph;
    private TempLink tempLink = new TempLink(HyperGraph.EMTPY_HANDLE_SET);
    private AdjIterator currIterator = null;

    public SimpleALGenerator() {
    }

    public SimpleALGenerator(HyperGraph hg2) {
        this.graph = hg2;
    }

    @Override
    public HGSearchResult<Pair<HGHandle, HGHandle>> generate(HGHandle h) {
        return new AdjIterator(h, this.graph.getIncidenceSet(h).getSearchResult(), true);
    }

    public void close() {
        if (this.currIterator != null && this.currIterator.closeResultSet) {
            ((HGSearchResult)this.currIterator.linksIterator).close();
        }
    }

    public void setGraph(HyperGraph graph) {
        this.graph = graph;
    }

    public HyperGraph getGraph() {
        return this.graph;
    }

    private class AdjIterator
    implements HGSearchResult<Pair<HGHandle, HGHandle>> {
        HGHandle src;
        Iterator<HGHandle> linksIterator;
        HGHandle hCurrLink;
        HGLink currLink;
        Pair<HGHandle, HGHandle> current;
        int currLinkPos;
        boolean closeResultSet;

        private void getNextLink() {
            boolean done = false;
            while (!done) {
                if (!this.linksIterator.hasNext()) {
                    this.currLink = null;
                    if (this.closeResultSet) {
                        ((HGSearchResult)this.linksIterator).close();
                    }
                    return;
                }
                this.hCurrLink = this.linksIterator.next();
                if (SimpleALGenerator.this.graph.isLoaded(this.hCurrLink)) {
                    this.currLink = (HGLink)SimpleALGenerator.this.graph.get(this.hCurrLink);
                } else {
                    SimpleALGenerator.this.tempLink.setHandleArray(SimpleALGenerator.this.graph.getStore().getLink(SimpleALGenerator.this.graph.getPersistentHandle(this.hCurrLink)), 2);
                    this.currLink = SimpleALGenerator.this.tempLink;
                }
                done = this.currLink.getArity() > 1;
            }
            this.currLinkPos = this.currLink.getTargetAt(0).equals(this.src) ? 1 : 0;
        }

        AdjIterator(HGHandle src, Iterator<HGHandle> linksIterator, boolean closeResultSet) {
            this.src = src;
            this.linksIterator = linksIterator;
            this.closeResultSet = closeResultSet;
            this.getNextLink();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean hasNext() {
            return this.currLink != null;
        }

        @Override
        public Pair<HGHandle, HGHandle> next() {
            this.current = new Pair<HGHandle, HGHandle>(this.hCurrLink, this.currLink.getTargetAt(this.currLinkPos));
            if (++this.currLinkPos == this.currLink.getArity()) {
                this.getNextLink();
            } else if (this.currLink.getTargetAt(this.currLinkPos).equals(this.src) && ++this.currLinkPos == this.currLink.getArity()) {
                this.getNextLink();
            }
            return this.current;
        }

        @Override
        public void close() {
            if (this.closeResultSet) {
                ((HGSearchResult)this.linksIterator).close();
            }
        }

        @Override
        public Pair<HGHandle, HGHandle> current() {
            return this.current;
        }

        @Override
        public boolean isOrdered() {
            return false;
        }

        @Override
        public boolean hasPrev() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Pair<HGHandle, HGHandle> prev() {
            throw new UnsupportedOperationException();
        }
    }
}

