/*
 * Decompiled with CFR 0.152.
 */
package org.hypergraphdb.algorithms;

import java.util.HashMap;
import java.util.Map;
import java.util.Stack;
import org.hypergraphdb.HGHandle;
import org.hypergraphdb.HGSearchResult;
import org.hypergraphdb.algorithms.HGALGenerator;
import org.hypergraphdb.algorithms.HGTraversal;
import org.hypergraphdb.util.Pair;

public class HGDepthFirstTraversal
implements HGTraversal {
    private HGHandle startAtom;
    private Map<HGHandle, Boolean> examined = new HashMap<HGHandle, Boolean>();
    private Stack<Pair<HGHandle, HGHandle>> to_explore = new Stack();
    private HGALGenerator adjListGenerator;
    private boolean initialized = false;

    private void init() {
        this.examined.put(this.startAtom, Boolean.TRUE);
        this.advance(this.startAtom);
        this.initialized = true;
    }

    private void advance(HGHandle from) {
        HGSearchResult<Pair<HGHandle, HGHandle>> i = this.adjListGenerator.generate(from);
        while (i.hasNext()) {
            Pair p = (Pair)i.next();
            if (this.examined.containsKey(p.getSecond())) continue;
            this.to_explore.push(p);
            this.examined.put((HGHandle)p.getSecond(), Boolean.FALSE);
        }
        i.close();
    }

    public HGDepthFirstTraversal() {
    }

    public HGDepthFirstTraversal(HGHandle startAtom, HGALGenerator adjListGenerator) {
        this.startAtom = startAtom;
        this.adjListGenerator = adjListGenerator;
        this.init();
    }

    public void setStartAtom(HGHandle startAtom) {
        this.startAtom = startAtom;
    }

    public HGHandle getStartAtom() {
        return this.startAtom;
    }

    public HGALGenerator getAdjListGenerator() {
        return this.adjListGenerator;
    }

    public void setAdjListGenerator(HGALGenerator adjListGenerator) {
        this.adjListGenerator = adjListGenerator;
    }

    @Override
    public boolean hasNext() {
        if (!this.initialized) {
            this.init();
        }
        return !this.to_explore.isEmpty();
    }

    @Override
    public Pair<HGHandle, HGHandle> next() {
        if (!this.initialized) {
            this.init();
        }
        Pair<HGHandle, HGHandle> rvalue = null;
        if (!this.to_explore.isEmpty()) {
            rvalue = this.to_explore.pop();
            this.examined.put(rvalue.getSecond(), Boolean.TRUE);
            this.advance(rvalue.getSecond());
        }
        return rvalue;
    }

    @Override
    public boolean isVisited(HGHandle handle) {
        Boolean b = this.examined.get(handle);
        return b != null && b != false;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    public void reset() {
        this.examined.clear();
        this.to_explore.clear();
        this.init();
    }
}

