/*
 * Decompiled with CFR 0.152.
 */
package org.hypergraphdb.algorithms;

import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.Queue;
import org.hypergraphdb.HGHandle;
import org.hypergraphdb.HGSearchResult;
import org.hypergraphdb.algorithms.HGALGenerator;
import org.hypergraphdb.algorithms.HGTraversal;
import org.hypergraphdb.util.Pair;

public class CopyGraphTraversal
implements HGTraversal {
    private HGHandle startAtom;
    private int maxDistance;
    private Map<Pair<HGHandle, HGHandle>, Boolean> examined = new HashMap<Pair<HGHandle, HGHandle>, Boolean>();
    private Queue<Pair<Pair<HGHandle, HGHandle>, Integer>> to_explore = new LinkedList<Pair<Pair<HGHandle, HGHandle>, Integer>>();
    private HGALGenerator adjListGenerator;
    private boolean initialized = false;

    private void init() {
        this.maxDistance = Integer.MAX_VALUE;
        this.examined.put(new Pair<Object, HGHandle>(null, this.startAtom), Boolean.TRUE);
        this.advance(this.startAtom, 0);
        this.initialized = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void advance(HGHandle from, int distance) {
        if (distance >= this.maxDistance) {
            return;
        }
        HGSearchResult<Pair<HGHandle, HGHandle>> i = this.adjListGenerator.generate(from);
        try {
            Integer dd = distance + 1;
            while (i.hasNext()) {
                Pair curr = (Pair)i.next();
                if (this.examined.containsKey(curr)) continue;
                this.to_explore.add(new Pair<Pair, Integer>(curr, dd));
                this.examined.put(curr, Boolean.FALSE);
            }
        }
        finally {
            i.close();
        }
    }

    public void setStartAtom(HGHandle startAtom) {
        this.startAtom = startAtom;
    }

    public HGHandle getStartAtom() {
        return this.startAtom;
    }

    public HGALGenerator getAdjListGenerator() {
        return this.adjListGenerator;
    }

    public void setAdjListGenerator(HGALGenerator adjListGenerator) {
        this.adjListGenerator = adjListGenerator;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    public CopyGraphTraversal() {
    }

    public CopyGraphTraversal(HGHandle startAtom, HGALGenerator adjListGenerator) {
        this(startAtom, adjListGenerator, Integer.MAX_VALUE);
    }

    public CopyGraphTraversal(HGHandle startAtom, HGALGenerator adjListGenerator, int maxDistance) {
        this.maxDistance = maxDistance;
        this.startAtom = startAtom;
        this.adjListGenerator = adjListGenerator;
        this.init();
    }

    @Override
    public boolean hasNext() {
        if (!this.initialized) {
            this.init();
        }
        return !this.to_explore.isEmpty();
    }

    @Override
    public boolean isVisited(HGHandle handle) {
        Boolean b = this.examined.get(handle);
        return b != null && b != false;
    }

    @Override
    public Pair<HGHandle, HGHandle> next() {
        if (!this.initialized) {
            this.init();
        }
        Pair<HGHandle, HGHandle> rvalue = null;
        if (!this.to_explore.isEmpty()) {
            Pair<Pair<HGHandle, HGHandle>, Integer> x = this.to_explore.remove();
            rvalue = x.getFirst();
            this.examined.put(rvalue, Boolean.TRUE);
            this.advance(rvalue.getSecond(), x.getSecond());
        }
        return rvalue;
    }

    public void reset() {
        this.examined.clear();
        this.to_explore.clear();
        this.init();
    }
}

