/*
 * Decompiled with CFR 0.152.
 */
package org.hypergraphdb;

import org.hypergraphdb.HGHandle;
import org.hypergraphdb.HGPersistentHandle;
import org.hypergraphdb.HGRandomAccessResult;
import org.hypergraphdb.HGSearchResult;
import org.hypergraphdb.HyperGraph;
import org.hypergraphdb.IncidenceSet;
import org.hypergraphdb.handle.HGLiveHandle;
import org.hypergraphdb.storage.IndexResultSet;
import org.hypergraphdb.storage.StorageBasedIncidenceSet;
import org.hypergraphdb.transaction.TxCacheSet;
import org.hypergraphdb.transaction.TxSet;
import org.hypergraphdb.util.ArrayBasedSet;
import org.hypergraphdb.util.DummyReadWriteLock;
import org.hypergraphdb.util.HGSortedSet;
import org.hypergraphdb.util.RefCountedMap;
import org.hypergraphdb.util.RefResolver;

class ISRefResolver
implements RefResolver<HGPersistentHandle, IncidenceSet> {
    HyperGraph graph;
    int keepInMemoryThreshold;
    RefCountedMap<HGPersistentHandle, TxSet.SetTxBox<HGHandle>> writeMap;
    RefResolver<HGPersistentHandle, HGSortedSet<HGHandle>> loader = new RefResolver<HGPersistentHandle, HGSortedSet<HGHandle>>(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public HGSortedSet<HGHandle> resolve(HGPersistentHandle key) {
            HGRandomAccessResult<HGPersistentHandle> rs = ISRefResolver.this.graph.getStore().getIncidenceResultSet(key);
            try {
                int size = rs == HGSearchResult.EMPTY ? 0 : ((IndexResultSet)rs).count();
                HGPersistentHandle[] A = new HGPersistentHandle[size];
                for (int i = 0; i < A.length; ++i) {
                    A[i] = (HGPersistentHandle)rs.next();
                }
                ArrayBasedSet<HGHandle> impl = new ArrayBasedSet<HGHandle>(A);
                impl.setLock(new DummyReadWriteLock());
                ArrayBasedSet<HGHandle> arrayBasedSet = impl;
                return arrayBasedSet;
            }
            finally {
                rs.close();
            }
        }
    };

    ISRefResolver(HyperGraph graph) {
        this.graph = graph;
        this.keepInMemoryThreshold = graph.getConfig().getMaxCachedIncidenceSetSize();
        this.writeMap = new RefCountedMap(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IncidenceSet resolve(HGPersistentHandle key) {
        HGRandomAccessResult<HGPersistentHandle> rs = this.graph.getStore().getIncidenceResultSet(key);
        try {
            int size;
            int n = size = rs == HGSearchResult.EMPTY ? 0 : ((IndexResultSet)rs).count();
            if (size < this.keepInMemoryThreshold) {
                HGPersistentHandle[] A = new HGPersistentHandle[size];
                for (int i = 0; i < A.length; ++i) {
                    A[i] = (HGPersistentHandle)rs.next();
                }
                ArrayBasedSet<HGPersistentHandle> impl = new ArrayBasedSet<HGPersistentHandle>(A);
                impl.setLock(new DummyReadWriteLock());
                IncidenceSet result = new IncidenceSet(key, new TxCacheSet<HGPersistentHandle, HGHandle>(this.graph.getTransactionManager(), impl, key, this.loader, this.writeMap));
                HGLiveHandle lHandle = this.graph.cache.get(key);
                if (lHandle != null) {
                    this.graph.updateLinksInIncidenceSet(result, lHandle);
                }
                IncidenceSet incidenceSet = result;
                return incidenceSet;
            }
            IncidenceSet incidenceSet = new IncidenceSet(key, new StorageBasedIncidenceSet(key, this.graph));
            return incidenceSet;
        }
        finally {
            rs.close();
        }
    }
}

