/*
 * Decompiled with CFR 0.152.
 */
package org.hypergraphdb;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.hypergraphdb.HGAtomAttrib;
import org.hypergraphdb.HGAtomCache;
import org.hypergraphdb.HGConfiguration;
import org.hypergraphdb.HGEnvironment;
import org.hypergraphdb.HGException;
import org.hypergraphdb.HGGraphHolder;
import org.hypergraphdb.HGHandle;
import org.hypergraphdb.HGHandleFactory;
import org.hypergraphdb.HGHandleHolder;
import org.hypergraphdb.HGIndex;
import org.hypergraphdb.HGIndexManager;
import org.hypergraphdb.HGLink;
import org.hypergraphdb.HGPersistentHandle;
import org.hypergraphdb.HGQuery;
import org.hypergraphdb.HGRandomAccessResult;
import org.hypergraphdb.HGSearchResult;
import org.hypergraphdb.HGStore;
import org.hypergraphdb.HGTypeHolder;
import org.hypergraphdb.HGTypeSystem;
import org.hypergraphdb.HGValueLink;
import org.hypergraphdb.ISRefResolver;
import org.hypergraphdb.IncidenceSet;
import org.hypergraphdb.IncidenceSetRef;
import org.hypergraphdb.LazyRef;
import org.hypergraphdb.ReadyRef;
import org.hypergraphdb.TxAttribute;
import org.hypergraphdb.atom.HGStats;
import org.hypergraphdb.cache.MRUCache;
import org.hypergraphdb.cache.WeakRefAtomCache;
import org.hypergraphdb.event.HGAtomAccessedEvent;
import org.hypergraphdb.event.HGAtomAddedEvent;
import org.hypergraphdb.event.HGAtomLoadedEvent;
import org.hypergraphdb.event.HGAtomProposeEvent;
import org.hypergraphdb.event.HGAtomRemoveRequestEvent;
import org.hypergraphdb.event.HGAtomRemovedEvent;
import org.hypergraphdb.event.HGAtomReplaceRequestEvent;
import org.hypergraphdb.event.HGAtomReplacedEvent;
import org.hypergraphdb.event.HGClosingEvent;
import org.hypergraphdb.event.HGEventManager;
import org.hypergraphdb.event.HGListener;
import org.hypergraphdb.event.HGListenerAtom;
import org.hypergraphdb.event.HGOpenedEvent;
import org.hypergraphdb.handle.HGLiveHandle;
import org.hypergraphdb.handle.HGManagedLiveHandle;
import org.hypergraphdb.maintenance.MaintenanceException;
import org.hypergraphdb.maintenance.MaintenanceOperation;
import org.hypergraphdb.query.AtomTypeCondition;
import org.hypergraphdb.query.HGQueryCondition;
import org.hypergraphdb.storage.BAtoHandle;
import org.hypergraphdb.transaction.HGTransactionConfig;
import org.hypergraphdb.transaction.HGTransactionManager;
import org.hypergraphdb.type.HGAtomType;
import org.hypergraphdb.type.TypeUtils;
import org.hypergraphdb.util.HGLogger;
import org.hypergraphdb.util.Pair;

public class HyperGraph {
    public static final HGHandle[] EMTPY_HANDLE_SET = new HGHandle[0];
    public static final LazyRef<HGHandle[]> EMTPY_HANDLE_SET_REF = new ReadyRef<HGHandle[]>(new HGHandle[0]);
    public static final HGPersistentHandle[] EMPTY_PERSISTENT_HANDLE_SET = new HGPersistentHandle[0];
    public static final String TYPES_INDEX_NAME = "HGATOMTYPE";
    public static final String VALUES_INDEX_NAME = "HGATOMVALUE";
    public static final String SA_DB_NAME = "HGSYSATTRIBS";
    private String location = null;
    private volatile boolean is_open = false;
    private HGStore store = null;
    private HGIndexManager idx_manager = null;
    private HGTypeSystem typeSystem = null;
    HGAtomCache cache = null;
    HGEventManager eventManager = null;
    final HGLogger logger = new HGLogger();
    HGIndex<HGPersistentHandle, HGPersistentHandle> indexByType = null;
    HGIndex<HGPersistentHandle, HGPersistentHandle> indexByValue = null;
    HGIndex<HGPersistentHandle, HGAtomAttrib> systemAttributesDB = null;
    HGHandle statsHandle = null;
    HGStats stats = new HGStats();
    HGConfiguration config = new HGConfiguration();
    private Object closeLock = new Object();

    public HyperGraph() {
    }

    public HyperGraph(String location) {
        this.open(location);
    }

    public synchronized void open(String location) {
        if (this.location != null && this.location.length() > 0) {
            HGEnvironment.remove(this.location);
        }
        this.location = location;
        this.open();
        HGEnvironment.set(this.location, this);
    }

    public String getLocation() {
        return this.location;
    }

    public HGConfiguration getConfig() {
        return this.config;
    }

    public void setConfig(HGConfiguration config) {
        if (config == null) {
            return;
        }
        this.config = config;
    }

    public HGHandleFactory getHandleFactory() {
        return this.config.getHandleFactory();
    }

    public HGLogger getLogger() {
        return this.logger;
    }

    public void runMaintenance() {
        List<MaintenanceOperation> L = HGQuery.hg.getAll(this, HGQuery.hg.typePlus(MaintenanceOperation.class));
        for (MaintenanceOperation op : L) {
            try {
                op.execute(this);
                this.remove(this.getHandle(op));
            }
            catch (MaintenanceException ex) {
                ex.printStackTrace(System.err);
                if (!ex.isFatal()) continue;
                break;
            }
        }
    }

    private synchronized void open() {
        if (this.is_open) {
            this.close();
        }
        this.is_open = true;
        try {
            this.store = new HGStore(this.location, this.config);
            this.store.getTransactionManager().setHyperGraph(this);
            this.eventManager = new HGEventManager(this);
            this.cache = new WeakRefAtomCache(this);
            this.cache.setHyperGraph(this);
            MRUCache<HGPersistentHandle, IncidenceSet> incidenceCache = new MRUCache<HGPersistentHandle, IncidenceSet>(0.9f, 0.3f);
            incidenceCache.setLockImplementation(new ReentrantReadWriteLock());
            incidenceCache.setResolver(new ISRefResolver(this));
            this.cache.setIncidenceCache(incidenceCache);
            this.typeSystem = new HGTypeSystem(this);
            this.indexByType = this.store.getIndex(TYPES_INDEX_NAME, BAtoHandle.getInstance(this.getHandleFactory()), BAtoHandle.getInstance(this.getHandleFactory()), null, true);
            this.indexByValue = this.store.getIndex(VALUES_INDEX_NAME, BAtoHandle.getInstance(this.getHandleFactory()), BAtoHandle.getInstance(this.getHandleFactory()), null, true);
            if (this.config.isUseSystemAtomAttributes()) {
                this.systemAttributesDB = this.store.getIndex(SA_DB_NAME, BAtoHandle.getInstance(this.getHandleFactory()), HGAtomAttrib.baConverter, null, true);
            }
            this.idx_manager = new HGIndexManager(this);
            this.getTransactionManager().beginTransaction(HGTransactionConfig.DEFAULT);
            this.typeSystem.bootstrap(this.config.getTypeConfiguration());
            this.getTransactionManager().endTransaction(true);
            this.idx_manager.loadIndexers();
            this.initAtomManagement();
            this.loadListeners();
            if (this.config == null || !this.config.getSkipOpenedEvent()) {
                this.eventManager.dispatch(this, new HGOpenedEvent());
            }
            if (this.config != null) {
                if (this.config.getCancelMaintenance()) {
                    List<HGHandle> L = HGQuery.hg.findAll(this, HGQuery.hg.typePlus(MaintenanceOperation.class));
                    for (HGHandle x : L) {
                        this.remove(x);
                    }
                } else if (!this.config.getSkipMaintenance()) {
                    this.runMaintenance();
                }
            }
        }
        catch (Throwable t) {
            if (this.store != null) {
                try {
                    this.store.close();
                }
                catch (Throwable t1) {
                    // empty catch block
                }
            }
            try {
                this.cache.close();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            this.is_open = false;
            throw new HGException(t);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        Object object = this.closeLock;
        synchronized (object) {
            if (!this.is_open) {
                return;
            }
            ArrayList<Throwable> problems = new ArrayList<Throwable>();
            try {
                this.eventManager.dispatch(this, new HGClosingEvent());
            }
            catch (Throwable t) {
                problems.add(t);
            }
            try {
                this.replace(this.statsHandle, this.stats);
            }
            catch (Throwable t) {
                problems.add(t);
            }
            try {
                this.cache.close();
            }
            catch (Throwable t) {
                problems.add(t);
            }
            try {
                this.idx_manager.close();
            }
            catch (Throwable t) {
                problems.add(t);
            }
            try {
                this.eventManager.clear();
            }
            catch (Throwable t) {
                problems.add(t);
            }
            try {
                this.store.close();
            }
            catch (Throwable t) {
                problems.add(t);
            }
            this.is_open = false;
            for (Throwable t : problems) {
                System.err.println("Problem during HyperGraph close, stack trace of exception follows:");
                t.printStackTrace(System.err);
            }
        }
    }

    public boolean isOpen() {
        return this.is_open;
    }

    public HGStore getStore() {
        return this.store;
    }

    public HGTransactionManager getTransactionManager() {
        return this.store.getTransactionManager();
    }

    public HGTypeSystem getTypeSystem() {
        return this.typeSystem;
    }

    public HGAtomCache getCache() {
        return this.cache;
    }

    public HGEventManager getEventManager() {
        return this.eventManager;
    }

    public HGPersistentHandle getPersistentHandle(HGHandle handle) {
        if (handle instanceof HGPersistentHandle) {
            return (HGPersistentHandle)handle;
        }
        return ((HGLiveHandle)handle).getPersistentHandle();
    }

    public boolean isLoaded(HGHandle handle) {
        if (handle instanceof HGPersistentHandle) {
            return this.cache.get(handle) != null;
        }
        return true;
    }

    public boolean isFrozen(HGHandle handle) {
        HGLiveHandle lHandle = handle instanceof HGPersistentHandle ? this.cache.get((HGPersistentHandle)handle) : (HGLiveHandle)handle;
        return lHandle == null ? false : this.cache.isFrozen(lHandle);
    }

    public Object freeze(HGHandle handle) {
        HGLiveHandle lHandle;
        if (handle == null) {
            throw new NullPointerException("Trying to freeze null atom handle.");
        }
        this.get(handle);
        HGLiveHandle hGLiveHandle = lHandle = handle instanceof HGPersistentHandle ? this.cache.get((HGPersistentHandle)handle) : (HGLiveHandle)handle;
        while (lHandle == null) {
            this.get(handle);
            lHandle = this.cache.get((HGPersistentHandle)handle);
        }
        if (!this.cache.isFrozen(lHandle)) {
            this.cache.freeze(lHandle);
        }
        return lHandle.getRef();
    }

    public void unfreeze(HGHandle handle) {
        HGLiveHandle lHandle;
        HGLiveHandle hGLiveHandle = lHandle = handle instanceof HGPersistentHandle ? this.cache.get((HGPersistentHandle)handle) : (HGLiveHandle)handle;
        if (lHandle != null && this.cache.isFrozen(lHandle)) {
            this.cache.unfreeze(lHandle);
        }
    }

    public boolean isIncidenceSetLoaded(HGHandle h) {
        return this.cache.getIncidenceCache().isLoaded(this.getPersistentHandle(h));
    }

    public HGHandle add(Object atom) {
        return this.add(atom, 0);
    }

    public HGHandle add(Object atom, int flags) {
        HGLiveHandle result;
        if (atom instanceof HGLink) {
            HGHandle type;
            HGLink link = (HGLink)atom;
            Object value = link;
            if (link instanceof HGValueLink) {
                value = ((HGValueLink)link).getValue();
            }
            if ((type = this.typeSystem.getTypeHandle(value.getClass())) == null) {
                throw new HGException("Unable to create HyperGraph type for class " + value.getClass().getName());
            }
            result = this.addLink(value, type, link, (byte)flags);
        } else {
            HGHandle type = this.typeSystem.getTypeHandle(atom.getClass());
            if (type == null) {
                throw new HGException("Unable to create HyperGraph type for class " + atom.getClass().getName());
            }
            result = this.addNode(atom, type, (byte)flags);
        }
        this.eventManager.dispatch(this, new HGAtomAddedEvent(result));
        return result;
    }

    public HGHandle add(Object atom, HGHandle type) {
        return this.add(atom, type, 0);
    }

    public HGHandle add(Object atom, HGHandle type, int flags) {
        HGLiveHandle result;
        if (this.eventManager.dispatch(this, new HGAtomProposeEvent(atom, type, flags)) == HGListener.Result.cancel) {
            return null;
        }
        if (atom instanceof HGLink) {
            HGLink link = (HGLink)atom;
            Object value = link;
            if (link instanceof HGValueLink) {
                value = ((HGValueLink)link).getValue();
            }
            result = this.addLink(value, type, link, (byte)flags);
        } else {
            result = this.addNode(atom, type, (byte)flags);
        }
        if (atom instanceof HGGraphHolder) {
            ((HGGraphHolder)atom).setHyperGraph(this);
        }
        if (atom instanceof HGHandleHolder) {
            ((HGHandleHolder)atom).setAtomHandle(result);
        }
        this.eventManager.dispatch(this, new HGAtomAddedEvent(result));
        return result;
    }

    public HGHandle refreshHandle(HGHandle handle) {
        if (handle instanceof HGPersistentHandle) {
            HGLiveHandle result = this.cache.get((HGPersistentHandle)handle);
            return result != null ? result : handle;
        }
        HGLiveHandle live = (HGLiveHandle)handle;
        if (live.getRef() == null) {
            HGLiveHandle updated = this.cache.get(live.getPersistentHandle());
            if (updated != null) {
                return updated;
            }
            return live.getPersistentHandle();
        }
        return handle;
    }

    /*
     * Enabled aggressive block sorting
     */
    public <T> T get(HGHandle handle) {
        Pair<HGLiveHandle, Object> loaded;
        this.stats.atomAccessed();
        HGLiveHandle liveHandle = null;
        HGPersistentHandle persistentHandle = null;
        liveHandle = handle instanceof HGLiveHandle ? (HGLiveHandle)handle : this.cache.get((HGPersistentHandle)handle);
        if (liveHandle != null) {
            Object theAtom = liveHandle.getRef();
            if (theAtom != null && this.cache.get(theAtom) != null) {
                this.eventManager.dispatch(this, new HGAtomAccessedEvent(liveHandle, theAtom));
                return (T)theAtom;
            }
            HGLiveHandle existing = this.cache.get(liveHandle.getPersistentHandle());
            if (existing != null && (theAtom = existing.getRef()) != null) {
                this.eventManager.dispatch(this, new HGAtomAccessedEvent(existing, theAtom));
                return (T)theAtom;
            }
            persistentHandle = liveHandle.getPersistentHandle();
        } else {
            persistentHandle = (HGPersistentHandle)handle;
        }
        if ((loaded = this.loadAtom(persistentHandle, liveHandle)) == null) {
            return null;
        }
        liveHandle = loaded.getFirst();
        IncidenceSet incidenceSet = this.cache.getIncidenceCache().getIfLoaded(persistentHandle);
        if (incidenceSet != null) {
            this.updateLinksInIncidenceSet(incidenceSet, liveHandle);
        }
        this.eventManager.dispatch(this, new HGAtomAccessedEvent(liveHandle, loaded.getSecond()));
        return (T)loaded.getSecond();
    }

    public HGHandle getHandle(Object atom) {
        return this.cache.get(atom);
    }

    public HGHandle getType(HGHandle handle) {
        HGPersistentHandle pHandle;
        Object atom = null;
        if (handle instanceof HGLiveHandle) {
            atom = ((HGLiveHandle)handle).getRef();
            pHandle = ((HGLiveHandle)handle).getPersistentHandle();
        } else {
            pHandle = (HGPersistentHandle)handle;
            HGLiveHandle lHandle = this.cache.get(pHandle);
            if (lHandle != null) {
                atom = lHandle.getRef();
            }
        }
        if (atom != null && atom instanceof HGTypeHolder) {
            return this.getHandle(((HGTypeHolder)atom).getAtomType());
        }
        HGPersistentHandle[] link = this.store.getLink(pHandle);
        if (link == null || link.length < 2) {
            return null;
        }
        return this.refreshHandle(link[0]);
    }

    public boolean remove(HGHandle handle) {
        return this.remove(handle, false);
    }

    public boolean remove(final HGHandle handle, final boolean keepIncidentLinks) {
        if (this.eventManager.dispatch(this, new HGAtomRemoveRequestEvent(handle)) == HGListener.Result.cancel) {
            return false;
        }
        this.getTransactionManager().ensureTransaction(new Callable<Object>(){

            @Override
            public Object call() {
                HyperGraph.this.removeTransaction(handle, keepIncidentLinks);
                return null;
            }
        });
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeTransaction(HGHandle handle, boolean keepIncidentLinks) {
        HGPersistentHandle pHandle = this.getPersistentHandle(handle);
        Set inRemoval = TxAttribute.getSet(this.getTransactionManager(), TxAttribute.IN_REMOVAL, HashSet.class);
        if (inRemoval.contains(handle)) {
            return;
        }
        inRemoval.add(pHandle);
        try {
            HGPersistentHandle[] layout = this.store.getLink(pHandle);
            if (layout == null) {
                return;
            }
            if (layout[0].equals(this.typeSystem.getTop())) {
                throw new HGException("Cannot remove the HyperGraph primitive type: " + pHandle);
            }
            Object atom = this.get(handle);
            if (atom instanceof HGAtomType) {
                HGRandomAccessResult<HGPersistentHandle> instances = null;
                try {
                    instances = this.indexByType.find(pHandle);
                    while (instances.hasNext()) {
                        this.removeTransaction((HGPersistentHandle)instances.next(), keepIncidentLinks);
                    }
                }
                finally {
                    if (instances != null) {
                        instances.close();
                    }
                }
                this.idx_manager.unregisterAll(pHandle);
                this.typeSystem.remove(pHandle, (HGAtomType)atom);
            }
            HGPersistentHandle typeHandle = layout[0];
            HGPersistentHandle valueHandle = layout[1];
            HGAtomType type = this.typeSystem.getType(typeHandle);
            this.idx_manager.maybeUnindex(typeHandle, type, atom, pHandle);
            this.indexByType.removeEntry(typeHandle, pHandle);
            this.indexByValue.removeEntry(valueHandle, pHandle);
            TypeUtils.releaseValue(this, type, valueHandle);
            type.release(valueHandle);
            this.store.removeLink(pHandle);
            if (layout.length > 2) {
                for (int i = 2; i < layout.length; ++i) {
                    this.removeFromIncidenceSet(layout[i], pHandle);
                }
            }
            if (keepIncidentLinks) {
                IncidenceSet incidenceSet = this.cache.getIncidenceCache().get(pHandle);
                HGRandomAccessResult<HGHandle> rsInc = incidenceSet.getSearchResult();
                try {
                    while (rsInc.hasNext()) {
                        this.targetRemoved((HGHandle)rsInc.next(), pHandle);
                    }
                }
                finally {
                    rsInc.close();
                }
            }
            IncidenceSet incidenceSet = this.cache.getIncidenceCache().getIfLoaded(pHandle);
            if (incidenceSet != null) {
                HGRandomAccessResult<HGHandle> rsInc = incidenceSet.getSearchResult();
                try {
                    while (rsInc.hasNext()) {
                        this.removeTransaction((HGHandle)rsInc.next(), false);
                    }
                }
                finally {
                    rsInc.close();
                }
            }
            HGRandomAccessResult<HGPersistentHandle> rsInc = this.store.getIncidenceResultSet(pHandle);
            try {
                while (rsInc.hasNext()) {
                    this.removeTransaction((HGHandle)rsInc.next(), false);
                }
            }
            finally {
                rsInc.close();
            }
            this.store.removeIncidenceSet(pHandle);
            this.cache.getIncidenceCache().remove(pHandle);
            this.cache.remove(this.cache.get(atom));
            this.eventManager.dispatch(this, new HGAtomRemovedEvent(pHandle));
        }
        finally {
            inRemoval.remove(pHandle);
        }
    }

    public boolean update(Object atom) {
        HGHandle h = this.getHandle(atom);
        if (h == null) {
            throw new HGException("Could not find HyperGraph handle for atom " + atom);
        }
        return this.replace(h, atom, this.getType(h));
    }

    public boolean replace(HGHandle handle, Object atom) {
        HGHandle atomType;
        if (handle.equals(this.getHandle(atom))) {
            return this.replace(handle, atom, this.getType(handle));
        }
        if (atom instanceof HGValueLink) {
            Class<?> c = ((HGValueLink)atom).getValue().getClass();
            atomType = this.typeSystem.getTypeHandle(c);
            if (atomType == null) {
                throw new HGException("Unable to create HyperGraph type for class " + c.getName());
            }
        } else {
            atomType = this.typeSystem.getTypeHandle(atom.getClass());
            if (atomType == null) {
                throw new HGException("Unable to create HyperGraph type for class " + atom.getClass().getName());
            }
        }
        return this.replace(handle, atom, atomType);
    }

    public boolean replace(HGHandle handle, Object atom, HGHandle type) {
        if (this.eventManager.dispatch(this, new HGAtomReplaceRequestEvent(handle, type, atom)) == HGListener.Result.cancel) {
            return false;
        }
        HGPersistentHandle pHandle = null;
        HGLiveHandle lHandle = null;
        if (handle instanceof HGPersistentHandle) {
            pHandle = (HGPersistentHandle)handle;
            lHandle = this.cache.get(pHandle);
        } else {
            lHandle = (HGLiveHandle)handle;
            pHandle = lHandle.getPersistentHandle();
        }
        this.replaceInternal(lHandle, pHandle, atom, type);
        this.eventManager.dispatch(this, new HGAtomReplacedEvent(lHandle));
        return true;
    }

    public void define(final HGPersistentHandle atomHandle, final HGHandle typeHandle, final HGHandle valueHandle, final HGLink outgoingSet, final Object instance) {
        this.getTransactionManager().ensureTransaction(new Callable<Object>(){

            @Override
            public Object call() {
                HGPersistentHandle[] layout = new HGPersistentHandle[outgoingSet == null ? 2 : 2 + outgoingSet.getArity()];
                layout[0] = HyperGraph.this.getPersistentHandle(typeHandle);
                layout[1] = HyperGraph.this.getPersistentHandle(valueHandle);
                if (outgoingSet != null) {
                    for (int i = 0; i < outgoingSet.getArity(); ++i) {
                        layout[i + 2] = HyperGraph.this.getPersistentHandle(outgoingSet.getTargetAt(i));
                    }
                }
                HyperGraph.this.store.store(atomHandle, layout);
                HyperGraph.this.indexByType.addEntry(layout[0], atomHandle);
                HyperGraph.this.indexByValue.addEntry(layout[1], atomHandle);
                HGAtomType type = (HGAtomType)HyperGraph.this.get(typeHandle);
                ReadyRef<HGHandle[]> linkRef = null;
                if (outgoingSet != null) {
                    HGHandle[] targets = new HGHandle[outgoingSet.getArity()];
                    System.arraycopy(layout, 2, targets, 0, targets.length);
                    HyperGraph.this.updateTargetsIncidenceSets(atomHandle, outgoingSet);
                    linkRef = new ReadyRef<HGHandle[]>(targets);
                }
                HyperGraph.this.idx_manager.maybeIndex(layout[0], type, atomHandle, instance == null ? type.make(layout[1], linkRef, null) : instance);
                return null;
            }
        });
    }

    public void define(HGPersistentHandle atomHandle, Object instance, byte flags) {
        HGHandle typeHandle = null;
        typeHandle = instance == null ? this.typeSystem.getNullType() : this.typeSystem.getTypeHandle(instance.getClass());
        if (typeHandle == null) {
            throw new HGException("Could not find HyperGraph type for object of type " + instance.getClass());
        }
        this.define(atomHandle, typeHandle, instance, flags);
    }

    public void define(final HGPersistentHandle atomHandle, final HGHandle typeHandle, final Object instance, final byte flags) {
        this.getTransactionManager().ensureTransaction(new Callable<Object>(){

            @Override
            public Object call() {
                HGAtomType type = HyperGraph.this.typeSystem.getType(typeHandle);
                HGLink link = null;
                Object payload = instance;
                if (instance instanceof HGLink) {
                    link = (HGLink)instance;
                    if (instance instanceof HGValueLink) {
                        payload = ((HGValueLink)instance).getValue();
                    }
                }
                HGPersistentHandle valueHandle = TypeUtils.storeValue(HyperGraph.this, payload, type);
                HyperGraph.this.define(atomHandle, typeHandle, valueHandle, link, instance);
                HyperGraph.this.atomAdded(atomHandle, instance, flags);
                if (instance instanceof HGTypeHolder) {
                    ((HGTypeHolder)instance).setAtomType(type);
                }
                return null;
            }
        });
    }

    public void define(HGPersistentHandle atomHandle, Object instance) {
        this.define(atomHandle, instance, (byte)0);
    }

    public IncidenceSet getIncidenceSet(HGHandle handle) {
        return this.cache.getIncidenceCache().get(this.getPersistentHandle(handle));
    }

    public int getSystemFlags(HGHandle handle) {
        if (!this.config.isUseSystemAtomAttributes()) {
            return 0;
        }
        if (handle instanceof HGLiveHandle) {
            if (handle instanceof HGManagedLiveHandle) {
                return ((HGManagedLiveHandle)handle).getFlags();
            }
            return 0;
        }
        HGAtomAttrib attribs = this.getAtomAttributes((HGPersistentHandle)handle);
        if (attribs != null) {
            return attribs.flags;
        }
        return 0;
    }

    public void setSystemFlags(final HGHandle handle, final int flags) {
        if (!this.config.isUseSystemAtomAttributes()) {
            return;
        }
        this.getTransactionManager().ensureTransaction(new Callable<Object>(){

            @Override
            public Object call() {
                HGPersistentHandle pHandle = HyperGraph.this.getPersistentHandle(handle);
                HGAtomAttrib attribs = HyperGraph.this.getAtomAttributes(pHandle);
                boolean managed = (flags & 2) != 0;
                boolean wasManaged = false;
                if (attribs != null) {
                    boolean bl = wasManaged = (attribs.flags & 2) != 0;
                    if (flags == 0) {
                        HyperGraph.this.removeAtomAttributes(pHandle);
                        attribs = null;
                    } else {
                        if (!wasManaged && managed) {
                            attribs.lastAccessTime = System.currentTimeMillis();
                            attribs.retrievalCount = 1L;
                        }
                        attribs.flags = (byte)flags;
                        HyperGraph.this.setAtomAttributes(pHandle, attribs);
                    }
                } else if (flags != 0) {
                    attribs = new HGAtomAttrib();
                    attribs.flags = (byte)flags;
                    if (managed) {
                        attribs.lastAccessTime = System.currentTimeMillis();
                        attribs.retrievalCount = 1L;
                    }
                    HyperGraph.this.setAtomAttributes(pHandle, attribs);
                } else {
                    return null;
                }
                HGLiveHandle lHandle = HyperGraph.this.cache.get(pHandle);
                if (lHandle != null) {
                    Object instance = lHandle.getRef();
                    if (wasManaged && managed) {
                        attribs.lastAccessTime = ((HGManagedLiveHandle)lHandle).getLastAccessTime();
                        attribs.retrievalCount = ((HGManagedLiveHandle)lHandle).getRetrievalCount();
                    }
                    HyperGraph.this.cache.remove(lHandle);
                    if (instance != null) {
                        HyperGraph.this.cache.atomRead(pHandle, instance, attribs);
                    }
                }
                return null;
            }
        });
    }

    public <T> HGSearchResult<T> find(HGQueryCondition condition) {
        HGQuery query = HGQuery.make(this, condition);
        return query.execute();
    }

    public HGIndexManager getIndexManager() {
        return this.idx_manager;
    }

    private HGLiveHandle addNode(final Object payload, final HGHandle typeHandle, final byte flags) {
        return this.getTransactionManager().ensureTransaction(new Callable<HGLiveHandle>(){

            @Override
            public HGLiveHandle call() {
                HGAtomType type = HyperGraph.this.typeSystem.getType(typeHandle);
                HGPersistentHandle pTypeHandle = HyperGraph.this.getPersistentHandle(typeHandle);
                HGPersistentHandle valueHandle = TypeUtils.storeValue(HyperGraph.this, payload, type);
                HGPersistentHandle[] layout = new HGPersistentHandle[]{pTypeHandle, valueHandle};
                HGLiveHandle lHandle = HyperGraph.this.atomAdded(HyperGraph.this.store.store(layout), payload, flags);
                if (payload instanceof HGTypeHolder) {
                    ((HGTypeHolder)payload).setAtomType(type);
                }
                HyperGraph.this.indexByType.addEntry(pTypeHandle, lHandle.getPersistentHandle());
                HyperGraph.this.indexByValue.addEntry(valueHandle, lHandle.getPersistentHandle());
                HyperGraph.this.idx_manager.maybeIndex(pTypeHandle, type, lHandle.getPersistentHandle(), payload);
                return lHandle;
            }
        });
    }

    private HGLiveHandle addLink(final Object payload, final HGHandle typeHandle, final HGLink outgoingSet, final byte flags) {
        return this.getTransactionManager().ensureTransaction(new Callable<HGLiveHandle>(){

            @Override
            public HGLiveHandle call() {
                HGAtomType type = HyperGraph.this.typeSystem.getType(typeHandle);
                HGPersistentHandle pTypeHandle = HyperGraph.this.getPersistentHandle(typeHandle);
                HGPersistentHandle valueHandle = TypeUtils.storeValue(HyperGraph.this, payload, type);
                HGPersistentHandle[] layout = new HGPersistentHandle[2 + outgoingSet.getArity()];
                layout[0] = pTypeHandle;
                layout[1] = valueHandle;
                for (int i = 0; i < outgoingSet.getArity(); ++i) {
                    layout[i + 2] = HyperGraph.this.getPersistentHandle(outgoingSet.getTargetAt(i));
                }
                HGPersistentHandle pHandle = HyperGraph.this.store.store(layout);
                HGLiveHandle lHandle = HyperGraph.this.atomAdded(pHandle, outgoingSet, flags);
                if (payload instanceof HGTypeHolder) {
                    ((HGTypeHolder)payload).setAtomType(type);
                }
                HyperGraph.this.indexByType.addEntry(pTypeHandle, pHandle);
                HyperGraph.this.indexByValue.addEntry(valueHandle, pHandle);
                HyperGraph.this.idx_manager.maybeIndex(pTypeHandle, type, pHandle, payload);
                HyperGraph.this.updateTargetsIncidenceSets(pHandle, outgoingSet);
                return lHandle;
            }
        });
    }

    private HGLiveHandle atomAdded(HGPersistentHandle pHandle, Object instance, byte flags) {
        HGLiveHandle lHandle;
        if (instance instanceof HGGraphHolder) {
            ((HGGraphHolder)instance).setHyperGraph(this);
        }
        if (this.config.isUseSystemAtomAttributes()) {
            HGAtomAttrib attribs = new HGAtomAttrib();
            attribs.flags = flags;
            attribs.retrievalCount = 1L;
            attribs.lastAccessTime = System.currentTimeMillis();
            this.setAtomAttributes(pHandle, attribs);
            lHandle = this.cache.atomAdded(pHandle, instance, attribs);
        } else {
            HGAtomAttrib attribs = new HGAtomAttrib();
            if (this.config.isUseSystemAtomAttributes() && flags != 0) {
                attribs.flags = flags;
                this.setAtomAttributes(pHandle, attribs);
            }
            lHandle = this.cache.atomAdded(pHandle, instance, attribs);
        }
        if (instance instanceof HGHandleHolder) {
            ((HGHandleHolder)instance).setAtomHandle(lHandle);
        }
        return lHandle;
    }

    private Pair<HGLiveHandle, Object> loadAtom(final HGPersistentHandle persistentHandle, final HGLiveHandle liveHandle) {
        return this.getTransactionManager().ensureTransaction(new Callable<Pair<HGLiveHandle, Object>>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Pair<HGLiveHandle, Object> call() {
                Object instance;
                HGPersistentHandle[] link = HyperGraph.this.store.getLink(persistentHandle);
                if (link == null) {
                    return null;
                }
                if (link.length < 2) {
                    throw new HGException("The persistent handle " + persistentHandle + " doesn't refer to a HyperGraph atom.");
                }
                HGPersistentHandle typeHandle = link[0];
                HGPersistentHandle valueHandle = link[1];
                if (typeHandle.equals(HyperGraph.this.typeSystem.getTop())) {
                    HGLiveHandle result = HyperGraph.this.typeSystem.loadPredefinedType(persistentHandle);
                    return new Pair<HGLiveHandle, Object>(result, result.getRef());
                }
                IncidenceSetRef isref = new IncidenceSetRef(persistentHandle, HyperGraph.this);
                HGAtomType type = HyperGraph.this.typeSystem.getType(typeHandle);
                boolean topCall = TypeUtils.initThreadLocals();
                try {
                    if (type == null) {
                        throw new HGException("Unable to find type with handle " + typeHandle + " in database.");
                    }
                    if (link.length == 2) {
                        instance = type.make(valueHandle, EMTPY_HANDLE_SET_REF, isref);
                    } else {
                        HGHandle[] targets = new HGHandle[link.length - 2];
                        for (int i = 2; i < link.length; ++i) {
                            HGPersistentHandle pHandle = link[i];
                            HGLiveHandle lHandle = HyperGraph.this.cache.get(pHandle);
                            targets[i - 2] = lHandle != null ? lHandle : pHandle;
                        }
                        instance = type.make(valueHandle, new ReadyRef<HGHandle[]>(targets), isref);
                        if (!(instance instanceof HGLink)) {
                            instance = new HGValueLink(instance, targets);
                        }
                    }
                }
                finally {
                    TypeUtils.releaseThreadLocals(topCall);
                }
                if (instance instanceof HGAtomType) {
                    instance = HyperGraph.this.typeSystem.toJavaBinding(persistentHandle, (HGAtomType)instance);
                }
                HGLiveHandle result = null;
                if (liveHandle == null) {
                    HGAtomAttrib attribs = HyperGraph.this.config.isUseSystemAtomAttributes() ? HyperGraph.this.getAtomAttributes(persistentHandle) : new HGAtomAttrib();
                    result = HyperGraph.this.cache.atomRead(persistentHandle, instance, attribs);
                } else {
                    result = HyperGraph.this.cache.atomRefresh(liveHandle, instance, false);
                }
                if (instance instanceof HGGraphHolder) {
                    ((HGGraphHolder)instance).setHyperGraph(HyperGraph.this);
                }
                if (instance instanceof HGHandleHolder) {
                    ((HGHandleHolder)instance).setAtomHandle(result);
                }
                if (instance instanceof HGTypeHolder) {
                    ((HGTypeHolder)instance).setAtomType(type);
                }
                HyperGraph.this.eventManager.dispatch(HyperGraph.this, new HGAtomLoadedEvent(result, instance));
                return new Pair<HGLiveHandle, Object>(result, instance);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void updateLinksInIncidenceSet(IncidenceSet incidenceSet, HGLiveHandle liveHandle) {
        HGRandomAccessResult<HGHandle> rs = incidenceSet.getSearchResult();
        try {
            while (rs.hasNext()) {
                HGLink incidenceLink;
                HGLiveHandle lh = this.cache.get((HGPersistentHandle)rs.next());
                if (lh == null || (incidenceLink = (HGLink)lh.getRef()) == null) continue;
                this.updateLinkLiveHandle(incidenceLink, liveHandle);
            }
        }
        finally {
            rs.close();
        }
    }

    void updateLinkLiveHandle(HGLink link, HGLiveHandle lHandle) {
        int arity = link.getArity();
        for (int i = 0; i < arity; ++i) {
            HGHandle current = link.getTargetAt(i);
            if (current == lHandle) {
                return;
            }
            if (!current.equals(lHandle.getPersistentHandle())) continue;
            link.notifyTargetHandleUpdate(i, lHandle);
            return;
        }
    }

    void updateTargetIncidenceSet(HGPersistentHandle targetHandle, HGPersistentHandle linkHandle) {
        this.store.addIncidenceLink(targetHandle, linkHandle);
        IncidenceSet targetIncidenceSet = this.cache.getIncidenceCache().getIfLoaded(targetHandle);
        if (targetIncidenceSet != null) {
            targetIncidenceSet.add(linkHandle);
        }
    }

    void updateTargetsIncidenceSets(HGPersistentHandle atomHandle, HGLink link) {
        for (int i = 0; i < link.getArity(); ++i) {
            this.updateTargetIncidenceSet(this.getPersistentHandle(link.getTargetAt(i)), atomHandle);
        }
    }

    private void targetRemoved(HGHandle linkHandle, HGHandle target) {
        HGLink l = (HGLink)this.get(linkHandle);
        int pos = -1;
        for (int i = 0; i < l.getArity(); ++i) {
            if (!target.equals(l.getTargetAt(i))) continue;
            pos = i;
            break;
        }
        if (pos > -1) {
            l.notifyTargetRemoved(pos);
            this.replaceTransaction(this.cache.get(l), this.getPersistentHandle(linkHandle), l, this.getType(linkHandle));
        }
    }

    private void removeFromIncidenceSet(HGPersistentHandle targetAtom, HGPersistentHandle incidentLink) {
        this.store.removeIncidenceLink(targetAtom, incidentLink);
        IncidenceSet targetIncidenceSet = this.cache.getIncidenceCache().getIfLoaded(targetAtom);
        if (targetIncidenceSet != null) {
            targetIncidenceSet.remove(incidentLink);
        }
    }

    public Object rawMake(HGPersistentHandle[] layout, HGAtomType type, HGPersistentHandle atomHandle) {
        HGHandle[] targetSet = EMPTY_PERSISTENT_HANDLE_SET;
        if (layout.length > 2) {
            targetSet = new HGPersistentHandle[layout.length - 2];
            for (int i = 2; i < layout.length; ++i) {
                targetSet[i - 2] = layout[i];
            }
        }
        Object result = type.make(layout[1], new ReadyRef<HGPersistentHandle[]>((HGPersistentHandle[])targetSet), new IncidenceSetRef(atomHandle, this));
        if (targetSet.length > 0 && !(result instanceof HGLink)) {
            result = new HGValueLink(result, targetSet);
        }
        if (result instanceof HGAtomType) {
            result = this.typeSystem.toJavaBinding(atomHandle, (HGAtomType)result);
        }
        return result;
    }

    private void replaceInternal(final HGLiveHandle lHandle, final HGPersistentHandle pHandle, final Object atom, final HGHandle typeHandle) {
        this.getTransactionManager().ensureTransaction(new Callable<Object>(){

            @Override
            public Object call() {
                HyperGraph.this.replaceTransaction(lHandle, pHandle, atom, typeHandle);
                return null;
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void replaceTransaction(HGLiveHandle lHandle, HGPersistentHandle pHandle, Object atom, HGHandle typeHandle) {
        HGPersistentHandle[] newLayout;
        Object oldValue;
        Object newValue = atom;
        if (atom instanceof HGValueLink) {
            newValue = ((HGValueLink)atom).getValue();
        }
        HGPersistentHandle[] layout = this.store.getLink(pHandle);
        HGPersistentHandle oldValueHandle = layout[1];
        HGPersistentHandle oldTypeHandle = layout[0];
        HGAtomType oldType = (HGAtomType)this.get(oldTypeHandle);
        HGAtomType type = (HGAtomType)this.get(typeHandle);
        if (lHandle == null || (oldValue = lHandle.getRef()) == null) {
            oldValue = this.rawMake(layout, oldType, pHandle);
        }
        this.idx_manager.maybeUnindex(this.getPersistentHandle(typeHandle), type, oldValue, pHandle);
        if (oldValue instanceof HGValueLink) {
            oldValue = ((HGValueLink)oldValue).getValue();
        }
        if (oldValue instanceof HGAtomType) {
            HGRandomAccessResult<HGPersistentHandle> rs = null;
            try {
                rs = this.indexByType.find(pHandle);
                if (rs.hasNext() && !(newValue instanceof HGAtomType)) {
                    throw new HGException("Attempt to replace a type atom " + pHandle + " with a non-empty instance set by an atom that is not a HyperGraph type.");
                }
                HGAtomType oldTypeValue = (HGAtomType)oldValue;
                HGAtomType newTypeValue = (HGAtomType)newValue;
                while (rs.hasNext()) {
                    this.morph((HGPersistentHandle)rs.next(), oldTypeValue, newTypeValue);
                }
            }
            finally {
                rs.close();
            }
        }
        if (!oldTypeHandle.equals(typeHandle)) {
            this.indexByType.removeEntry(this.getPersistentHandle(oldTypeHandle), pHandle);
            this.indexByType.addEntry(this.getPersistentHandle(typeHandle), pHandle);
        }
        TypeUtils.releaseValue(this, oldType, layout[1]);
        oldType.release(layout[1]);
        layout[1] = TypeUtils.storeValue(this, newValue, type);
        layout[0] = this.getPersistentHandle(typeHandle);
        this.indexByValue.removeEntry(oldValueHandle, pHandle);
        this.indexByValue.addEntry(layout[1], pHandle);
        if (atom instanceof HGLink) {
            int i;
            HGLink newLink = (HGLink)atom;
            newLayout = new HGPersistentHandle[newLink.getArity() + 2];
            HashSet<HGPersistentHandle> newTargets = new HashSet<HGPersistentHandle>();
            for (i = 0; i < newLink.getArity(); ++i) {
                HGPersistentHandle target;
                newLayout[2 + i] = target = this.getPersistentHandle(newLink.getTargetAt(i));
                newTargets.add(target);
            }
            for (i = 2; i < layout.length; ++i) {
                if (newTargets.remove(layout[i])) continue;
                this.removeFromIncidenceSet(layout[i], pHandle);
            }
            for (HGPersistentHandle newTarget : newTargets) {
                this.updateTargetIncidenceSet(newTarget, pHandle);
            }
        } else {
            newLayout = new HGPersistentHandle[2];
            for (int i = 2; i < layout.length; ++i) {
                this.removeFromIncidenceSet(layout[i], pHandle);
            }
        }
        newLayout[0] = layout[0];
        newLayout[1] = layout[1];
        this.store.store(pHandle, newLayout);
        this.idx_manager.maybeIndex(this.getPersistentHandle(typeHandle), type, pHandle, atom);
        if (atom instanceof HGGraphHolder) {
            ((HGGraphHolder)atom).setHyperGraph(this);
        }
        if (atom instanceof HGHandleHolder) {
            ((HGHandleHolder)atom).setAtomHandle(lHandle);
        }
        if (lHandle != null) {
            this.cache.atomRefresh(lHandle, atom, true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void morph(HGPersistentHandle instanceHandle, HGAtomType oldType, HGAtomType newType) {
        HGPersistentHandle[] layout = this.store.getLink(instanceHandle);
        Object oldInstance = this.rawMake(layout, oldType, instanceHandle);
        TypeUtils.releaseValue(this, oldType, layout[1]);
        oldType.release(layout[1]);
        this.indexByValue.removeEntry(layout[1], instanceHandle);
        layout[1] = TypeUtils.storeValue(this, oldInstance, newType);
        this.indexByValue.addEntry(layout[1], instanceHandle);
        Object newInstance = this.rawMake(layout, newType, instanceHandle);
        HGLiveHandle instanceLiveHandle = this.cache.get(instanceHandle);
        if (instanceLiveHandle != null && instanceLiveHandle.getRef() != null) {
            this.cache.atomRefresh(instanceLiveHandle, newInstance, true);
        }
        if (oldInstance instanceof HGAtomType) {
            HGRandomAccessResult<HGPersistentHandle> rs = null;
            try {
                rs = this.indexByType.find(instanceHandle);
                if (rs.hasNext() && !(newInstance instanceof HGAtomType)) {
                    throw new HGException("Cannot replace value of atom " + instanceHandle + " which was a type with something that is not a type");
                }
                oldType = (HGAtomType)oldInstance;
                newType = (HGAtomType)newInstance;
                while (rs.hasNext()) {
                    this.morph((HGPersistentHandle)rs.next(), oldType, newType);
                }
            }
            finally {
                if (rs != null) {
                    rs.close();
                }
            }
        }
    }

    private void initAtomManagement() {
        this.getTransactionManager().transact(new Callable<Object>(){

            @Override
            public Object call() {
                HyperGraph.this.statsHandle = (HGHandle)HGQuery.hg.findOne(HyperGraph.this, HGQuery.hg.type(HGStats.class));
                if (HyperGraph.this.statsHandle == null) {
                    HyperGraph.this.statsHandle = HyperGraph.this.add(HyperGraph.this.stats);
                } else {
                    HyperGraph.this.stats = (HGStats)HyperGraph.this.get(HyperGraph.this.statsHandle);
                }
                return null;
            }
        });
    }

    private void loadListeners() {
        HGSearchResult rs = null;
        try {
            rs = this.find(new AtomTypeCondition(this.typeSystem.getTypeHandle(HGListenerAtom.class)));
            while (rs.hasNext()) {
                HGListenerAtom listenerAtom = (HGListenerAtom)this.get((HGHandle)rs.next());
                try {
                    Class<?> eventClass = Class.forName(listenerAtom.getEventClassName());
                    Class<?> listenerClass = Class.forName(listenerAtom.getListenerClassName());
                    this.eventManager.addListener(eventClass, (HGListener)listenerClass.newInstance());
                }
                catch (Throwable t) {
                    this.logger.exception(t);
                }
            }
        }
        catch (Throwable t) {
            throw new HGException(t);
        }
        finally {
            if (rs != null) {
                rs.close();
            }
        }
    }

    private HGAtomAttrib getAtomAttributes(HGPersistentHandle handle) {
        return this.systemAttributesDB.findFirst(handle);
    }

    private void setAtomAttributes(HGPersistentHandle handle, HGAtomAttrib attribs) {
        this.systemAttributesDB.removeAllEntries(handle);
        this.systemAttributesDB.addEntry(handle, attribs);
    }

    private void removeAtomAttributes(HGPersistentHandle handle) {
        this.systemAttributesDB.removeAllEntries(handle);
    }

    protected void finalize() throws Throwable {
        try {
            this.close();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }
}

