/*
 * Decompiled with CFR 0.152.
 */
package org.hypergraphdb;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.Callable;
import org.hypergraphdb.HGGraphHolder;
import org.hypergraphdb.HGHandle;
import org.hypergraphdb.HGLink;
import org.hypergraphdb.HGSearchResult;
import org.hypergraphdb.HyperGraph;
import org.hypergraphdb.ResultSizeEstimation;
import org.hypergraphdb.atom.HGTypeStructuralInfo;
import org.hypergraphdb.indexing.ByPartIndexer;
import org.hypergraphdb.indexing.HGIndexer;
import org.hypergraphdb.query.And;
import org.hypergraphdb.query.AnyAtomCondition;
import org.hypergraphdb.query.ArityCondition;
import org.hypergraphdb.query.AtomPartCondition;
import org.hypergraphdb.query.AtomTypeCondition;
import org.hypergraphdb.query.AtomValueCondition;
import org.hypergraphdb.query.BFSCondition;
import org.hypergraphdb.query.ComparisonOperator;
import org.hypergraphdb.query.DFSCondition;
import org.hypergraphdb.query.DisconnectedPredicate;
import org.hypergraphdb.query.HGAtomPredicate;
import org.hypergraphdb.query.HGQueryCondition;
import org.hypergraphdb.query.IncidentCondition;
import org.hypergraphdb.query.LinkCondition;
import org.hypergraphdb.query.MapCondition;
import org.hypergraphdb.query.Not;
import org.hypergraphdb.query.Or;
import org.hypergraphdb.query.OrderedLinkCondition;
import org.hypergraphdb.query.SubsumedCondition;
import org.hypergraphdb.query.SubsumesCondition;
import org.hypergraphdb.query.TargetCondition;
import org.hypergraphdb.query.TypePlusCondition;
import org.hypergraphdb.query.cond2qry.ExpressionBasedQuery;
import org.hypergraphdb.query.impl.DerefMapping;
import org.hypergraphdb.query.impl.LinkProjectionMapping;
import org.hypergraphdb.type.HGAtomType;
import org.hypergraphdb.type.HGCompositeType;
import org.hypergraphdb.type.HGTypedValue;
import org.hypergraphdb.type.TypeUtils;
import org.hypergraphdb.util.CompositeMapping;
import org.hypergraphdb.util.HGUtils;
import org.hypergraphdb.util.Mapping;

public abstract class HGQuery<SearchResult>
implements HGGraphHolder {
    protected HyperGraph graph;
    public static final HGQuery<Object> NOP = new HGQuery<Object>(){

        @Override
        public HGSearchResult<Object> execute() {
            return HGSearchResult.EMPTY;
        }
    };

    public static <SearchResult> HGQuery<SearchResult> make(HyperGraph graph, HGQueryCondition condition) {
        return new ExpressionBasedQuery(graph, condition);
    }

    public HyperGraph getHyperGraph() {
        return this.graph;
    }

    @Override
    public void setHyperGraph(HyperGraph graph) {
        this.graph = graph;
    }

    public abstract HGSearchResult<SearchResult> execute();

    public static final class hg {
        static final HGHandle the_any_handle = new HGHandle(){};

        public static HGHandle assertAtom(HyperGraph graph, Object instance) {
            return hg.assertAtom(graph, instance, false);
        }

        public static HGHandle assertAtom(HyperGraph graph, Object instance, boolean ignoreValue) {
            if (instance == null) {
                throw new NullPointerException("Can't assert a null atom without specifying a type for it.");
            }
            HGHandle existing = graph.getHandle(instance);
            if (existing != null) {
                return existing;
            }
            HGHandle typeHandle = graph.getTypeSystem().getTypeHandle(instance.getClass());
            return hg.assertAtomImpl(graph, instance, typeHandle, ignoreValue);
        }

        public static HGHandle assertAtom(HyperGraph graph, Object instance, HGHandle type) {
            return hg.assertAtom(graph, instance, type, false);
        }

        public static HGHandle assertAtom(HyperGraph graph, Object instance, HGHandle type, boolean ignoreValue) {
            HGHandle existing;
            if (instance != null && (existing = graph.getHandle(instance)) != null && graph.getType(existing).equals(type)) {
                return existing;
            }
            return hg.assertAtomImpl(graph, instance, type, ignoreValue);
        }

        private static HGHandle assertAtomImpl(final HyperGraph graph, final Object instance, final HGHandle type, final boolean ignoreValue) {
            return graph.getTransactionManager().transact(new Callable<HGHandle>(){

                @Override
                public HGHandle call() {
                    HGHandle h;
                    And and = new And();
                    and.add(hg.type(type));
                    if (instance instanceof HGLink) {
                        HGTypeStructuralInfo typeMeta = graph.getTypeSystem().getTypeMetaData(type);
                        if (typeMeta != null && !typeMeta.isOrdered()) {
                            and.add(hg.link((HGLink)instance));
                        } else {
                            and.add(hg.orderedLink(HGUtils.toHandleArray((HGLink)instance)));
                        }
                    }
                    List<HGIndexer> indexers = graph.getIndexManager().getIndexersForType(type);
                    boolean skipValue = false;
                    if (indexers != null) {
                        HashSet<String> dimensions = new HashSet<String>();
                        for (HGIndexer idx : indexers) {
                            if (!(idx instanceof ByPartIndexer)) continue;
                            ByPartIndexer byPart = (ByPartIndexer)idx;
                            HGTypedValue prop = TypeUtils.project(graph, type, instance, byPart.getDimensionPath(), true);
                            and.add(new AtomPartCondition(byPart.getDimensionPath(), prop.getValue()));
                            if (byPart.getDimensionPath().length != 1) continue;
                            dimensions.add(byPart.getDimensionPath()[0]);
                        }
                        HGAtomType T = (HGAtomType)graph.get(type);
                        if (!dimensions.isEmpty() && T instanceof HGCompositeType) {
                            Iterator<String> dimIter = ((HGCompositeType)T).getDimensionNames();
                            while (dimIter.hasNext()) {
                                dimensions.remove(dimIter.next());
                            }
                            if (dimensions.isEmpty()) {
                                skipValue = true;
                            }
                        }
                    }
                    if (!ignoreValue && !skipValue) {
                        and.add(hg.eq(instance));
                    }
                    return (h = (HGHandle)hg.findOne(graph, and)) == null ? graph.add(instance, type) : h;
                }
            });
        }

        public static HGQueryCondition guessUniquenessCondition(HyperGraph graph, Object instance) {
            List<HGIndexer> indexers;
            if (instance == null) {
                return null;
            }
            HGHandle type = graph.getTypeSystem().getTypeHandle(instance.getClass());
            And and = new And();
            and.add(hg.type(type));
            and.add(hg.eq(instance));
            if (instance instanceof HGLink) {
                and.add(hg.orderedLink(HGUtils.toHandleArray((HGLink)instance)));
            }
            if ((indexers = graph.getIndexManager().getIndexersForType(type)) != null) {
                for (HGIndexer idx : indexers) {
                    if (!(idx instanceof ByPartIndexer)) continue;
                    ByPartIndexer byPart = (ByPartIndexer)idx;
                    HGTypedValue prop = TypeUtils.project(graph, type, instance, byPart.getDimensionPath(), true);
                    and.add(new AtomPartCondition(byPart.getDimensionPath(), prop));
                }
            }
            return and;
        }

        public static HGHandle addUnique(final HyperGraph graph, final Object instance, final HGQueryCondition condition) {
            return graph.getTransactionManager().transact(new Callable<HGHandle>(){

                @Override
                public HGHandle call() {
                    HGHandle h = (HGHandle)hg.findOne(graph, condition);
                    return h == null ? graph.add(instance) : h;
                }
            });
        }

        public static HGHandle addUnique(final HyperGraph graph, final Object instance, final HGHandle typeHandle, final HGQueryCondition condition) {
            return graph.getTransactionManager().transact(new Callable<HGHandle>(){

                @Override
                public HGHandle call() {
                    HGHandle h = (HGHandle)hg.findOne(graph, hg.and(hg.type(typeHandle), condition));
                    return h == null ? graph.add(instance, typeHandle) : h;
                }
            });
        }

        public static HGHandle addUnique(HyperGraph graph, Object instance, Class javaClass, HGQueryCondition condition) {
            return hg.addUnique(graph, instance, graph.getTypeSystem().getTypeHandle(javaClass), condition);
        }

        public static AtomTypeCondition type(HGHandle typeHandle) {
            return new AtomTypeCondition(typeHandle);
        }

        public static AtomTypeCondition type(Class<?> clazz) {
            return new AtomTypeCondition(clazz);
        }

        public static TypePlusCondition typePlus(HGHandle h) {
            return new TypePlusCondition(h);
        }

        public static TypePlusCondition typePlus(Class<?> clazz) {
            return new TypePlusCondition(clazz);
        }

        public static SubsumesCondition subsumes(HGHandle specific) {
            return new SubsumesCondition(specific);
        }

        public static SubsumedCondition subsumed(HGHandle general) {
            return new SubsumedCondition(general);
        }

        public static And and(HGQueryCondition ... clauses) {
            And and = new And();
            for (HGQueryCondition x : clauses) {
                and.add(x);
            }
            return and;
        }

        public static Or or(HGQueryCondition ... clauses) {
            Or or = new Or();
            for (HGQueryCondition x : clauses) {
                or.add(x);
            }
            return or;
        }

        public static Not not(HGAtomPredicate predicate) {
            return new Not(predicate);
        }

        public static TargetCondition target(HGHandle linkHandle) {
            return new TargetCondition(linkHandle);
        }

        public static IncidentCondition incident(HGHandle atomHandle) {
            return new IncidentCondition(atomHandle);
        }

        public static LinkCondition link(HGLink link) {
            return new LinkCondition(link);
        }

        public static LinkCondition link(HGHandle ... h) {
            return new LinkCondition(h);
        }

        public static LinkCondition link(Collection<HGHandle> C) {
            return new LinkCondition(C);
        }

        public static OrderedLinkCondition orderedLink(HGHandle ... h) {
            return new OrderedLinkCondition(h);
        }

        public static OrderedLinkCondition orderedLink(List<HGHandle> L) {
            return new OrderedLinkCondition(L);
        }

        public static ArityCondition arity(int i) {
            return new ArityCondition(i);
        }

        public static DisconnectedPredicate disconnected() {
            return new DisconnectedPredicate();
        }

        public static AtomValueCondition value(Object value, ComparisonOperator op) {
            return new AtomValueCondition(value, op);
        }

        public static AtomValueCondition eq(Object x) {
            return hg.value(x, ComparisonOperator.EQ);
        }

        public static AtomValueCondition lt(Object x) {
            return hg.value(x, ComparisonOperator.LT);
        }

        public static AtomValueCondition gt(Object x) {
            return hg.value(x, ComparisonOperator.GT);
        }

        public static AtomValueCondition lte(Object x) {
            return hg.value(x, ComparisonOperator.LTE);
        }

        public static AtomValueCondition gte(Object x) {
            return hg.value(x, ComparisonOperator.GTE);
        }

        public static AtomPartCondition part(String path, Object value, ComparisonOperator op) {
            return new AtomPartCondition(path.split("\\."), value, op);
        }

        public static AtomPartCondition eq(String path, Object x) {
            return hg.part(path, x, ComparisonOperator.EQ);
        }

        public static AtomPartCondition lt(String path, Object x) {
            return hg.part(path, x, ComparisonOperator.LT);
        }

        public static AtomPartCondition gt(String path, Object x) {
            return hg.part(path, x, ComparisonOperator.GT);
        }

        public static AtomPartCondition lte(String path, Object x) {
            return hg.part(path, x, ComparisonOperator.LTE);
        }

        public static AtomPartCondition gte(String path, Object x) {
            return hg.part(path, x, ComparisonOperator.GTE);
        }

        public static HGQueryCondition apply(Mapping<?, ?> m, HGQueryCondition c) {
            return new MapCondition(c, m);
        }

        public static Mapping<HGLink, HGHandle> linkProjection(int targetPosition) {
            return new LinkProjectionMapping(targetPosition);
        }

        public static Mapping<HGHandle, Object> deref(HyperGraph graph) {
            return new DerefMapping(graph);
        }

        public static Mapping<HGHandle, HGHandle> targetAt(HyperGraph graph, int targetPosition) {
            return new CompositeMapping<HGHandle, HGHandle>(hg.deref(graph), hg.linkProjection(targetPosition));
        }

        public static HGQueryCondition all() {
            return new AnyAtomCondition();
        }

        public static BFSCondition bfs(HGHandle start) {
            return new BFSCondition(start);
        }

        public static BFSCondition bfs(HGHandle start, HGAtomPredicate lp, HGAtomPredicate sp) {
            BFSCondition c = new BFSCondition(start);
            c.setLinkPredicate(lp);
            c.setSiblingPredicate(sp);
            return c;
        }

        public static BFSCondition bfs(HGHandle start, HGAtomPredicate lp, HGAtomPredicate sp, boolean returnPreceding, boolean returnSucceeding) {
            BFSCondition c = new BFSCondition(start);
            c.setLinkPredicate(lp);
            c.setSiblingPredicate(sp);
            c.setReturnPreceeding(returnPreceding);
            c.setReturnSucceeding(returnSucceeding);
            return c;
        }

        public static DFSCondition dfs(HGHandle start) {
            return new DFSCondition(start);
        }

        public static DFSCondition dfs(HGHandle start, HGAtomPredicate lp, HGAtomPredicate sp) {
            DFSCondition c = new DFSCondition(start);
            c.setLinkPredicate(lp);
            c.setSiblingPredicate(sp);
            return c;
        }

        public static DFSCondition dfs(HGHandle start, HGAtomPredicate lp, HGAtomPredicate sp, boolean returnPreceeding, boolean returnSucceeding) {
            DFSCondition c = new DFSCondition(start);
            c.setLinkPredicate(lp);
            c.setSiblingPredicate(sp);
            c.setReturnPreceeding(returnPreceeding);
            c.setReturnSucceeding(returnSucceeding);
            return c;
        }

        public static HGHandle anyHandle() {
            return the_any_handle;
        }

        public static long count(final HyperGraph graph, final HGQueryCondition cond) {
            return graph.getTransactionManager().ensureTransaction(new Callable<Long>(){

                @Override
                public Long call() {
                    ResultSizeEstimation.Counter counter = ResultSizeEstimation.countersMap.get(cond.getClass());
                    if (counter == null) {
                        return ResultSizeEstimation.countResultSet(graph, cond);
                    }
                    return counter.count(graph, cond);
                }
            });
        }

        public static long count(final HGQuery<?> query) {
            return query.getHyperGraph().getTransactionManager().ensureTransaction(new Callable<Long>(){

                @Override
                public Long call() {
                    return ResultSizeEstimation.countResultSet(query);
                }
            });
        }

        public static <T> T getOne(HyperGraph graph, HGQueryCondition condition) {
            HGHandle h = (HGHandle)hg.findOne(graph, condition);
            return h == null ? null : (T)graph.get(h);
        }

        public static <T> T findOne(final HyperGraph graph, final HGQueryCondition condition) {
            return (T)graph.getTransactionManager().ensureTransaction(new Callable<T>(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public T call() {
                    HGSearchResult rs = null;
                    try {
                        rs = graph.find(condition);
                        if (rs.hasNext()) {
                            Object e = rs.next();
                            return e;
                        }
                        Object t = null;
                        return t;
                    }
                    finally {
                        if (rs != null) {
                            rs.close();
                        }
                    }
                }
            });
        }

        public static <T> List<T> findAll(HyperGraph graph, HGQueryCondition condition) {
            final ArrayList result = new ArrayList();
            HGQuery query = HGQuery.make(graph, condition);
            HGUtils.queryBatchProcess(query, new Mapping<T, Boolean>(){

                @Override
                public Boolean eval(T x) {
                    result.add(x);
                    return Boolean.TRUE;
                }
            }, 500, null, 1L);
            return result;
        }

        public static <T> List<T> getAll(final HyperGraph graph, HGQueryCondition condition) {
            final ArrayList result = new ArrayList();
            HGQuery query = HGQuery.make(graph, condition);
            HGUtils.queryBatchProcess(query, new Mapping<HGHandle, Boolean>(){

                @Override
                public Boolean eval(HGHandle x) {
                    result.add(graph.get(x));
                    return Boolean.TRUE;
                }
            }, 500, null, 1L);
            return result;
        }

        public static <T> List<T> findAll(HGQuery<T> query) {
            final ArrayList result = new ArrayList();
            HGUtils.queryBatchProcess(query, new Mapping<T, Boolean>(){

                @Override
                public Boolean eval(T x) {
                    result.add(x);
                    return Boolean.TRUE;
                }
            }, 500, null, 1L);
            return result;
        }
    }
}

