/*
 * Decompiled with CFR 0.152.
 */
package org.hypergraphdb;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.hypergraphdb.HGHandle;
import org.hypergraphdb.HGIndex;
import org.hypergraphdb.HGPersistentHandle;
import org.hypergraphdb.HGQuery;
import org.hypergraphdb.HyperGraph;
import org.hypergraphdb.indexing.HGIndexer;
import org.hypergraphdb.indexing.HGValueIndexer;
import org.hypergraphdb.maintenance.ApplyNewIndexer;
import org.hypergraphdb.storage.BAtoHandle;
import org.hypergraphdb.storage.ByteArrayConverter;
import org.hypergraphdb.type.HGAtomType;

public class HGIndexManager {
    private HyperGraph graph;
    private HashMap<HGIndexer, HGIndex<? extends Object, ? extends Object>> indices = new HashMap();
    private HashMap<HGHandle, List<HGIndexer>> indexers = new HashMap();

    private String getIndexName(HGIndexer indexer) {
        return this.graph.getPersistentHandle(indexer.getType()) + "_" + this.graph.getPersistentHandle(this.graph.getHandle(indexer));
    }

    private HGIndexer toAtomIndexer(HGIndexer indexer) {
        List<HGIndexer> L = this.indexers.get(indexer.getType());
        int i = L.indexOf(indexer);
        return i >= 0 ? L.get(i) : null;
    }

    private <KeyType, ValueType> HGIndex<KeyType, ValueType> getOrCreateIndex(HGIndexer indexer) {
        HGIndex<Object, Object> result = this.indices.get(indexer);
        if (result == null) {
            String name = this.getIndexName(indexer);
            ByteArrayConverter<HGPersistentHandle> converter = null;
            converter = indexer instanceof HGValueIndexer ? ((HGValueIndexer)indexer).getValueConverter(this.graph) : BAtoHandle.getInstance(this.graph.getHandleFactory());
            result = this.graph.getStore().getIndex(name, indexer.getConverter(this.graph), converter, indexer.getComparator(this.graph), true);
            this.indices.put(indexer, result);
        }
        return result;
    }

    private void removeFromSubtypes(HGIndexer indexer) {
        for (HGHandle currentType : HGQuery.hg.typePlus(indexer.getType()).getSubTypes(this.graph)) {
            List<HGIndexer> forType;
            if (currentType.equals(indexer.getType()) || (forType = this.indexers.get(currentType)) == null) continue;
            forType.remove(indexer);
            if (!forType.isEmpty()) continue;
            this.indexers.remove(currentType);
        }
    }

    public void deleteIndex(HGIndexer indexer) {
        if ((indexer = this.toAtomIndexer(indexer)) == null) {
            return;
        }
        this.indices.remove(indexer);
        String name = this.getIndexName(indexer);
        this.graph.getStore().removeIndex(name);
    }

    public HGIndexManager(HyperGraph graph) {
        this.graph = graph;
    }

    void loadIndexers() {
        HGHandle indexerBaseType = this.graph.getTypeSystem().getTypeHandle(HGIndexer.class);
        List<HGHandle> indexerTypes = HGQuery.hg.findAll(this.graph, HGQuery.hg.subsumed(indexerBaseType));
        for (HGHandle indexerType : indexerTypes) {
            List<HGIndexer> indexerAtoms = HGQuery.hg.getAll(this.graph, HGQuery.hg.type(indexerType));
            for (HGIndexer indexer : indexerAtoms) {
                for (HGHandle currentType : HGQuery.hg.typePlus(indexer.getType()).getSubTypes(this.graph)) {
                    List<HGIndexer> forType = this.indexers.get(currentType);
                    if (forType == null) {
                        forType = new ArrayList<HGIndexer>();
                        this.indexers.put(currentType, forType);
                    }
                    forType.add(indexer);
                }
            }
        }
    }

    public void close() {
    }

    public boolean unregister(HGIndexer indexer) {
        this.removeFromSubtypes(indexer);
        List<HGIndexer> forType = this.indexers.get(indexer.getType());
        if (forType == null) {
            return false;
        }
        int i = forType.indexOf(indexer);
        if (i < 0) {
            return false;
        }
        HGHandle hIndexer = this.graph.getHandle(forType.get(i));
        HGHandle maintenanceOp = (HGHandle)HGQuery.hg.findOne(this.graph, HGQuery.hg.and(HGQuery.hg.type(ApplyNewIndexer.class), HGQuery.hg.eq("hindexer", hIndexer)));
        if (maintenanceOp != null) {
            this.graph.remove(maintenanceOp);
        }
        this.deleteIndex(forType.get(i));
        this.graph.remove(hIndexer);
        forType.remove(i);
        if (forType.isEmpty()) {
            this.indexers.remove(indexer.getType());
        }
        return true;
    }

    public void unregisterAll(HGHandle typeHandle) {
        List<HGIndexer> forType = this.indexers.get(typeHandle);
        if (forType != null) {
            Iterator<HGIndexer> i = forType.iterator();
            while (i.hasNext()) {
                HGIndexer indexer = i.next();
                this.removeFromSubtypes(indexer);
                this.deleteIndex(indexer);
                this.graph.remove(this.graph.getHandle(indexer));
                i.remove();
            }
            if (forType.isEmpty()) {
                this.indexers.remove(typeHandle);
            }
        }
    }

    public boolean isRegistered(HGIndexer indexer) {
        List<HGIndexer> forType = this.indexers.get(indexer.getType());
        return forType == null ? false : forType.contains(indexer);
    }

    public <KeyType, ValueType> HGIndex<KeyType, ValueType> register(HGIndexer indexer) {
        boolean createNewIndex = false;
        boolean activate = HGQuery.hg.count(this.graph, HGQuery.hg.typePlus(indexer.getType())) == 0L;
        for (HGHandle currentType : HGQuery.hg.typePlus(indexer.getType()).getSubTypes(this.graph)) {
            List<HGIndexer> forType = this.indexers.get(currentType);
            if (forType == null) {
                forType = new ArrayList<HGIndexer>();
                this.indexers.put(currentType, forType);
            }
            if (forType.contains(indexer)) continue;
            if (currentType.equals(indexer.getType())) {
                createNewIndex = true;
            }
            if (!activate) continue;
            forType.add(indexer);
        }
        if (createNewIndex) {
            HGHandle hIndexer = this.graph.add(indexer);
            HGIndex<KeyType, ValueType> idx = this.getOrCreateIndex(indexer);
            if (!activate) {
                this.graph.add(new ApplyNewIndexer(hIndexer));
            }
            return idx;
        }
        return this.getIndex(indexer);
    }

    void registerSubtype(HGHandle superType, HGHandle subType) {
        List<HGIndexer> forSubType;
        List<HGIndexer> forSuperType = this.indexers.get(superType);
        if (forSuperType == null) {
            return;
        }
        if (forSuperType.isEmpty()) {
            this.indexers.remove(forSuperType);
        }
        if ((forSubType = this.indexers.get(subType)) == null) {
            forSubType = new ArrayList<HGIndexer>();
            this.indexers.put(subType, forSubType);
        }
        for (HGIndexer idx : forSuperType) {
            if (forSubType.contains(idx)) continue;
            forSubType.add(idx);
        }
    }

    public <KeyType, ValueType> HGIndex<KeyType, ValueType> getIndex(HGIndexer indexer) {
        int i;
        List<HGIndexer> L;
        HGIndex<Object, Object> result = this.indices.get(indexer);
        if (result == null && (L = this.indexers.get(indexer.getType())) != null && (i = L.indexOf(indexer)) >= 0) {
            result = this.getOrCreateIndex(L.get(i));
        }
        return result;
    }

    public List<HGIndexer> getIndexersForType(HGHandle type) {
        return this.indexers.get(type);
    }

    public HGIndex<HGPersistentHandle, HGPersistentHandle> getIndexByType() {
        return this.graph.indexByType;
    }

    public HGIndex<HGPersistentHandle, HGPersistentHandle> getIndexByValue() {
        return this.graph.indexByValue;
    }

    public void maybeIndex(HGPersistentHandle typeHandle, HGAtomType type, HGPersistentHandle atomHandle, Object atom) {
        List<HGIndexer> indList = this.indexers.get(typeHandle);
        if (indList == null) {
            return;
        }
        for (HGIndexer indexer : indList) {
            HGIndex idx = this.getOrCreateIndex(indexer);
            indexer.index(this.graph, atomHandle, atom, idx);
        }
    }

    public void maybeUnindex(HGPersistentHandle typeHandle, HGAtomType type, Object atom, HGPersistentHandle atomHandle) {
        List<HGIndexer> indList = this.indexers.get(typeHandle);
        if (indList == null) {
            return;
        }
        for (HGIndexer indexer : indList) {
            HGIndex idx = this.getOrCreateIndex(indexer);
            indexer.unindex(this.graph, atomHandle, atom, idx);
        }
    }
}

