/*
 * Decompiled with CFR 0.152.
 */
package org.hypergraphdb;

import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.hypergraphdb.HGConfiguration;
import org.hypergraphdb.HyperGraph;
import org.hypergraphdb.util.MemoryWarningSystem;

public class HGEnvironment {
    private static Map<String, HyperGraph> dbs = new HashMap<String, HyperGraph>();
    private static Map<String, HGConfiguration> configs = new HashMap<String, HGConfiguration>();
    private static MemoryWarningSystem memWarning = null;
    private static Thread shutdownHook = new Thread(new OnShutdown());

    static synchronized void set(String location, HyperGraph graph) {
        dbs.put(HGEnvironment.normalize(location), graph);
    }

    static synchronized void remove(String location) {
        dbs.remove(HGEnvironment.normalize(location));
    }

    static String normalize(String location) {
        File f = new File(location);
        try {
            return f.getCanonicalPath();
        }
        catch (IOException ex) {
            ex.printStackTrace(System.err);
            return f.getAbsolutePath();
        }
    }

    public static synchronized MemoryWarningSystem getMemoryWarningSystem() {
        if (memWarning == null) {
            memWarning = new MemoryWarningSystem();
            memWarning.setPercentageUsageThreshold(0.7);
        }
        return memWarning;
    }

    public static synchronized HyperGraph get(String location) {
        HyperGraph hg2 = dbs.get(location = HGEnvironment.normalize(location));
        if (hg2 == null) {
            hg2 = new HyperGraph();
            hg2.setConfig(HGEnvironment.getConfiguration(location));
            hg2.open(location);
            dbs.put(location, hg2);
        } else if (!hg2.isOpen()) {
            if (configs.containsKey(location)) {
                hg2.setConfig(configs.get(location));
            }
            hg2.open(location);
        }
        return hg2;
    }

    public static synchronized HyperGraph get(String location, HGConfiguration config) {
        location = HGEnvironment.normalize(location);
        configs.put(location, config);
        return HGEnvironment.get(location);
    }

    public static synchronized HyperGraph getExistingOnly(String location) {
        HyperGraph hg2 = dbs.get(location = HGEnvironment.normalize(location));
        if (hg2 == null) {
            if (HGEnvironment.exists(location)) {
                hg2 = new HyperGraph(location);
            }
        } else if (!hg2.isOpen()) {
            if (configs.containsKey(location)) {
                hg2.setConfig(configs.get(location));
            }
            hg2.open(location);
        }
        return hg2;
    }

    public static synchronized boolean exists(String location) {
        return new File(location, "hgstore_idx_HGATOMTYPE").exists();
    }

    public static synchronized boolean isOpen(String location) {
        return dbs.containsKey(location);
    }

    public static synchronized void configure(String location, HGConfiguration config) {
        configs.put(location, config);
    }

    public static synchronized HGConfiguration getConfiguration(String location) {
        HGConfiguration conf = configs.get(location = HGEnvironment.normalize(location));
        if (conf == null) {
            HyperGraph hg2 = dbs.get(location);
            conf = hg2 != null ? hg2.getConfig() : new HGConfiguration();
            configs.put(location, conf);
        }
        return conf;
    }

    public static synchronized void closeAll() {
        for (HyperGraph graph : dbs.values()) {
            if (!graph.isOpen()) continue;
            try {
                graph.close();
            }
            catch (Throwable t) {
                System.err.println("Problem closing HyperGraphDB instance at " + graph.getLocation() + ", stack trace follows...");
                t.printStackTrace(System.err);
            }
        }
        dbs.clear();
    }

    public static void disableShutdownHook() {
        Runtime.getRuntime().removeShutdownHook(shutdownHook);
    }

    static {
        Runtime.getRuntime().addShutdownHook(shutdownHook);
    }

    private static class OnShutdown
    implements Runnable {
        private OnShutdown() {
        }

        @Override
        public void run() {
            HGEnvironment.closeAll();
        }
    }
}

