/*
 * Decompiled with CFR 0.152.
 */
package org.hypergraphdb;

import org.hypergraphdb.storage.ByteArrayConverter;

public final class HGAtomAttrib {
    byte flags = 0;
    long retrievalCount;
    long lastAccessTime;
    static final Converter baConverter = new Converter();

    public byte getFlags() {
        return this.flags;
    }

    public void setFlags(byte flags) {
        this.flags = flags;
    }

    public long getRetrievalCount() {
        return this.retrievalCount;
    }

    public void setRetrievalCount(long retrievalCount) {
        this.retrievalCount = retrievalCount;
    }

    public long getLastAccessTime() {
        return this.lastAccessTime;
    }

    public void setLastAccessTime(long lastAccessTime) {
        this.lastAccessTime = lastAccessTime;
    }

    static class Converter
    implements ByteArrayConverter<HGAtomAttrib> {
        Converter() {
        }

        static void putLong(byte[] dest, int offset, long value) {
            dest[0 + offset] = (byte)(value >>> 56);
            dest[1 + offset] = (byte)(value >>> 48);
            dest[2 + offset] = (byte)(value >>> 40);
            dest[3 + offset] = (byte)(value >>> 32);
            dest[4 + offset] = (byte)(value >>> 24);
            dest[5 + offset] = (byte)(value >>> 16);
            dest[6 + offset] = (byte)(value >>> 8);
            dest[7 + offset] = (byte)(value >>> 0);
        }

        static long getLong(byte[] src, int offset) {
            return ((long)src[offset] << 56) + ((long)(src[offset + 1] & 0xFF) << 48) + ((long)(src[offset + 2] & 0xFF) << 40) + ((long)(src[offset + 3] & 0xFF) << 32) + ((long)(src[offset + 4] & 0xFF) << 24) + (long)((src[offset + 5] & 0xFF) << 16) + (long)((src[offset + 6] & 0xFF) << 8) + (long)((src[offset + 7] & 0xFF) << 0);
        }

        @Override
        public HGAtomAttrib fromByteArray(byte[] byteArray) {
            HGAtomAttrib result = new HGAtomAttrib();
            result.flags = byteArray[0];
            result.retrievalCount = Converter.getLong(byteArray, 1);
            result.lastAccessTime = Converter.getLong(byteArray, 9);
            return result;
        }

        @Override
        public byte[] toByteArray(HGAtomAttrib object) {
            byte[] result = new byte[17];
            HGAtomAttrib attribs = object;
            result[0] = attribs.flags;
            Converter.putLong(result, 1, attribs.retrievalCount);
            Converter.putLong(result, 9, attribs.lastAccessTime);
            return result;
        }
    }
}

