/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.util.keyrange;

import com.sleepycat.db.DatabaseEntry;
import com.sleepycat.util.keyrange.KeyRangeException;
import java.util.Comparator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class KeyRange {
    public static final byte[] ZERO_LENGTH_BYTE_ARRAY = new byte[0];
    Comparator<byte[]> comparator;
    DatabaseEntry beginKey;
    DatabaseEntry endKey;
    boolean singleKey;
    boolean beginInclusive;
    boolean endInclusive;

    public KeyRange(Comparator<byte[]> comparator) {
        this.comparator = comparator;
    }

    public KeyRange subRange(DatabaseEntry databaseEntry) throws KeyRangeException {
        if (!this.check(databaseEntry)) {
            throw new KeyRangeException("singleKey out of range");
        }
        KeyRange keyRange = new KeyRange(this.comparator);
        keyRange.beginKey = databaseEntry;
        keyRange.endKey = databaseEntry;
        keyRange.beginInclusive = true;
        keyRange.endInclusive = true;
        keyRange.singleKey = true;
        return keyRange;
    }

    public KeyRange subRange(DatabaseEntry databaseEntry, boolean bl, DatabaseEntry databaseEntry2, boolean bl2) throws KeyRangeException {
        if (databaseEntry == null) {
            databaseEntry = this.beginKey;
            bl = this.beginInclusive;
        } else if (!this.check(databaseEntry, bl)) {
            throw new KeyRangeException("beginKey out of range");
        }
        if (databaseEntry2 == null) {
            databaseEntry2 = this.endKey;
            bl2 = this.endInclusive;
        } else if (!this.check(databaseEntry2, bl2)) {
            throw new KeyRangeException("endKey out of range");
        }
        KeyRange keyRange = new KeyRange(this.comparator);
        keyRange.beginKey = databaseEntry;
        keyRange.endKey = databaseEntry2;
        keyRange.beginInclusive = bl;
        keyRange.endInclusive = bl2;
        return keyRange;
    }

    public final boolean isSingleKey() {
        return this.singleKey;
    }

    public final DatabaseEntry getSingleKey() {
        return this.singleKey ? this.beginKey : null;
    }

    public final boolean hasBound() {
        return this.endKey != null || this.beginKey != null;
    }

    public String toString() {
        return "[KeyRange " + this.beginKey + ' ' + this.beginInclusive + this.endKey + ' ' + this.endInclusive + (this.singleKey ? " single" : "");
    }

    public boolean check(DatabaseEntry databaseEntry) {
        if (this.singleKey) {
            return this.compare(databaseEntry, this.beginKey) == 0;
        }
        return this.checkBegin(databaseEntry, true) && this.checkEnd(databaseEntry, true);
    }

    public boolean check(DatabaseEntry databaseEntry, boolean bl) {
        if (this.singleKey) {
            return this.compare(databaseEntry, this.beginKey) == 0;
        }
        return this.checkBegin(databaseEntry, bl) && this.checkEnd(databaseEntry, bl);
    }

    public boolean checkBegin(DatabaseEntry databaseEntry, boolean bl) {
        if (this.beginKey == null) {
            return true;
        }
        if (!this.beginInclusive && bl) {
            return this.compare(databaseEntry, this.beginKey) > 0;
        }
        return this.compare(databaseEntry, this.beginKey) >= 0;
    }

    public boolean checkEnd(DatabaseEntry databaseEntry, boolean bl) {
        if (this.endKey == null) {
            return true;
        }
        if (!this.endInclusive && bl) {
            return this.compare(databaseEntry, this.endKey) < 0;
        }
        return this.compare(databaseEntry, this.endKey) <= 0;
    }

    public int compare(DatabaseEntry databaseEntry, DatabaseEntry databaseEntry2) {
        if (this.comparator != null) {
            return this.comparator.compare(KeyRange.getByteArray(databaseEntry), KeyRange.getByteArray(databaseEntry2));
        }
        return KeyRange.compareBytes(databaseEntry.getData(), databaseEntry.getOffset(), databaseEntry.getSize(), databaseEntry2.getData(), databaseEntry2.getOffset(), databaseEntry2.getSize());
    }

    public static byte[] copyBytes(byte[] byArray) {
        byte[] byArray2 = new byte[byArray.length];
        System.arraycopy(byArray, 0, byArray2, 0, byArray2.length);
        return byArray2;
    }

    public static int compareBytes(byte[] byArray, int n, int n2, byte[] byArray2, int n3, int n4) {
        for (int i = 0; i < n2 && i < n4; ++i) {
            int n5 = 0xFF & byArray[n + i];
            int n6 = 0xFF & byArray2[n3 + i];
            if (n5 < n6) {
                return -1;
            }
            if (n5 <= n6) continue;
            return 1;
        }
        if (n2 < n4) {
            return -1;
        }
        if (n2 > n4) {
            return 1;
        }
        return 0;
    }

    public static boolean equalBytes(byte[] byArray, int n, int n2, byte[] byArray2, int n3, int n4) {
        if (n2 != n4) {
            return false;
        }
        for (int i = 0; i < n2; ++i) {
            if (byArray[i + n] == byArray2[i + n3]) continue;
            return false;
        }
        return true;
    }

    public static DatabaseEntry copy(DatabaseEntry databaseEntry) {
        return new DatabaseEntry(KeyRange.getByteArray(databaseEntry));
    }

    public static void copy(DatabaseEntry databaseEntry, DatabaseEntry databaseEntry2) {
        databaseEntry2.setData(KeyRange.getByteArray(databaseEntry));
        databaseEntry2.setOffset(0);
    }

    public static byte[] getByteArray(DatabaseEntry databaseEntry) {
        return KeyRange.getByteArrayInternal(databaseEntry, Integer.MAX_VALUE);
    }

    public static byte[] getByteArray(DatabaseEntry databaseEntry, int n) {
        return KeyRange.getByteArrayInternal(databaseEntry, n);
    }

    private static byte[] getByteArrayInternal(DatabaseEntry databaseEntry, int n) {
        byte[] byArray;
        byte[] byArray2 = databaseEntry.getData();
        if (byArray2 == null) {
            return null;
        }
        int n2 = Math.min(databaseEntry.getSize(), n);
        if (n2 == 0) {
            byArray = ZERO_LENGTH_BYTE_ARRAY;
        } else {
            byArray = new byte[n2];
            System.arraycopy(byArray2, databaseEntry.getOffset(), byArray, 0, n2);
        }
        return byArray;
    }

    public static boolean equalBytes(DatabaseEntry databaseEntry, DatabaseEntry databaseEntry2) {
        if (databaseEntry == null && databaseEntry2 == null) {
            return true;
        }
        if (databaseEntry == null || databaseEntry2 == null) {
            return false;
        }
        byte[] byArray = databaseEntry.getData();
        byte[] byArray2 = databaseEntry2.getData();
        int n = databaseEntry.getSize();
        int n2 = databaseEntry2.getSize();
        int n3 = databaseEntry.getOffset();
        int n4 = databaseEntry2.getOffset();
        if (byArray == null && byArray2 == null) {
            return true;
        }
        if (byArray == null || byArray2 == null) {
            return false;
        }
        if (n != n2) {
            return false;
        }
        for (int i = 0; i < n; ++i) {
            if (byArray[n3 + i] == byArray2[n4 + i]) continue;
            return false;
        }
        return true;
    }

    public static String toString(DatabaseEntry databaseEntry) {
        int n = databaseEntry.getOffset() + databaseEntry.getSize();
        StringBuffer stringBuffer = new StringBuffer(n * 2);
        byte[] byArray = databaseEntry.getData();
        for (int i = databaseEntry.getOffset(); i < n; ++i) {
            String string = Integer.toHexString(byArray[i]);
            if (string.length() < 2) {
                stringBuffer.append('0');
            }
            stringBuffer.append(string);
        }
        return stringBuffer.toString();
    }
}

