/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.persist.impl;

import com.sleepycat.bind.tuple.TupleBase;
import com.sleepycat.db.DatabaseEntry;
import com.sleepycat.db.DatabaseException;
import com.sleepycat.db.Sequence;
import com.sleepycat.persist.impl.Catalog;
import com.sleepycat.persist.impl.Format;
import com.sleepycat.persist.impl.PersistEntityBinding;
import com.sleepycat.persist.impl.PersistKeyBinding;
import com.sleepycat.persist.impl.RecordInput;
import com.sleepycat.persist.impl.RecordOutput;

public class PersistKeyAssigner {
    private Catalog catalog;
    private Format keyFieldFormat;
    private Format entityFormat;
    private boolean rawAccess;
    private Sequence sequence;

    PersistKeyAssigner(PersistKeyBinding persistKeyBinding, PersistEntityBinding persistEntityBinding, Sequence sequence) {
        this.catalog = persistKeyBinding.catalog;
        this.keyFieldFormat = persistKeyBinding.keyFormat.getSequenceKeyFormat();
        this.entityFormat = persistEntityBinding.entityFormat;
        this.rawAccess = persistEntityBinding.rawAccess;
        this.sequence = sequence;
    }

    public boolean assignPrimaryKey(Object object, DatabaseEntry databaseEntry) throws DatabaseException {
        if (this.entityFormat.isPriKeyNullOrZero(object, this.rawAccess)) {
            Long l = this.sequence.get(null, 1);
            RecordOutput recordOutput = new RecordOutput(this.catalog, this.rawAccess);
            this.keyFieldFormat.writeObject(l, recordOutput, this.rawAccess);
            TupleBase.outputToEntry(recordOutput, databaseEntry);
            RecordInput recordInput = new RecordInput(this.catalog, this.rawAccess, null, 0, databaseEntry.getData(), databaseEntry.getOffset(), databaseEntry.getSize());
            this.entityFormat.getReader().readPriKey(object, recordInput, this.rawAccess);
            return true;
        }
        return false;
    }
}

