/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.db.internal;

import com.sleepycat.db.CacheFileStats;
import com.sleepycat.db.CacheStats;
import com.sleepycat.db.DatabaseEntry;
import com.sleepycat.db.DatabaseException;
import com.sleepycat.db.Environment;
import com.sleepycat.db.ErrorHandler;
import com.sleepycat.db.EventHandler;
import com.sleepycat.db.FeedbackHandler;
import com.sleepycat.db.LockRequest;
import com.sleepycat.db.LockStats;
import com.sleepycat.db.LogRecordHandler;
import com.sleepycat.db.LogSequenceNumber;
import com.sleepycat.db.LogStats;
import com.sleepycat.db.MessageHandler;
import com.sleepycat.db.MutexStats;
import com.sleepycat.db.PanicHandler;
import com.sleepycat.db.PreparedTransaction;
import com.sleepycat.db.RecoveryOperation;
import com.sleepycat.db.ReplicationManagerSiteInfo;
import com.sleepycat.db.ReplicationManagerStats;
import com.sleepycat.db.ReplicationStats;
import com.sleepycat.db.ReplicationTransport;
import com.sleepycat.db.TransactionStats;
import com.sleepycat.db.internal.DbLock;
import com.sleepycat.db.internal.DbLogc;
import com.sleepycat.db.internal.DbTxn;
import com.sleepycat.db.internal.db_java;
import com.sleepycat.db.internal.db_javaJNI;
import com.sleepycat.util.ErrorBuffer;
import java.io.FileNotFoundException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.Date;

public class DbEnv {
    private long swigCPtr;
    protected boolean swigCMemOwn;
    private long dbenv_ref;
    public Environment wrapper;
    private LogRecordHandler app_dispatch_handler;
    private EventHandler event_notify_handler;
    private FeedbackHandler env_feedback_handler;
    private ErrorHandler error_handler;
    private String errpfx;
    private MessageHandler message_handler;
    private PanicHandler panic_handler;
    private ReplicationTransport rep_transport_handler;
    private OutputStream error_stream;
    private OutputStream message_stream;
    private ThreadLocal errBuf;

    protected DbEnv(long l, boolean bl) {
        this.swigCMemOwn = bl;
        this.swigCPtr = l;
    }

    protected static long getCPtr(DbEnv dbEnv) {
        return dbEnv == null ? 0L : dbEnv.swigCPtr;
    }

    synchronized void delete() {
        if (this.swigCPtr != 0L) {
            if (this.swigCMemOwn) {
                this.swigCMemOwn = false;
                throw new UnsupportedOperationException("C++ destructor does not have public access");
            }
            this.swigCPtr = 0L;
        }
    }

    void initialize() {
        this.dbenv_ref = db_java.initDbEnvRef0(this, this);
        this.errBuf = new ThreadLocal();
        this.set_error_stream(System.err);
        this.set_message_stream(System.out);
    }

    void cleanup() {
        this.swigCPtr = 0L;
        db_java.deleteRef0(this.dbenv_ref);
        this.dbenv_ref = 0L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void close(int n) throws DatabaseException {
        try {
            this.close0(n);
        }
        finally {
            this.cleanup();
        }
    }

    private final int handle_app_dispatch(DatabaseEntry databaseEntry, LogSequenceNumber logSequenceNumber, int n) {
        return this.app_dispatch_handler.handleLogRecord(this.wrapper, databaseEntry, logSequenceNumber, RecoveryOperation.fromFlag(n));
    }

    public LogRecordHandler get_app_dispatch() throws DatabaseException {
        return this.app_dispatch_handler;
    }

    private final void handle_panic_event_notify() {
        this.event_notify_handler.handlePanicEvent();
    }

    private final void handle_rep_client_event_notify() {
        this.event_notify_handler.handleRepClientEvent();
    }

    private final void handle_rep_dupmaster_event_notify() {
        this.event_notify_handler.handleRepDupmasterEvent();
    }

    private final void handle_rep_elected_event_notify() {
        this.event_notify_handler.handleRepElectedEvent();
    }

    private final void handle_rep_election_failed_event_notify() {
        this.event_notify_handler.handleRepElectionFailedEvent();
    }

    private final void handle_rep_join_failure_event_notify() {
        this.event_notify_handler.handleRepJoinFailureEvent();
    }

    private final void handle_rep_master_event_notify() {
        this.event_notify_handler.handleRepMasterEvent();
    }

    private final void handle_rep_master_failure_event_notify() {
        this.event_notify_handler.handleRepMasterFailureEvent();
    }

    private final void handle_rep_new_master_event_notify(int n) {
        this.event_notify_handler.handleRepNewMasterEvent(n);
    }

    private final void handle_rep_perm_failed_event_notify() {
        this.event_notify_handler.handleRepPermFailedEvent();
    }

    private final void handle_rep_startup_done_event_notify() {
        this.event_notify_handler.handleRepStartupDoneEvent();
    }

    private final void handle_write_failed_event_notify(int n) {
        this.event_notify_handler.handleWriteFailedEvent(n);
    }

    public EventHandler get_event_notify() throws DatabaseException {
        return this.event_notify_handler;
    }

    private final void handle_env_feedback(int n, int n2) {
        if (n == 2) {
            this.env_feedback_handler.recoveryFeedback(this.wrapper, n2);
        }
    }

    public FeedbackHandler get_feedback() throws DatabaseException {
        return this.env_feedback_handler;
    }

    public void set_errpfx(String string) {
        this.errpfx = string;
    }

    public String get_errpfx() {
        return this.errpfx;
    }

    private final void handle_error(String string) {
        ErrorBuffer errorBuffer = (ErrorBuffer)this.errBuf.get();
        if (errorBuffer == null) {
            errorBuffer = new ErrorBuffer(3);
            this.errBuf.set(errorBuffer);
        }
        errorBuffer.append(string);
        this.error_handler.error(this.wrapper, this.errpfx, string);
    }

    private final String get_err_msg(String string) {
        ErrorBuffer errorBuffer = (ErrorBuffer)this.errBuf.get();
        String string2 = null;
        if (errorBuffer != null) {
            string2 = errorBuffer.get();
            errorBuffer.clear();
        }
        if (string2 != null && string2.length() > 0) {
            return string + ": " + string2;
        }
        return string;
    }

    public ErrorHandler get_errcall() {
        return this.error_handler;
    }

    private final void handle_message(String string) {
        this.message_handler.message(this.wrapper, string);
    }

    public MessageHandler get_msgcall() {
        return this.message_handler;
    }

    private final void handle_panic(DatabaseException databaseException) {
        this.panic_handler.panic(this.wrapper, databaseException);
    }

    public PanicHandler get_paniccall() throws DatabaseException {
        return this.panic_handler;
    }

    private final int handle_rep_transport(DatabaseEntry databaseEntry, DatabaseEntry databaseEntry2, LogSequenceNumber logSequenceNumber, int n, int n2) throws DatabaseException {
        return this.rep_transport_handler.send(this.wrapper, databaseEntry, databaseEntry2, logSequenceNumber, n, (n2 & 2) != 0, (n2 & 4) != 0, (n2 & 1) != 0, (n2 & 8) != 0);
    }

    public void lock_vec(int n, int n2, LockRequest[] lockRequestArray, int n3, int n4) throws DatabaseException {
        db_javaJNI.DbEnv_lock_vec(this.swigCPtr, this, n, n2, lockRequestArray, n3, n4);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void remove(String string, int n) throws DatabaseException, FileNotFoundException {
        try {
            this.remove0(string, n);
        }
        finally {
            this.cleanup();
        }
    }

    public void set_error_stream(OutputStream outputStream) {
        this.error_stream = outputStream;
        final PrintWriter printWriter = new PrintWriter(outputStream);
        this.set_errcall(new ErrorHandler(){

            public void error(Environment environment, String string, String string2) {
                if (string != null) {
                    printWriter.print(string + ": ");
                }
                printWriter.println(string2);
                printWriter.flush();
            }
        });
    }

    public OutputStream get_error_stream() {
        return this.error_stream;
    }

    public void set_message_stream(OutputStream outputStream) {
        this.message_stream = outputStream;
        final PrintWriter printWriter = new PrintWriter(outputStream);
        this.set_msgcall(new MessageHandler(){

            public void message(Environment environment, String string) {
                printWriter.println(string);
                printWriter.flush();
            }
        });
    }

    public OutputStream get_message_stream() {
        return this.message_stream;
    }

    public void set_tx_timestamp(Date date) throws DatabaseException {
        this.set_tx_timestamp0(date.getTime() / 1000L);
    }

    public DbEnv(int n) throws DatabaseException {
        this(db_javaJNI.new_DbEnv(n), true);
        this.initialize();
    }

    void close0(int n) {
        db_javaJNI.DbEnv_close0(this.swigCPtr, this, n);
    }

    public void dbremove(DbTxn dbTxn, String string, String string2, int n) throws DatabaseException, FileNotFoundException {
        db_javaJNI.DbEnv_dbremove(this.swigCPtr, this, DbTxn.getCPtr(dbTxn), dbTxn, string, string2, n);
    }

    public void dbrename(DbTxn dbTxn, String string, String string2, String string3, int n) throws DatabaseException, FileNotFoundException {
        db_javaJNI.DbEnv_dbrename(this.swigCPtr, this, DbTxn.getCPtr(dbTxn), dbTxn, string, string2, string3, n);
    }

    public void err(int n, String string) {
        db_javaJNI.DbEnv_err(this.swigCPtr, this, n, string);
    }

    public void errx(String string) {
        db_javaJNI.DbEnv_errx(this.swigCPtr, this, string);
    }

    public DbTxn cdsgroup_begin() throws DatabaseException {
        long l = db_javaJNI.DbEnv_cdsgroup_begin(this.swigCPtr, this);
        return l == 0L ? null : new DbTxn(l, false);
    }

    public void fileid_reset(String string, int n) throws DatabaseException {
        db_javaJNI.DbEnv_fileid_reset(this.swigCPtr, this, string, n);
    }

    public String[] get_data_dirs() throws DatabaseException {
        return db_javaJNI.DbEnv_get_data_dirs(this.swigCPtr, this);
    }

    public int get_encrypt_flags() throws DatabaseException {
        return db_javaJNI.DbEnv_get_encrypt_flags(this.swigCPtr, this);
    }

    public int get_flags() throws DatabaseException {
        return db_javaJNI.DbEnv_get_flags(this.swigCPtr, this);
    }

    public String get_home() throws DatabaseException {
        return db_javaJNI.DbEnv_get_home(this.swigCPtr, this);
    }

    public String get_intermediate_dir_mode() throws DatabaseException {
        return db_javaJNI.DbEnv_get_intermediate_dir_mode(this.swigCPtr, this);
    }

    public int get_open_flags() throws DatabaseException {
        return db_javaJNI.DbEnv_get_open_flags(this.swigCPtr, this);
    }

    public long get_shm_key() throws DatabaseException {
        return db_javaJNI.DbEnv_get_shm_key(this.swigCPtr, this);
    }

    public String get_tmp_dir() throws DatabaseException {
        return db_javaJNI.DbEnv_get_tmp_dir(this.swigCPtr, this);
    }

    public boolean get_verbose(int n) throws DatabaseException {
        return db_javaJNI.DbEnv_get_verbose(this.swigCPtr, this, n);
    }

    public boolean is_bigendian() throws DatabaseException {
        return db_javaJNI.DbEnv_is_bigendian(this.swigCPtr, this);
    }

    public void lsn_reset(String string, int n) throws DatabaseException {
        db_javaJNI.DbEnv_lsn_reset(this.swigCPtr, this, string, n);
    }

    public void open(String string, int n, int n2) throws DatabaseException, FileNotFoundException {
        db_javaJNI.DbEnv_open(this.swigCPtr, this, string, n, n2);
    }

    void remove0(String string, int n) {
        db_javaJNI.DbEnv_remove0(this.swigCPtr, this, string, n);
    }

    public void set_cachesize(long l, int n) throws DatabaseException {
        db_javaJNI.DbEnv_set_cachesize(this.swigCPtr, this, l, n);
    }

    public void set_cache_max(long l) throws DatabaseException {
        db_javaJNI.DbEnv_set_cache_max(this.swigCPtr, this, l);
    }

    public void set_create_dir(String string) throws DatabaseException {
        db_javaJNI.DbEnv_set_create_dir(this.swigCPtr, this, string);
    }

    public void set_data_dir(String string) throws DatabaseException {
        db_javaJNI.DbEnv_set_data_dir(this.swigCPtr, this, string);
    }

    public void set_intermediate_dir_mode(String string) throws DatabaseException {
        db_javaJNI.DbEnv_set_intermediate_dir_mode(this.swigCPtr, this, string);
    }

    public void set_encrypt(String string, int n) throws DatabaseException {
        db_javaJNI.DbEnv_set_encrypt(this.swigCPtr, this, string, n);
    }

    public void set_errcall(ErrorHandler errorHandler) {
        this.error_handler = errorHandler;
        db_javaJNI.DbEnv_set_errcall(this.swigCPtr, this, this.error_handler != null);
    }

    public void set_flags(int n, boolean bl) throws DatabaseException {
        db_javaJNI.DbEnv_set_flags(this.swigCPtr, this, n, bl);
    }

    public void set_feedback(FeedbackHandler feedbackHandler) throws DatabaseException {
        this.env_feedback_handler = feedbackHandler;
        db_javaJNI.DbEnv_set_feedback(this.swigCPtr, this, this.env_feedback_handler != null);
    }

    public void set_mp_max_openfd(int n) throws DatabaseException {
        db_javaJNI.DbEnv_set_mp_max_openfd(this.swigCPtr, this, n);
    }

    public void set_mp_max_write(int n, long l) throws DatabaseException {
        db_javaJNI.DbEnv_set_mp_max_write(this.swigCPtr, this, n, l);
    }

    public void set_mp_mmapsize(long l) throws DatabaseException {
        db_javaJNI.DbEnv_set_mp_mmapsize(this.swigCPtr, this, l);
    }

    public void set_mp_pagesize(int n) throws DatabaseException {
        db_javaJNI.DbEnv_set_mp_pagesize(this.swigCPtr, this, n);
    }

    public void set_mp_tablesize(int n) throws DatabaseException {
        db_javaJNI.DbEnv_set_mp_tablesize(this.swigCPtr, this, n);
    }

    public void set_msgcall(MessageHandler messageHandler) {
        this.message_handler = messageHandler;
        db_javaJNI.DbEnv_set_msgcall(this.swigCPtr, this, this.message_handler != null);
    }

    public void set_paniccall(PanicHandler panicHandler) throws DatabaseException {
        this.panic_handler = panicHandler;
        db_javaJNI.DbEnv_set_paniccall(this.swigCPtr, this, this.panic_handler != null);
    }

    public void set_rpc_server(String string, long l, long l2, int n) throws DatabaseException {
        db_javaJNI.DbEnv_set_rpc_server(this.swigCPtr, this, string, l, l2, n);
    }

    public void set_shm_key(long l) throws DatabaseException {
        db_javaJNI.DbEnv_set_shm_key(this.swigCPtr, this, l);
    }

    public void set_timeout(long l, int n) throws DatabaseException {
        db_javaJNI.DbEnv_set_timeout(this.swigCPtr, this, l, n);
    }

    public void set_tmp_dir(String string) throws DatabaseException {
        db_javaJNI.DbEnv_set_tmp_dir(this.swigCPtr, this, string);
    }

    public void set_tx_max(int n) throws DatabaseException {
        db_javaJNI.DbEnv_set_tx_max(this.swigCPtr, this, n);
    }

    public void set_app_dispatch(LogRecordHandler logRecordHandler) throws DatabaseException {
        this.app_dispatch_handler = logRecordHandler;
        db_javaJNI.DbEnv_set_app_dispatch(this.swigCPtr, this, this.app_dispatch_handler != null);
    }

    public void set_event_notify(EventHandler eventHandler) throws DatabaseException {
        this.event_notify_handler = eventHandler;
        db_javaJNI.DbEnv_set_event_notify(this.swigCPtr, this, this.event_notify_handler != null);
    }

    void set_tx_timestamp0(long l) {
        db_javaJNI.DbEnv_set_tx_timestamp0(this.swigCPtr, this, l);
    }

    public void set_verbose(int n, boolean bl) throws DatabaseException {
        db_javaJNI.DbEnv_set_verbose(this.swigCPtr, this, n, bl);
    }

    public byte[][] get_lk_conflicts() throws DatabaseException {
        return db_javaJNI.DbEnv_get_lk_conflicts(this.swigCPtr, this);
    }

    public int get_lk_detect() throws DatabaseException {
        return db_javaJNI.DbEnv_get_lk_detect(this.swigCPtr, this);
    }

    public int get_lk_max_locks() throws DatabaseException {
        return db_javaJNI.DbEnv_get_lk_max_locks(this.swigCPtr, this);
    }

    public int get_lk_max_lockers() throws DatabaseException {
        return db_javaJNI.DbEnv_get_lk_max_lockers(this.swigCPtr, this);
    }

    public int get_lk_max_objects() throws DatabaseException {
        return db_javaJNI.DbEnv_get_lk_max_objects(this.swigCPtr, this);
    }

    public int get_lk_partitions() throws DatabaseException {
        return db_javaJNI.DbEnv_get_lk_partitions(this.swigCPtr, this);
    }

    public int get_lk_priority(int n) throws DatabaseException {
        return db_javaJNI.DbEnv_get_lk_priority(this.swigCPtr, this, n);
    }

    public int lock_detect(int n, int n2) throws DatabaseException {
        return db_javaJNI.DbEnv_lock_detect(this.swigCPtr, this, n, n2);
    }

    public DbLock lock_get(int n, int n2, DatabaseEntry databaseEntry, int n3) throws DatabaseException {
        long l = db_javaJNI.DbEnv_lock_get(this.swigCPtr, this, n, n2, databaseEntry, n3);
        return l == 0L ? null : new DbLock(l, true);
    }

    public int lock_id() throws DatabaseException {
        return db_javaJNI.DbEnv_lock_id(this.swigCPtr, this);
    }

    public void lock_id_free(int n) throws DatabaseException {
        db_javaJNI.DbEnv_lock_id_free(this.swigCPtr, this, n);
    }

    public void lock_put(DbLock dbLock) throws DatabaseException {
        db_javaJNI.DbEnv_lock_put(this.swigCPtr, this, DbLock.getCPtr(dbLock), dbLock);
    }

    public LockStats lock_stat(int n) throws DatabaseException {
        return db_javaJNI.DbEnv_lock_stat(this.swigCPtr, this, n);
    }

    public void set_lk_conflicts(byte[][] byArray) throws DatabaseException {
        db_javaJNI.DbEnv_set_lk_conflicts(this.swigCPtr, this, byArray);
    }

    public void set_lk_detect(int n) throws DatabaseException {
        db_javaJNI.DbEnv_set_lk_detect(this.swigCPtr, this, n);
    }

    public void set_lk_max_lockers(int n) throws DatabaseException {
        db_javaJNI.DbEnv_set_lk_max_lockers(this.swigCPtr, this, n);
    }

    public void set_lk_max_locks(int n) throws DatabaseException {
        db_javaJNI.DbEnv_set_lk_max_locks(this.swigCPtr, this, n);
    }

    public void set_lk_max_objects(int n) throws DatabaseException {
        db_javaJNI.DbEnv_set_lk_max_objects(this.swigCPtr, this, n);
    }

    public void set_lk_partitions(int n) throws DatabaseException {
        db_javaJNI.DbEnv_set_lk_partitions(this.swigCPtr, this, n);
    }

    public void set_lk_priority(int n, int n2) throws DatabaseException {
        db_javaJNI.DbEnv_set_lk_priority(this.swigCPtr, this, n, n2);
    }

    public int get_lg_bsize() throws DatabaseException {
        return db_javaJNI.DbEnv_get_lg_bsize(this.swigCPtr, this);
    }

    public String get_lg_dir() throws DatabaseException {
        return db_javaJNI.DbEnv_get_lg_dir(this.swigCPtr, this);
    }

    public int get_lg_filemode() throws DatabaseException {
        return db_javaJNI.DbEnv_get_lg_filemode(this.swigCPtr, this);
    }

    public int get_lg_max() throws DatabaseException {
        return db_javaJNI.DbEnv_get_lg_max(this.swigCPtr, this);
    }

    public int get_lg_regionmax() throws DatabaseException {
        return db_javaJNI.DbEnv_get_lg_regionmax(this.swigCPtr, this);
    }

    public String[] log_archive(int n) throws DatabaseException {
        return db_javaJNI.DbEnv_log_archive(this.swigCPtr, this, n);
    }

    public static int log_compare(LogSequenceNumber logSequenceNumber, LogSequenceNumber logSequenceNumber2) {
        return db_javaJNI.DbEnv_log_compare(logSequenceNumber, logSequenceNumber2);
    }

    public DbLogc log_cursor(int n) throws DatabaseException {
        long l = db_javaJNI.DbEnv_log_cursor(this.swigCPtr, this, n);
        return l == 0L ? null : new DbLogc(l, true);
    }

    public String log_file(LogSequenceNumber logSequenceNumber) throws DatabaseException {
        return db_javaJNI.DbEnv_log_file(this.swigCPtr, this, logSequenceNumber);
    }

    public void log_flush(LogSequenceNumber logSequenceNumber) throws DatabaseException {
        db_javaJNI.DbEnv_log_flush(this.swigCPtr, this, logSequenceNumber);
    }

    public boolean log_get_config(int n) throws DatabaseException {
        return db_javaJNI.DbEnv_log_get_config(this.swigCPtr, this, n);
    }

    public void log_put(LogSequenceNumber logSequenceNumber, DatabaseEntry databaseEntry, int n) throws DatabaseException {
        db_javaJNI.DbEnv_log_put(this.swigCPtr, this, logSequenceNumber, databaseEntry, n);
    }

    public void log_print(DbTxn dbTxn, String string) throws DatabaseException {
        db_javaJNI.DbEnv_log_print(this.swigCPtr, this, DbTxn.getCPtr(dbTxn), dbTxn, string);
    }

    public void log_set_config(int n, boolean bl) throws DatabaseException {
        db_javaJNI.DbEnv_log_set_config(this.swigCPtr, this, n, bl);
    }

    public LogStats log_stat(int n) throws DatabaseException {
        return db_javaJNI.DbEnv_log_stat(this.swigCPtr, this, n);
    }

    public int log_verify(String string, int n, String string2, String string3, long l, long l2, int n2, int n3, int n4, int n5, int n6, int n7) throws DatabaseException {
        return db_javaJNI.DbEnv_log_verify(this.swigCPtr, this, string, n, string2, string3, l, l2, n2, n3, n4, n5, n6, n7);
    }

    public void set_lg_bsize(int n) throws DatabaseException {
        db_javaJNI.DbEnv_set_lg_bsize(this.swigCPtr, this, n);
    }

    public void set_lg_dir(String string) throws DatabaseException {
        db_javaJNI.DbEnv_set_lg_dir(this.swigCPtr, this, string);
    }

    public void set_lg_filemode(int n) throws DatabaseException {
        db_javaJNI.DbEnv_set_lg_filemode(this.swigCPtr, this, n);
    }

    public void set_lg_max(int n) throws DatabaseException {
        db_javaJNI.DbEnv_set_lg_max(this.swigCPtr, this, n);
    }

    public void set_lg_regionmax(int n) throws DatabaseException {
        db_javaJNI.DbEnv_set_lg_regionmax(this.swigCPtr, this, n);
    }

    public long get_cachesize() throws DatabaseException {
        return db_javaJNI.DbEnv_get_cachesize(this.swigCPtr, this);
    }

    public int get_cachesize_ncache() throws DatabaseException {
        return db_javaJNI.DbEnv_get_cachesize_ncache(this.swigCPtr, this);
    }

    public long get_cache_max() throws DatabaseException {
        return db_javaJNI.DbEnv_get_cache_max(this.swigCPtr, this);
    }

    public String get_create_dir() throws DatabaseException {
        return db_javaJNI.DbEnv_get_create_dir(this.swigCPtr, this);
    }

    public int get_mp_max_openfd() throws DatabaseException {
        return db_javaJNI.DbEnv_get_mp_max_openfd(this.swigCPtr, this);
    }

    public int get_mp_max_write() throws DatabaseException {
        return db_javaJNI.DbEnv_get_mp_max_write(this.swigCPtr, this);
    }

    public long get_mp_max_write_sleep() throws DatabaseException {
        return db_javaJNI.DbEnv_get_mp_max_write_sleep(this.swigCPtr, this);
    }

    public long get_mp_mmapsize() throws DatabaseException {
        return db_javaJNI.DbEnv_get_mp_mmapsize(this.swigCPtr, this);
    }

    public int get_mp_pagesize() throws DatabaseException {
        return db_javaJNI.DbEnv_get_mp_pagesize(this.swigCPtr, this);
    }

    public int get_mp_tablesize() throws DatabaseException {
        return db_javaJNI.DbEnv_get_mp_tablesize(this.swigCPtr, this);
    }

    public CacheStats memp_stat(int n) throws DatabaseException {
        return db_javaJNI.DbEnv_memp_stat(this.swigCPtr, this, n);
    }

    public CacheFileStats[] memp_fstat(int n) throws DatabaseException {
        return db_javaJNI.DbEnv_memp_fstat(this.swigCPtr, this, n);
    }

    public void memp_sync(LogSequenceNumber logSequenceNumber) throws DatabaseException {
        db_javaJNI.DbEnv_memp_sync(this.swigCPtr, this, logSequenceNumber);
    }

    public int memp_trickle(int n) throws DatabaseException {
        return db_javaJNI.DbEnv_memp_trickle(this.swigCPtr, this, n);
    }

    public int mutex_get_align() throws DatabaseException {
        return db_javaJNI.DbEnv_mutex_get_align(this.swigCPtr, this);
    }

    public int mutex_get_increment() throws DatabaseException {
        return db_javaJNI.DbEnv_mutex_get_increment(this.swigCPtr, this);
    }

    public int mutex_get_max() throws DatabaseException {
        return db_javaJNI.DbEnv_mutex_get_max(this.swigCPtr, this);
    }

    public int mutex_get_tas_spins() throws DatabaseException {
        return db_javaJNI.DbEnv_mutex_get_tas_spins(this.swigCPtr, this);
    }

    public void mutex_set_align(int n) throws DatabaseException {
        db_javaJNI.DbEnv_mutex_set_align(this.swigCPtr, this, n);
    }

    public void mutex_set_increment(int n) throws DatabaseException {
        db_javaJNI.DbEnv_mutex_set_increment(this.swigCPtr, this, n);
    }

    public void mutex_set_max(int n) throws DatabaseException {
        db_javaJNI.DbEnv_mutex_set_max(this.swigCPtr, this, n);
    }

    public void mutex_set_tas_spins(int n) throws DatabaseException {
        db_javaJNI.DbEnv_mutex_set_tas_spins(this.swigCPtr, this, n);
    }

    public MutexStats mutex_stat(int n) throws DatabaseException {
        return db_javaJNI.DbEnv_mutex_stat(this.swigCPtr, this, n);
    }

    public int get_tx_max() throws DatabaseException {
        return db_javaJNI.DbEnv_get_tx_max(this.swigCPtr, this);
    }

    public long get_tx_timestamp() throws DatabaseException {
        return db_javaJNI.DbEnv_get_tx_timestamp(this.swigCPtr, this);
    }

    public long get_timeout(int n) throws DatabaseException {
        return db_javaJNI.DbEnv_get_timeout(this.swigCPtr, this, n);
    }

    public int txn_applied(byte[] byArray, int n, int n2) throws DatabaseException {
        return db_javaJNI.DbEnv_txn_applied(this.swigCPtr, this, byArray, n, n2);
    }

    public DbTxn txn_begin(DbTxn dbTxn, int n) throws DatabaseException {
        long l = db_javaJNI.DbEnv_txn_begin(this.swigCPtr, this, DbTxn.getCPtr(dbTxn), dbTxn, n);
        return l == 0L ? null : new DbTxn(l, false);
    }

    public void txn_checkpoint(int n, int n2, int n3) throws DatabaseException {
        db_javaJNI.DbEnv_txn_checkpoint(this.swigCPtr, this, n, n2, n3);
    }

    public PreparedTransaction[] txn_recover(int n, int n2) throws DatabaseException {
        return db_javaJNI.DbEnv_txn_recover(this.swigCPtr, this, n, n2);
    }

    public TransactionStats txn_stat(int n) throws DatabaseException {
        return db_javaJNI.DbEnv_txn_stat(this.swigCPtr, this, n);
    }

    public long rep_get_limit() throws DatabaseException {
        return db_javaJNI.DbEnv_rep_get_limit(this.swigCPtr, this);
    }

    public void rep_elect(int n, int n2, int n3) throws DatabaseException {
        db_javaJNI.DbEnv_rep_elect(this.swigCPtr, this, n, n2, n3);
    }

    public int rep_process_message(DatabaseEntry databaseEntry, DatabaseEntry databaseEntry2, int n, LogSequenceNumber logSequenceNumber) {
        return db_javaJNI.DbEnv_rep_process_message(this.swigCPtr, this, databaseEntry, databaseEntry2, n, logSequenceNumber);
    }

    public void rep_flush() throws DatabaseException {
        db_javaJNI.DbEnv_rep_flush(this.swigCPtr, this);
    }

    public void rep_set_config(int n, boolean bl) throws DatabaseException {
        db_javaJNI.DbEnv_rep_set_config(this.swigCPtr, this, n, bl);
    }

    public void rep_set_clockskew(int n, int n2) throws DatabaseException {
        db_javaJNI.DbEnv_rep_set_clockskew(this.swigCPtr, this, n, n2);
    }

    public int rep_get_clockskew_fast() throws DatabaseException {
        return db_javaJNI.DbEnv_rep_get_clockskew_fast(this.swigCPtr, this);
    }

    public int rep_get_clockskew_slow() throws DatabaseException {
        return db_javaJNI.DbEnv_rep_get_clockskew_slow(this.swigCPtr, this);
    }

    public void rep_start(DatabaseEntry databaseEntry, int n) throws DatabaseException {
        db_javaJNI.DbEnv_rep_start(this.swigCPtr, this, databaseEntry, n);
    }

    public void rep_sync(int n) throws DatabaseException {
        db_javaJNI.DbEnv_rep_sync(this.swigCPtr, this, n);
    }

    public boolean rep_get_config(int n) throws DatabaseException {
        return db_javaJNI.DbEnv_rep_get_config(this.swigCPtr, this, n);
    }

    public ReplicationStats rep_stat(int n) throws DatabaseException {
        return db_javaJNI.DbEnv_rep_stat(this.swigCPtr, this, n);
    }

    public void rep_set_limit(long l) throws DatabaseException {
        db_javaJNI.DbEnv_rep_set_limit(this.swigCPtr, this, l);
    }

    public int rep_get_request_min() throws DatabaseException {
        return db_javaJNI.DbEnv_rep_get_request_min(this.swigCPtr, this);
    }

    public int rep_get_request_max() throws DatabaseException {
        return db_javaJNI.DbEnv_rep_get_request_max(this.swigCPtr, this);
    }

    public void rep_set_request(int n, int n2) throws DatabaseException {
        db_javaJNI.DbEnv_rep_set_request(this.swigCPtr, this, n, n2);
    }

    public void rep_set_transport(int n, ReplicationTransport replicationTransport) throws DatabaseException {
        this.rep_transport_handler = replicationTransport;
        db_javaJNI.DbEnv_rep_set_transport(this.swigCPtr, this, n, this.rep_transport_handler != null);
    }

    public int rep_get_nsites() throws DatabaseException {
        return db_javaJNI.DbEnv_rep_get_nsites(this.swigCPtr, this);
    }

    public int rep_get_priority() throws DatabaseException {
        return db_javaJNI.DbEnv_rep_get_priority(this.swigCPtr, this);
    }

    public int rep_get_timeout(int n) throws DatabaseException {
        return db_javaJNI.DbEnv_rep_get_timeout(this.swigCPtr, this, n);
    }

    public void rep_set_nsites(int n) throws DatabaseException {
        db_javaJNI.DbEnv_rep_set_nsites(this.swigCPtr, this, n);
    }

    public void rep_set_priority(int n) throws DatabaseException {
        db_javaJNI.DbEnv_rep_set_priority(this.swigCPtr, this, n);
    }

    public void rep_set_timeout(int n, long l) throws DatabaseException {
        db_javaJNI.DbEnv_rep_set_timeout(this.swigCPtr, this, n, l);
    }

    public int repmgr_add_remote_site(String string, int n, int n2) throws DatabaseException {
        return db_javaJNI.DbEnv_repmgr_add_remote_site(this.swigCPtr, this, string, n, n2);
    }

    public void repmgr_get_ack_policy() throws DatabaseException {
        db_javaJNI.DbEnv_repmgr_get_ack_policy(this.swigCPtr, this);
    }

    public void repmgr_set_ack_policy(int n) throws DatabaseException {
        db_javaJNI.DbEnv_repmgr_set_ack_policy(this.swigCPtr, this, n);
    }

    public void repmgr_set_local_site(String string, int n, int n2) throws DatabaseException {
        db_javaJNI.DbEnv_repmgr_set_local_site(this.swigCPtr, this, string, n, n2);
    }

    public ReplicationManagerSiteInfo[] repmgr_site_list() throws DatabaseException {
        return db_javaJNI.DbEnv_repmgr_site_list(this.swigCPtr, this);
    }

    public void repmgr_start(int n, int n2) throws DatabaseException {
        db_javaJNI.DbEnv_repmgr_start(this.swigCPtr, this, n, n2);
    }

    public ReplicationManagerStats repmgr_stat(int n) throws DatabaseException {
        return db_javaJNI.DbEnv_repmgr_stat(this.swigCPtr, this, n);
    }

    public static String strerror(int n) {
        return db_javaJNI.DbEnv_strerror(n);
    }

    public static int get_version_family() {
        return db_javaJNI.DbEnv_get_version_family();
    }

    public static int get_version_release() {
        return db_javaJNI.DbEnv_get_version_release();
    }

    public static int get_version_major() {
        return db_javaJNI.DbEnv_get_version_major();
    }

    public static int get_version_minor() {
        return db_javaJNI.DbEnv_get_version_minor();
    }

    public static int get_version_patch() {
        return db_javaJNI.DbEnv_get_version_patch();
    }

    public static String get_version_string() {
        return db_javaJNI.DbEnv_get_version_string();
    }

    public static String get_version_full_string() {
        return db_javaJNI.DbEnv_get_version_full_string();
    }

    public static class RepProcessMessage {
        public int envid;
    }
}

