/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.db;

import com.sleepycat.db.internal.DbEnv;

public final class TransactionStatus {
    public static final TransactionStatus APPLIED = new TransactionStatus("APPLIED", 0);
    public static final TransactionStatus TIMEOUT = new TransactionStatus("TIMEOUT", -30971);
    public static final TransactionStatus EMPTY_TRANSACTION = new TransactionStatus("EMPTY_TRANSACTION", -30996);
    public static final TransactionStatus NOTFOUND = new TransactionStatus("NOTFOUND", -30987);
    private String statusName;
    private int errCode;

    static TransactionStatus fromInt(int n) {
        switch (n) {
            case 0: {
                return APPLIED;
            }
            case -30971: {
                return TIMEOUT;
            }
            case -30996: {
                return EMPTY_TRANSACTION;
            }
            case -30987: {
                return NOTFOUND;
            }
        }
        throw new IllegalArgumentException("Unknown error code: " + DbEnv.strerror(n));
    }

    private TransactionStatus(String string, int n) {
        this.statusName = string;
        this.errCode = n;
    }

    public String toString() {
        return "TransactionStatus." + this.statusName;
    }
}

