/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.db;

import com.sleepycat.db.internal.DbEnv;

public final class OperationStatus {
    public static final OperationStatus SUCCESS = new OperationStatus("SUCCESS", 0);
    public static final OperationStatus KEYEXIST = new OperationStatus("KEYEXIST", -30995);
    public static final OperationStatus KEYEMPTY = new OperationStatus("KEYEMPTY", -30996);
    public static final OperationStatus NOTFOUND = new OperationStatus("NOTFOUND", -30987);
    private String statusName;
    private int errCode;

    static OperationStatus fromInt(int n) {
        switch (n) {
            case 0: {
                return SUCCESS;
            }
            case -30995: {
                return KEYEXIST;
            }
            case -30996: {
                return KEYEMPTY;
            }
            case -30987: {
                return NOTFOUND;
            }
        }
        throw new IllegalArgumentException("Unknown error code: " + DbEnv.strerror(n));
    }

    private OperationStatus(String string, int n) {
        this.statusName = string;
        this.errCode = n;
    }

    public String toString() {
        return "OperationStatus." + this.statusName;
    }
}

