/*
 * Decompiled with CFR 0.152.
 */
package griffon.plugins.hibernate4.internal;

import griffon.plugins.hibernate4.internal.JdbcUtils;
import griffon.plugins.hibernate4.internal.exceptions.DatabaseException;
import griffon.util.GriffonNameUtils;
import java.sql.Connection;
import java.sql.SQLException;
import javax.sql.DataSource;
import org.hibernate.dialect.Dialect;
import org.hibernate.service.jdbc.dialect.internal.StandardDialectResolver;
import org.hibernate.service.jdbc.dialect.spi.DialectResolver;

public class DialectDetector {
    private final DataSource dataSource;
    private final DialectResolver dialectResolver;

    public DialectDetector(DataSource dataSource) {
        this.dataSource = dataSource;
        this.dialectResolver = new StandardDialectResolver();
    }

    public String getDialect() {
        String string;
        Connection connection = null;
        try {
            String dbName = (String)JdbcUtils.extractDatabaseMetaData(this.dataSource, "getDatabaseProductName");
            connection = this.dataSource.getConnection();
            Dialect hibernateDialect = this.dialectResolver.resolveDialect(connection.getMetaData());
            String hibernateDialectClassName = hibernateDialect.getClass().getName();
            if (GriffonNameUtils.isBlank((String)hibernateDialectClassName)) {
                throw new DatabaseException("Could not determine Hibernate dialect for database name [" + dbName + "]!");
            }
            string = hibernateDialectClassName;
        }
        catch (SQLException e) {
            try {
                throw new DatabaseException(e);
            }
            catch (Throwable throwable) {
                JdbcUtils.closeConnection(connection);
                throw throwable;
            }
        }
        JdbcUtils.closeConnection(connection);
        return string;
    }
}

