/*
 * Decompiled with CFR 0.152.
 */
package griffon.plugins.hibernate4;

import griffon.plugins.hibernate4.Hibernate4Provider;
import griffon.util.CallableWithArgs;
import griffon.util.GriffonNameUtils;
import groovy.lang.Closure;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractHibernate4Provider
implements Hibernate4Provider {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractHibernate4Provider.class);
    private static final String DEFAULT = "default";

    @Override
    public <R> R withHibernate4(Closure<R> closure) {
        return this.withHibernate4(DEFAULT, closure);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <R> R withHibernate4(String sessionFactoryName, Closure<R> closure) {
        if (GriffonNameUtils.isBlank((String)sessionFactoryName)) {
            sessionFactoryName = DEFAULT;
        }
        if (closure != null) {
            SessionFactory sf = this.getSessionFactory(sessionFactoryName);
            if (LOG.isDebugEnabled()) {
                LOG.debug("Executing statements on session '" + sessionFactoryName + "'");
            }
            Session session = sf.openSession();
            try {
                session.beginTransaction();
                Object object = closure.call(new Object[]{sessionFactoryName, session});
                return (R)object;
            }
            finally {
                if (!session.getTransaction().wasRolledBack()) {
                    session.getTransaction().commit();
                }
                session.close();
            }
        }
        return null;
    }

    @Override
    public <R> R withHibernate4(CallableWithArgs<R> callable) {
        return this.withHibernate4(DEFAULT, callable);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <R> R withHibernate4(String sessionFactoryName, CallableWithArgs<R> callable) {
        if (GriffonNameUtils.isBlank((String)sessionFactoryName)) {
            sessionFactoryName = DEFAULT;
        }
        if (callable != null) {
            SessionFactory sf = this.getSessionFactory(sessionFactoryName);
            if (LOG.isDebugEnabled()) {
                LOG.debug("Executing statements on session '" + sessionFactoryName + "'");
            }
            Session session = sf.openSession();
            try {
                session.beginTransaction();
                Object object = callable.call(new Object[]{sessionFactoryName, session});
                return (R)object;
            }
            finally {
                if (!session.getTransaction().wasRolledBack()) {
                    session.getTransaction().commit();
                }
                session.close();
            }
        }
        return null;
    }

    protected abstract SessionFactory getSessionFactory(String var1);
}

