/*
 * Decompiled with CFR 0.152.
 */
package griffon.plugins.hibernate4.internal;

import griffon.plugins.hibernate4.internal.DatabaseMetaDataCallback;
import griffon.plugins.hibernate4.internal.HibernateConfigurationHelper;
import griffon.plugins.hibernate4.internal.exceptions.MetaDataAccessException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import javax.sql.DataSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class JdbcUtils {
    private static final Logger LOG = LoggerFactory.getLogger(HibernateConfigurationHelper.class);

    public static void closeConnection(Connection con) {
        block5: {
            if (con != null) {
                try {
                    con.close();
                }
                catch (SQLException ex) {
                    if (LOG.isTraceEnabled()) {
                        LOG.debug("Could not close JDBC Connection", (Throwable)ex);
                    }
                }
                catch (Throwable ex) {
                    if (!LOG.isTraceEnabled()) break block5;
                    LOG.debug("Unexpected exception on closing JDBC Connection", ex);
                }
            }
        }
    }

    public static void closeStatement(Statement stmt) {
        block5: {
            if (stmt != null) {
                try {
                    stmt.close();
                }
                catch (SQLException ex) {
                    if (LOG.isTraceEnabled()) {
                        LOG.trace("Could not close JDBC Statement", (Throwable)ex);
                    }
                }
                catch (Throwable ex) {
                    if (!LOG.isTraceEnabled()) break block5;
                    LOG.trace("Unexpected exception on closing JDBC Statement", ex);
                }
            }
        }
    }

    public static void closeResultSet(ResultSet rs) {
        block5: {
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (SQLException ex) {
                    if (LOG.isTraceEnabled()) {
                        LOG.trace("Could not close JDBC ResultSet", (Throwable)ex);
                    }
                }
                catch (Throwable ex) {
                    if (!LOG.isTraceEnabled()) break block5;
                    LOG.trace("Unexpected exception on closing JDBC ResultSet", ex);
                }
            }
        }
    }

    public static Object extractDatabaseMetaData(DataSource dataSource, DatabaseMetaDataCallback action) throws MetaDataAccessException {
        Connection con = null;
        try {
            con = dataSource.getConnection();
            if (con == null) {
                throw new MetaDataAccessException("Connection returned by DataSource [" + dataSource + "] was null");
            }
            DatabaseMetaData metaData = con.getMetaData();
            if (metaData == null) {
                throw new MetaDataAccessException("DatabaseMetaData returned by Connection [" + con + "] was null");
            }
            Object object = action.processMetaData(metaData);
            return object;
        }
        catch (SQLException ex) {
            throw new MetaDataAccessException("Error while extracting DatabaseMetaData", ex);
        }
        catch (AbstractMethodError err) {
            throw new MetaDataAccessException("JDBC DatabaseMetaData method not implemented by JDBC driver - upgrade your driver", err);
        }
        finally {
            JdbcUtils.closeConnection(con);
        }
    }

    public static Object extractDatabaseMetaData(DataSource dataSource, final String metaDataMethodName) throws MetaDataAccessException {
        return JdbcUtils.extractDatabaseMetaData(dataSource, new DatabaseMetaDataCallback(){

            @Override
            public Object processMetaData(DatabaseMetaData dbmd) throws SQLException, MetaDataAccessException {
                try {
                    Method method = DatabaseMetaData.class.getMethod(metaDataMethodName, null);
                    return method.invoke((Object)dbmd, (Object[])null);
                }
                catch (NoSuchMethodException ex) {
                    throw new MetaDataAccessException("No method named '" + metaDataMethodName + "' found on DatabaseMetaData instance [" + dbmd + "]", ex);
                }
                catch (IllegalAccessException ex) {
                    throw new MetaDataAccessException("Could not access DatabaseMetaData method '" + metaDataMethodName + "'", ex);
                }
                catch (InvocationTargetException ex) {
                    if (ex.getTargetException() instanceof SQLException) {
                        throw (SQLException)ex.getTargetException();
                    }
                    throw new MetaDataAccessException("Invocation of DatabaseMetaData method '" + metaDataMethodName + "' failed", ex);
                }
            }
        });
    }
}

