/*
 * Decompiled with CFR 0.152.
 */
package griffon.plugins.hibernate3.internal;

import griffon.core.GriffonApplication;
import griffon.plugins.hibernate3.internal.JdbcUtils;
import griffon.plugins.hibernate3.internal.exceptions.DatabaseException;
import griffon.util.ApplicationHolder;
import griffon.util.GriffonNameUtils;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Properties;
import javax.sql.DataSource;
import org.hibernate.dialect.Dialect;
import org.hibernate.dialect.resolver.DialectFactory;

public class DialectDetector {
    private final DataSource dataSource;

    public DialectDetector(DataSource dataSource) {
        this.dataSource = dataSource;
    }

    public String getDialect() {
        String string;
        Connection connection = null;
        try {
            String dbName = (String)JdbcUtils.extractDatabaseMetaData(this.dataSource, "getDatabaseProductName");
            connection = this.dataSource.getConnection();
            GriffonApplication application = ApplicationHolder.getApplication();
            Dialect hibernateDialect = DialectFactory.buildDialect((Properties)application.getConfig().toProperties(), (Connection)connection);
            String hibernateDialectClassName = hibernateDialect.getClass().getName();
            if (GriffonNameUtils.isBlank((String)hibernateDialectClassName)) {
                throw new DatabaseException("Could not determine Hibernate dialect for database name [" + dbName + "]!");
            }
            string = hibernateDialectClassName;
        }
        catch (SQLException e) {
            try {
                throw new DatabaseException(e);
            }
            catch (Throwable throwable) {
                JdbcUtils.closeConnection(connection);
                throw throwable;
            }
        }
        JdbcUtils.closeConnection(connection);
        return string;
    }
}

