/*
 * Decompiled with CFR 0.152.
 */
package griffon.plugins.hibernate3.internal;

import griffon.plugins.hibernate3.internal.HibernateConfigurationHelper;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Properties;
import javax.sql.DataSource;
import org.hibernate.HibernateException;
import org.hibernate.connection.ConnectionProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DataSourceConnectionProvider
implements ConnectionProvider {
    private static final Logger LOG = LoggerFactory.getLogger(DataSourceConnectionProvider.class);
    private DataSource dataSource;

    public DataSource getDataSource() {
        if (null == this.dataSource) {
            this.dataSource = HibernateConfigurationHelper.getDataSource();
        }
        return this.dataSource;
    }

    public void configure(Properties properties) throws HibernateException {
        this.dataSource = HibernateConfigurationHelper.getDataSource();
    }

    public Connection getConnection() throws SQLException {
        try {
            return this.getDataSource().getConnection();
        }
        catch (SQLException ex) {
            this.logExceptions(ex);
            throw ex;
        }
    }

    public void closeConnection(Connection connection) throws SQLException {
        try {
            connection.close();
        }
        catch (SQLException ex) {
            this.logExceptions(ex);
            throw ex;
        }
    }

    public void close() throws HibernateException {
    }

    public boolean supportsAggressiveRelease() {
        return true;
    }

    private void logExceptions(Exception x) {
        if (LOG.isWarnEnabled()) {
            LOG.warn(x.getMessage(), (Throwable)x);
        }
    }
}

