/*
 * Decompiled with CFR 0.152.
 */
package griffon.plugins.hibernate3.internal;

import griffon.plugins.hibernate3.internal.DataSourceConnectionProvider;
import griffon.plugins.hibernate3.internal.DialectDetector;
import griffon.util.ConfigUtils;
import griffon.util.GriffonNameUtils;
import griffon.util.RunnableWithArgs;
import griffon.util.RunnableWithArgsClosure;
import groovy.lang.Closure;
import groovy.util.ConfigObject;
import java.io.IOException;
import java.net.URL;
import java.util.Enumeration;
import java.util.Map;
import java.util.Properties;
import javax.sql.DataSource;
import org.codehaus.groovy.runtime.DefaultGroovyMethods;
import org.hibernate.HibernateException;
import org.hibernate.Interceptor;
import org.hibernate.cfg.Configuration;
import org.hibernate.cfg.NamingStrategy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HibernateConfigurationHelper {
    private static final Logger LOG = LoggerFactory.getLogger(HibernateConfigurationHelper.class);
    public static final String ENTITY_INTERCEPTOR = "entityInterceptor";
    public static final String NAMING_STRATEGY = "namingStrategy";
    public static final String PROPS = "props";
    private static final ThreadLocal<DataSource> dataSourceHolder = new ThreadLocal();
    private final ConfigObject sessionConfig;
    private final ConfigObject dataSourceConfig;
    private final String dataSourceName;
    private final DataSource dataSource;

    public HibernateConfigurationHelper(ConfigObject sessionConfig, ConfigObject dataSourceConfig, String dataSourceName, DataSource dataSource) {
        this.sessionConfig = sessionConfig;
        this.dataSourceConfig = dataSourceConfig;
        this.dataSourceName = dataSourceName;
        this.dataSource = dataSource;
    }

    public static DataSource getDataSource() {
        return dataSourceHolder.get();
    }

    public String getDataSourceName() {
        return this.dataSourceName;
    }

    public ConfigObject getSessionConfig() {
        return this.sessionConfig;
    }

    public ConfigObject getDataSourceConfig() {
        return this.dataSourceConfig;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Configuration buildConfiguration() throws Exception {
        Configuration config = this.newConfiguration();
        dataSourceHolder.set(this.dataSource);
        try {
            this.applyEntityInterceptor(config);
            this.applyNamingStrategy(config);
            this.applyProperties(config);
            this.applyDialect(config);
            this.applyMappings(config);
            Class<DataSourceConnectionProvider> providerClass = DataSourceConnectionProvider.class;
            config.setProperty("hibernate.connection.provider_class", providerClass.getName());
            Configuration configuration = config;
            return configuration;
        }
        finally {
            if (this.dataSource != null) {
                // empty if block
            }
        }
    }

    private void applyEntityInterceptor(Configuration config) {
        Object entityInterceptor = ConfigUtils.getConfigValue((Map)this.sessionConfig, (String)ENTITY_INTERCEPTOR);
        if (entityInterceptor instanceof Class) {
            config.setInterceptor((Interceptor)this.newInstanceOf((Class)entityInterceptor));
        } else if (entityInterceptor instanceof String) {
            config.setInterceptor((Interceptor)this.newInstanceOf((String)entityInterceptor));
        }
    }

    private void applyNamingStrategy(Configuration config) {
        Object namingStrategy = ConfigUtils.getConfigValue((Map)this.sessionConfig, (String)NAMING_STRATEGY);
        if (namingStrategy instanceof Class) {
            config.setNamingStrategy((NamingStrategy)this.newInstanceOf((Class)namingStrategy));
        } else if (namingStrategy instanceof String) {
            config.setNamingStrategy((NamingStrategy)this.newInstanceOf((String)namingStrategy));
        }
    }

    private void applyProperties(Configuration config) {
        Object props = ConfigUtils.getConfigValue((Map)this.sessionConfig, (String)PROPS);
        if (props instanceof Properties) {
            config.setProperties((Properties)props);
        } else if (props instanceof Map) {
            for (Map.Entry entry : ((Map)props).entrySet()) {
                config.setProperty((String)entry.getKey(), (String)entry.getValue());
            }
        }
        if (ConfigUtils.getConfigValueAsBoolean((Map)this.sessionConfig, (String)"logSql")) {
            config.setProperty("hibernate.show_sql", "true");
        }
        if (ConfigUtils.getConfigValueAsBoolean((Map)this.sessionConfig, (String)"formatSql")) {
            config.setProperty("hibernate.format_sql", "true");
        }
    }

    private void applyDialect(Configuration config) {
        Object dialect = ConfigUtils.getConfigValue((Map)this.sessionConfig, (String)"dialect");
        if (dialect instanceof Class) {
            config.setProperty("hibernate.dialect", ((Class)dialect).getName());
        } else if (dialect != null) {
            config.setProperty("hibernate.dialect", dialect.toString());
        } else {
            DialectDetector dialectDetector = new DialectDetector(this.dataSource);
            config.setProperty("hibernate.dialect", dialectDetector.getDialect());
        }
    }

    private void applyMappings(final Configuration config) {
        try {
            Enumeration<URL> urls = this.getClass().getClassLoader().getResources("META-INF/hibernate3/mappings.txt");
            while (urls.hasMoreElements()) {
                DefaultGroovyMethods.eachLine((URL)urls.nextElement(), (Closure)new RunnableWithArgsClosure(new RunnableWithArgs(){

                    public void run(Object[] args) {
                        String line = ((String)args[0]).trim();
                        if (GriffonNameUtils.isBlank((String)line)) {
                            return;
                        }
                        config.addResource(line);
                    }
                }));
            }
        }
        catch (IOException e) {
            throw new IllegalArgumentException(e);
        }
    }

    private Object newInstanceOf(String className) {
        try {
            return this.newInstanceOf(Thread.currentThread().getContextClassLoader().loadClass(className));
        }
        catch (ClassNotFoundException e) {
            throw new IllegalArgumentException("Cannot instantiate class " + className, e);
        }
    }

    private Object newInstanceOf(Class klass) {
        try {
            return klass.newInstance();
        }
        catch (InstantiationException e) {
            throw new IllegalArgumentException("Cannot instantiate " + klass, e);
        }
        catch (IllegalAccessException e) {
            throw new IllegalArgumentException("Cannot instantiate " + klass, e);
        }
    }

    private Configuration newConfiguration() throws HibernateException {
        return new Configuration();
    }
}

