/*
 * Decompiled with CFR 0.152.
 */
package griffon.plugins.hibernate3.internal;

import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Properties;
import org.hibernate.FlushMode;
import org.hibernate.SessionFactory;
import org.hibernate.cfg.Configuration;
import org.hibernate.classic.Session;
import org.hibernate.dialect.Dialect;
import org.hibernate.tool.hbm2ddl.DatabaseMetadata;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HibernateSchemaHelper {
    private static final Logger LOG = LoggerFactory.getLogger(HibernateSchemaHelper.class);
    private final Configuration configuration;
    private final SessionFactory sessionFactory;

    public Configuration getConfiguration() {
        return this.configuration;
    }

    public SessionFactory getSessionFactory() {
        return this.sessionFactory;
    }

    public HibernateSchemaHelper(Configuration configuration, SessionFactory sessionFactory) {
        this.configuration = configuration;
        this.sessionFactory = sessionFactory;
    }

    public void dropDatabaseSchema() {
        if (LOG.isDebugEnabled()) {
            LOG.info("Dropping database schema for Hibernate SessionFactory");
        }
        this.execute(new HibernateCallback(){

            @Override
            public void doInSession(org.hibernate.Session session) throws SQLException {
                Connection con = session.connection();
                Dialect dialect = Dialect.getDialect((Properties)HibernateSchemaHelper.this.getConfiguration().getProperties());
                String[] sql = HibernateSchemaHelper.this.getConfiguration().generateDropSchemaScript(dialect);
                HibernateSchemaHelper.this.executeSchemaScript(con, sql);
            }
        });
    }

    public void createDatabaseSchema() {
        if (LOG.isDebugEnabled()) {
            LOG.info("Creating database schema for Hibernate SessionFactory");
        }
        this.execute(new HibernateCallback(){

            @Override
            public void doInSession(org.hibernate.Session session) throws SQLException {
                Connection con = session.connection();
                Dialect dialect = Dialect.getDialect((Properties)HibernateSchemaHelper.this.getConfiguration().getProperties());
                String[] sql = HibernateSchemaHelper.this.getConfiguration().generateSchemaCreationScript(dialect);
                HibernateSchemaHelper.this.executeSchemaScript(con, sql);
            }
        });
    }

    public void updateDatabaseSchema() {
        if (LOG.isDebugEnabled()) {
            LOG.info("Updating database schema for Hibernate SessionFactory");
        }
        this.execute(new HibernateCallback(){

            @Override
            public void doInSession(org.hibernate.Session session) throws SQLException {
                session.setFlushMode(FlushMode.AUTO);
                Connection con = session.connection();
                Dialect dialect = Dialect.getDialect((Properties)HibernateSchemaHelper.this.getConfiguration().getProperties());
                DatabaseMetadata metadata = new DatabaseMetadata(con, dialect);
                String[] sql = HibernateSchemaHelper.this.getConfiguration().generateSchemaUpdateScript(dialect, metadata);
                HibernateSchemaHelper.this.executeSchemaScript(con, sql);
            }
        });
    }

    private void execute(HibernateCallback callback) {
        Session session = this.sessionFactory.getCurrentSession();
        try {
            callback.doInSession((org.hibernate.Session)session);
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
        finally {
            session.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void executeSchemaScript(Connection con, String[] sql) throws SQLException {
        if (sql != null && sql.length > 0) {
            boolean oldAutoCommit = con.getAutoCommit();
            if (!oldAutoCommit) {
                con.setAutoCommit(true);
            }
            try {
                Statement stmt = con.createStatement();
                try {
                    for (String sqlStmt : sql) {
                        this.executeSchemaStatement(stmt, sqlStmt);
                    }
                }
                finally {
                    this.closeStatement(stmt);
                }
            }
            finally {
                if (!oldAutoCommit) {
                    con.setAutoCommit(false);
                }
            }
        }
    }

    private void executeSchemaStatement(Statement stmt, String sql) throws SQLException {
        block3: {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Executing schema statement: " + sql);
            }
            try {
                stmt.executeUpdate(sql);
            }
            catch (SQLException ex) {
                if (!LOG.isWarnEnabled()) break block3;
                LOG.warn("Unsuccessful schema statement: " + sql, (Throwable)ex);
            }
        }
    }

    private void closeStatement(Statement stmt) {
        block5: {
            if (stmt != null) {
                try {
                    stmt.close();
                }
                catch (SQLException ex) {
                    if (LOG.isTraceEnabled()) {
                        LOG.trace("Could not close JDBC Statement", (Throwable)ex);
                    }
                }
                catch (Throwable ex) {
                    if (!LOG.isTraceEnabled()) break block5;
                    LOG.trace("Unexpected exception on closing JDBC Statement", ex);
                }
            }
        }
    }

    public static interface HibernateCallback {
        public void doInSession(org.hibernate.Session var1) throws SQLException;
    }
}

