/*
 * Decompiled with CFR 0.152.
 */
package lombok.eclipse.handlers;

import griffon.plugins.hessian.HessianAware;
import lombok.core.AnnotationValues;
import lombok.core.handlers.HessianAwareHandler;
import lombok.core.util.ErrorMessages;
import lombok.eclipse.EclipseAnnotationHandler;
import lombok.eclipse.EclipseNode;
import lombok.eclipse.handlers.EclipseUtil;
import lombok.eclipse.handlers.ast.EclipseType;
import org.eclipse.jdt.internal.compiler.ast.ASTNode;
import org.eclipse.jdt.internal.compiler.ast.Annotation;
import org.eclipse.jdt.internal.compiler.ast.TypeDeclaration;

public class HandleHessianAware
extends EclipseAnnotationHandler<HessianAware> {
    private final EclipseHessianAwareHandler handler = new EclipseHessianAwareHandler();

    public void handle(AnnotationValues<HessianAware> annotation, Annotation source, EclipseNode annotationNode) {
        EclipseType type = EclipseType.typeOf((EclipseNode)annotationNode, (ASTNode)source);
        if (type.isAnnotation() || type.isInterface()) {
            annotationNode.addError(ErrorMessages.canBeUsedOnClassAndEnumOnly(HessianAware.class));
            return;
        }
        EclipseUtil.addInterface((TypeDeclaration)type.get(), (String)"griffon.plugins.hessian.HessianContributionHandler", (Annotation)source);
        this.handler.addHessianProviderField(type);
        this.handler.addHessianProviderAccessors(type);
        this.handler.addHessianContributionMethods(type);
        type.editor().rebuild();
    }

    private static class EclipseHessianAwareHandler
    extends HessianAwareHandler<EclipseType> {
        private EclipseHessianAwareHandler() {
        }
    }
}

