/*
 * Decompiled with CFR 0.152.
 */
package griffon.plugins.hbase;

import griffon.exceptions.GriffonException;
import griffon.plugins.hbase.HBaseProvider;
import griffon.util.CallableWithArgs;
import griffon.util.GriffonNameUtils;
import groovy.lang.Closure;
import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.client.HTable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractHBaseProvider
implements HBaseProvider {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractHBaseProvider.class);
    private static final String DEFAULT = "default";

    @Override
    public <R> R withHBase(Closure<R> closure) {
        return this.withHBase(DEFAULT, closure);
    }

    @Override
    public <R> R withHBase(String configName, Closure<R> closure) {
        if (GriffonNameUtils.isBlank((String)configName)) {
            configName = DEFAULT;
        }
        if (closure != null) {
            Configuration configuration = this.getConfiguration(configName);
            if (LOG.isDebugEnabled()) {
                LOG.debug("Executing statement on '" + configName + "'");
            }
            return (R)closure.call(new Object[]{configName, configuration});
        }
        return null;
    }

    @Override
    public <R> R withHBase(CallableWithArgs<R> callable) {
        return this.withHBase(DEFAULT, callable);
    }

    @Override
    public <R> R withHBase(String configName, CallableWithArgs<R> callable) {
        if (GriffonNameUtils.isBlank((String)configName)) {
            configName = DEFAULT;
        }
        if (callable != null) {
            Configuration configuration = this.getConfiguration(configName);
            if (LOG.isDebugEnabled()) {
                LOG.debug("Executing statement on '" + configName + "'");
            }
            callable.setArgs(new Object[]{configName, configuration});
            return (R)callable.call();
        }
        return null;
    }

    @Override
    public <R> R withHTable(String tableName, Closure<R> closure) {
        return this.withHTable(DEFAULT, tableName, closure);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public <R> R withHTable(String configName, String tableName, Closure<R> closure) {
        if (GriffonNameUtils.isBlank((String)configName)) {
            configName = DEFAULT;
        }
        if (closure == null) return null;
        Configuration configuration = this.getConfiguration(configName);
        try {
            HTable table = new HTable(configuration, tableName);
            if (LOG.isDebugEnabled()) {
                LOG.debug("Executing statement on '" + configName + "' and table '" + tableName + "'");
            }
            try {
                Object object = closure.call(new Object[]{configName, configuration, tableName, table});
                return (R)object;
            }
            finally {
                table.close();
            }
        }
        catch (IOException ioe) {
            throw new GriffonException((Throwable)ioe);
        }
    }

    public <R> R withHTable(String tableName, CallableWithArgs<R> callable) {
        return this.withHTable(DEFAULT, tableName, callable);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public <R> R withHTable(String configName, String tableName, CallableWithArgs<R> callable) {
        if (GriffonNameUtils.isBlank((String)configName)) {
            configName = DEFAULT;
        }
        if (callable == null) return null;
        Configuration configuration = this.getConfiguration(configName);
        try {
            HTable table = new HTable(configuration, tableName);
            if (LOG.isDebugEnabled()) {
                LOG.debug("Executing statement on '" + configName + "' and table '" + tableName + "'");
            }
            try {
                callable.setArgs(new Object[]{configName, configuration, tableName, table});
                Object object = callable.call();
                return (R)object;
            }
            finally {
                table.close();
            }
        }
        catch (IOException ioe) {
            throw new GriffonException((Throwable)ioe);
        }
    }

    protected abstract Configuration getConfiguration(String var1);
}

