/*
 * Decompiled with CFR 0.152.
 */
package griffon.plugins.hazelcast;

import com.hazelcast.client.HazelcastClient;
import griffon.plugins.hazelcast.HazelcastProvider;
import griffon.util.CallableWithArgs;
import griffon.util.GriffonNameUtils;
import groovy.lang.Closure;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractHazelcastProvider
implements HazelcastProvider {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractHazelcastProvider.class);
    private static final String DEFAULT = "default";

    @Override
    public <R> R withHazelcast(Closure<R> closure) {
        return this.withHazelcast(DEFAULT, closure);
    }

    @Override
    public <R> R withHazelcast(String clientName, Closure<R> closure) {
        if (GriffonNameUtils.isBlank((String)clientName)) {
            clientName = DEFAULT;
        }
        if (closure != null) {
            HazelcastClient client = this.getHazelcastClient(clientName);
            if (LOG.isDebugEnabled()) {
                LOG.debug("Executing statement on clientName '" + clientName + "'");
            }
            return (R)closure.call(new Object[]{clientName, client});
        }
        return null;
    }

    @Override
    public <R> R withHazelcast(CallableWithArgs<R> callable) {
        return this.withHazelcast(DEFAULT, callable);
    }

    @Override
    public <R> R withHazelcast(String clientName, CallableWithArgs<R> callable) {
        if (GriffonNameUtils.isBlank((String)clientName)) {
            clientName = DEFAULT;
        }
        if (callable != null) {
            HazelcastClient client = this.getHazelcastClient(clientName);
            if (LOG.isDebugEnabled()) {
                LOG.debug("Executing statement on clientName '" + clientName + "'");
            }
            callable.setArgs(new Object[]{clientName, client});
            return (R)callable.call();
        }
        return null;
    }

    protected abstract HazelcastClient getHazelcastClient(String var1);
}

