/*
 * Decompiled with CFR 0.152.
 */
package eu.hansolo.custom;

import eu.hansolo.custom.SteelCheckBox;
import eu.hansolo.gradients.ConicalGradientPaint;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsEnvironment;
import java.awt.Image;
import java.awt.LinearGradientPaint;
import java.awt.Point;
import java.awt.RenderingHints;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.font.FontRenderContext;
import java.awt.font.TextLayout;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RoundRectangle2D;
import java.awt.image.BufferedImage;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JComponent;
import javax.swing.plaf.basic.BasicCheckBoxUI;

public class SteelCheckBoxUI
extends BasicCheckBoxUI
implements PropertyChangeListener,
ComponentListener,
MouseListener {
    private final SteelCheckBox CHECKBOX;
    private boolean mouseOver = false;
    private boolean mousePressed = false;
    private static final Dimension SIZE = new Dimension(26, 13);
    private BufferedImage backgroundImage;
    private BufferedImage knobStandardImage;
    private BufferedImage knobPressedImage;
    private Point pos;
    private RoundRectangle2D foreground;
    private Point2D foregroundStart;
    private Point2D foregroundStop;
    private final float[] FOREGROUND_FRACTIONS;
    private Color[] foregroundColors;
    private LinearGradientPaint foregroundGradient;

    public SteelCheckBoxUI(SteelCheckBox CHECKBOX) {
        this.backgroundImage = this.create_BACKGROUND_Image(SteelCheckBoxUI.SIZE.width);
        this.knobStandardImage = this.create_KNOB_Image(SteelCheckBoxUI.SIZE.height, false);
        this.knobPressedImage = this.create_KNOB_Image(SteelCheckBoxUI.SIZE.height, true);
        this.pos = new Point(0, 0);
        this.FOREGROUND_FRACTIONS = new float[]{0.0f, 0.03f, 0.94f, 1.0f};
        this.foregroundColors = new Color[]{new Color(241, 242, 242, 255), new Color(224, 225, 226, 255), new Color(166, 169, 171, 255), new Color(124, 124, 124, 255)};
        this.CHECKBOX = CHECKBOX;
        this.CHECKBOX.addComponentListener(this);
        this.CHECKBOX.addMouseListener(this);
        this.CHECKBOX.addPropertyChangeListener(this);
        this.init();
    }

    private void init() {
        this.foreground = new RoundRectangle2D.Double((double)this.pos.x + (double)this.backgroundImage.getWidth() * 0.03846153989434242, (double)this.pos.y + (double)this.backgroundImage.getHeight() * 0.0714285746216774, (double)this.backgroundImage.getWidth() * 0.923076868057251, (double)this.backgroundImage.getHeight() * 0.8571428060531616, (double)this.backgroundImage.getHeight() * 0.8571428571, (double)this.backgroundImage.getHeight() * 0.8571428571);
        this.foregroundStart = new Point2D.Double(this.pos.x, this.foreground.getBounds2D().getMinY());
        this.foregroundStop = new Point2D.Double(this.pos.x, this.foreground.getBounds2D().getMaxY());
        this.foregroundGradient = new LinearGradientPaint(this.foregroundStart, this.foregroundStop, this.FOREGROUND_FRACTIONS, this.foregroundColors);
    }

    @Override
    public void installUI(JComponent COMPONENT) {
        super.installUI(COMPONENT);
        this.CHECKBOX.addComponentListener(this);
    }

    @Override
    public void uninstallUI(JComponent COMPONENT) {
        super.uninstallUI(COMPONENT);
        this.CHECKBOX.removeComponentListener(this);
    }

    @Override
    public synchronized void paint(Graphics g, JComponent component) {
        Graphics2D G2 = (Graphics2D)g.create();
        G2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        this.pos.setLocation(0.0, this.foreground.getBounds2D().getMinY());
        if (!this.CHECKBOX.isEnabled()) {
            G2.setComposite(AlphaComposite.getInstance(3, 0.5f));
        }
        G2.drawImage((Image)this.backgroundImage, this.pos.x, this.pos.y, null);
        if (this.CHECKBOX.isSelected()) {
            this.foregroundColors = this.CHECKBOX.isColored() ? (this.CHECKBOX.isRised() ? new Color[]{this.CHECKBOX.getSelectedColor().LIGHT.brighter(), this.CHECKBOX.getSelectedColor().LIGHT, this.CHECKBOX.getSelectedColor().MEDIUM, this.CHECKBOX.getSelectedColor().DARK} : new Color[]{this.CHECKBOX.getSelectedColor().DARK, this.CHECKBOX.getSelectedColor().DARK, this.CHECKBOX.getSelectedColor().LIGHT, this.CHECKBOX.getSelectedColor().MEDIUM}) : new Color[]{new Color(241, 242, 242, 255), new Color(224, 225, 226, 255), new Color(166, 169, 171, 255), new Color(124, 124, 124, 255)};
            this.foregroundGradient = new LinearGradientPaint(this.foregroundStart, this.foregroundStop, this.FOREGROUND_FRACTIONS, this.foregroundColors);
            G2.setPaint(this.foregroundGradient);
            G2.fill(this.foreground);
            if (this.mouseOver && this.mousePressed) {
                G2.drawImage((Image)this.knobPressedImage, this.pos.x + this.backgroundImage.getWidth() / 2, this.pos.y, null);
            } else {
                G2.drawImage((Image)this.knobStandardImage, this.pos.x + this.backgroundImage.getWidth() / 2, this.pos.y, null);
            }
        } else if (this.mouseOver && this.mousePressed) {
            G2.drawImage((Image)this.knobPressedImage, this.pos.x, this.pos.y, null);
        } else {
            G2.drawImage((Image)this.knobStandardImage, this.pos.x, this.pos.y, null);
        }
        if (this.CHECKBOX.getText() != null) {
            G2.setColor(this.CHECKBOX.getForeground());
            G2.setFont(this.CHECKBOX.getFont());
            FontRenderContext RENDER_CONTEXT = new FontRenderContext(null, true, true);
            TextLayout TEXT_LAYOUT = new TextLayout(this.CHECKBOX.getText(), G2.getFont(), RENDER_CONTEXT);
            Rectangle2D BOUNDS = TEXT_LAYOUT.getBounds();
            G2.drawString(this.CHECKBOX.getText(), this.backgroundImage.getWidth() + 5, (this.CHECKBOX.getBounds().height - BOUNDS.getBounds().height) / 2 + BOUNDS.getBounds().height);
        }
        G2.dispose();
    }

    private BufferedImage create_KNOB_Image(int WIDTH, boolean PRESSED) {
        if (WIDTH <= 0) {
            return null;
        }
        GraphicsConfiguration GFX_CONF = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getDefaultConfiguration();
        BufferedImage IMAGE = GFX_CONF.createCompatibleImage(WIDTH, WIDTH, 3);
        Graphics2D G2 = IMAGE.createGraphics();
        G2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        int IMAGE_WIDTH = IMAGE.getWidth();
        int IMAGE_HEIGHT = IMAGE.getHeight();
        Ellipse2D.Double KNOB_FRAME = new Ellipse2D.Double((double)IMAGE_WIDTH * 0.0, (double)IMAGE_HEIGHT * 0.0, (double)IMAGE_WIDTH * 1.0, (double)IMAGE_HEIGHT * 1.0);
        Point2D.Double KNOB_FRAME_START = new Point2D.Double(0.0, KNOB_FRAME.getBounds2D().getMinY());
        Point2D.Double KNOB_FRAME_STOP = new Point2D.Double(0.0, KNOB_FRAME.getBounds2D().getMaxY());
        float[] E_KNOB_FRAME_FRACTIONS = new float[]{0.0f, 0.25f, 0.51f, 0.76f, 1.0f};
        Color[] KNOB_FRAME_COLORS = new Color[]{new Color(90, 91, 92, 255), new Color(127, 127, 128, 255), new Color(81, 82, 83, 255), new Color(104, 105, 105, 255), new Color(63, 64, 65, 255)};
        if (KNOB_FRAME_START.distance(KNOB_FRAME_STOP) > 0.0) {
            LinearGradientPaint KNOB_FRAME_GRADIENT = new LinearGradientPaint(KNOB_FRAME_START, KNOB_FRAME_STOP, E_KNOB_FRAME_FRACTIONS, KNOB_FRAME_COLORS);
            G2.setPaint(KNOB_FRAME_GRADIENT);
            G2.fill(KNOB_FRAME);
        }
        Ellipse2D.Double KNOB = new Ellipse2D.Double((double)IMAGE_WIDTH * 0.07692307978868484, (double)IMAGE_HEIGHT * 0.07692307978868484, (double)IMAGE_WIDTH * 0.8461538553237915, (double)IMAGE_HEIGHT * 0.8461538553237915);
        Point2D.Double KNOB_CENTER = new Point2D.Double(KNOB.getCenterX(), KNOB.getCenterY());
        float[] KNOB_FRACTIONS = new float[]{0.0f, 40.0f, 90.0f, 140.0f, 220.0f, 270.0f, 320.0f};
        Color[] KNOB_COLORS = PRESSED ? new Color[]{new Color(0xC2C2C2), new Color(7501432), new Color(0xC2C2C2), new Color(7501432), new Color(0xC2C2C2), new Color(7501432), new Color(0xC2C2C2)} : new Color[]{new Color(0xF2F2F2), new Color(9409430), new Color(0xF2F2F2), new Color(9409430), new Color(0xF2F2F2), new Color(9409430), new Color(0xF2F2F2)};
        ConicalGradientPaint KNOB_GRADIENT = new ConicalGradientPaint(true, KNOB_CENTER, 0.0f, KNOB_FRACTIONS, KNOB_COLORS);
        G2.setPaint(KNOB_GRADIENT);
        G2.fill(KNOB);
        G2.dispose();
        return IMAGE;
    }

    private BufferedImage create_BACKGROUND_Image(int WIDTH) {
        if (WIDTH <= 0) {
            return null;
        }
        GraphicsConfiguration GFX_CONF = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getDefaultConfiguration();
        BufferedImage IMAGE = GFX_CONF.createCompatibleImage(WIDTH, (int)(0.5384615384615384 * (double)WIDTH), 3);
        Graphics2D G2 = IMAGE.createGraphics();
        G2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        G2.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        G2.setRenderingHint(RenderingHints.KEY_DITHERING, RenderingHints.VALUE_DITHER_ENABLE);
        G2.setRenderingHint(RenderingHints.KEY_ALPHA_INTERPOLATION, RenderingHints.VALUE_ALPHA_INTERPOLATION_QUALITY);
        G2.setRenderingHint(RenderingHints.KEY_COLOR_RENDERING, RenderingHints.VALUE_COLOR_RENDER_QUALITY);
        G2.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_PURE);
        int IMAGE_WIDTH = IMAGE.getWidth();
        int IMAGE_HEIGHT = IMAGE.getHeight();
        RoundRectangle2D.Double BACKGROUND_FRAME = new RoundRectangle2D.Double((double)IMAGE_WIDTH * 0.0, (double)IMAGE_HEIGHT * 0.0, (double)IMAGE_WIDTH * 1.0, (double)IMAGE_HEIGHT * 1.0, IMAGE_HEIGHT, IMAGE_HEIGHT);
        Point2D.Double BACKGROUND_FRAME_START = new Point2D.Double(0.0, BACKGROUND_FRAME.getBounds2D().getMinY());
        Point2D.Double BACKGROUND_FRAME_STOP = new Point2D.Double(0.0, BACKGROUND_FRAME.getBounds2D().getMaxY());
        float[] BACKGROUND_FRAME_FRACTIONS = new float[]{0.0f, 0.51f, 1.0f};
        Color[] BACKGROUND_FRAME_COLORS = new Color[]{new Color(68, 68, 68, 255), new Color(105, 105, 106, 255), new Color(216, 217, 218, 255)};
        LinearGradientPaint BACKGROUND_FRAME_GRADIENT = new LinearGradientPaint(BACKGROUND_FRAME_START, BACKGROUND_FRAME_STOP, BACKGROUND_FRAME_FRACTIONS, BACKGROUND_FRAME_COLORS);
        G2.setPaint(BACKGROUND_FRAME_GRADIENT);
        G2.fill(BACKGROUND_FRAME);
        RoundRectangle2D.Double BACKGROUND = new RoundRectangle2D.Double((double)IMAGE_WIDTH * 0.03846153989434242, (double)IMAGE_HEIGHT * 0.0714285746216774, (double)IMAGE_WIDTH * 0.923076868057251, (double)IMAGE_HEIGHT * 0.8571428060531616, IMAGE_HEIGHT, IMAGE_HEIGHT);
        Point2D.Double BACKGROUND_START = new Point2D.Double(0.0, BACKGROUND.getBounds2D().getMinY());
        Point2D.Double BACKGROUND_STOP = new Point2D.Double(0.0, BACKGROUND.getBounds2D().getMaxY());
        float[] BACKGROUND_FRACTIONS = new float[]{0.0f, 0.96f, 1.0f};
        Color[] BACKGROUND_COLORS = new Color[]{new Color(91, 91, 91, 255), new Color(138, 138, 138, 255), new Color(124, 124, 124, 255)};
        if (BACKGROUND_START.distance(BACKGROUND_STOP) > 0.0) {
            LinearGradientPaint BACKGROUND_GRADIENT = new LinearGradientPaint(BACKGROUND_START, BACKGROUND_STOP, BACKGROUND_FRACTIONS, BACKGROUND_COLORS);
            G2.setPaint(BACKGROUND_GRADIENT);
            G2.fill(BACKGROUND);
        }
        G2.dispose();
        return IMAGE;
    }

    public Point2D getCenteredTextPosition(Graphics2D G2, Rectangle2D BOUNDARY, Font FONT, String TEXT, int ORIENTATION) {
        double TEXT_Y;
        double TEXT_X;
        double CENTER_X = BOUNDARY.getWidth() / 2.0;
        double CENTER_Y = BOUNDARY.getHeight() / 2.0;
        FontRenderContext RENDER_CONTEXT = G2.getFontRenderContext();
        TextLayout LAYOUT = new TextLayout(TEXT, FONT, RENDER_CONTEXT);
        Rectangle2D TEXT_BOUNDARY = LAYOUT.getBounds();
        switch (ORIENTATION) {
            case 0: {
                TEXT_X = CENTER_X - TEXT_BOUNDARY.getWidth() / 2.0;
                TEXT_Y = CENTER_Y - TEXT_BOUNDARY.getHeight() / 2.0 + TEXT_BOUNDARY.getHeight();
                break;
            }
            case 2: {
                TEXT_X = BOUNDARY.getMinX();
                TEXT_Y = CENTER_Y - TEXT_BOUNDARY.getHeight() / 2.0 + TEXT_BOUNDARY.getHeight();
                break;
            }
            case 4: {
                TEXT_X = BOUNDARY.getMaxX() - TEXT_BOUNDARY.getWidth();
                TEXT_Y = CENTER_Y - TEXT_BOUNDARY.getHeight() / 2.0 + TEXT_BOUNDARY.getHeight();
                break;
            }
            default: {
                TEXT_X = CENTER_X - TEXT_BOUNDARY.getWidth() / 2.0;
                TEXT_Y = CENTER_Y - TEXT_BOUNDARY.getHeight() / 2.0 + TEXT_BOUNDARY.getHeight();
            }
        }
        return new Point2D.Double(TEXT_X, TEXT_Y);
    }

    @Override
    public void mouseClicked(MouseEvent event) {
        this.mousePressed = false;
        this.CHECKBOX.repaint();
    }

    @Override
    public void mousePressed(MouseEvent event) {
        this.mousePressed = true;
        this.CHECKBOX.repaint();
    }

    @Override
    public void mouseReleased(MouseEvent event) {
        this.mousePressed = false;
        this.CHECKBOX.repaint();
    }

    @Override
    public void mouseEntered(MouseEvent event) {
        this.mouseOver = true;
        this.CHECKBOX.repaint();
    }

    @Override
    public void mouseExited(MouseEvent event) {
        this.mouseOver = false;
        this.CHECKBOX.repaint();
    }

    @Override
    public void componentResized(ComponentEvent EVENT) {
        this.init();
        this.pos.setLocation(0.0, (double)(EVENT.getComponent().getHeight() - SteelCheckBoxUI.SIZE.height) / 2.0);
    }

    @Override
    public void componentMoved(ComponentEvent EVENT) {
    }

    @Override
    public void componentShown(ComponentEvent EVENT) {
    }

    @Override
    public void componentHidden(ComponentEvent EVENT) {
    }

    @Override
    public void propertyChange(PropertyChangeEvent EVENT) {
        this.init();
        this.CHECKBOX.repaint();
    }

    public String toString() {
        return "SteelCheckBoxUI";
    }
}

