/*
 * Decompiled with CFR 0.152.
 */
package eu.hansolo.custom;

import eu.hansolo.gradients.GradientWrapper;
import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsEnvironment;
import java.awt.Image;
import java.awt.Insets;
import java.awt.LinearGradientPaint;
import java.awt.Paint;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.font.TextAttribute;
import java.awt.font.TextLayout;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;
import java.awt.geom.Point2D;
import java.awt.image.BufferedImage;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.text.AttributedString;
import javax.swing.JComponent;

public class Score
extends JComponent {
    private PropertyChangeSupport propertySupport;
    private final Rectangle INNER_BOUNDS = new Rectangle(0, 0, 141, 51);
    private int horizontalAlignment;
    private int verticalAlignment;
    private int noOfArrows = 5;
    private int score = 0;
    private boolean textVisible = true;
    private Color textColor;
    private BufferedImage off_Image;
    private BufferedImage on_Image;
    private ColorDirection colorDirection;
    private final transient ComponentListener COMPONENT_LISTENER = new ComponentAdapter(){

        @Override
        public void componentResized(ComponentEvent event) {
            int SIZE = Score.this.getWidth() <= Score.this.getHeight() ? Score.this.getWidth() : Score.this.getHeight();
            Container parent = Score.this.getParent();
            if (parent != null && parent.getLayout() == null) {
                if (SIZE < Score.this.getMinimumSize().width || SIZE < Score.this.getMinimumSize().height) {
                    Score.this.setSize(Score.this.getMinimumSize());
                } else {
                    Score.this.setSize(Score.this.getWidth(), Score.this.getHeight());
                }
            } else if (SIZE < Score.this.getMinimumSize().width || SIZE < Score.this.getMinimumSize().height) {
                Score.this.setPreferredSize(Score.this.getMinimumSize());
            } else {
                Score.this.setPreferredSize(new Dimension(Score.this.getWidth(), Score.this.getHeight()));
            }
            Score.this.calcInnerBounds();
            Score.this.init(((Score)Score.this).INNER_BOUNDS.width, ((Score)Score.this).INNER_BOUNDS.height);
        }
    };

    public Score() {
        this.propertySupport = new PropertyChangeSupport(this);
        this.textColor = Color.BLACK;
        this.off_Image = this.createImage(this.INNER_BOUNDS.width, this.INNER_BOUNDS.height, 3);
        this.on_Image = this.createImage(this.INNER_BOUNDS.width, this.INNER_BOUNDS.height, 3);
        this.colorDirection = ColorDirection.RED_TO_GREEN;
        this.horizontalAlignment = 0;
        this.verticalAlignment = 0;
        this.addComponentListener(this.COMPONENT_LISTENER);
    }

    public final void init(int WIDTH, int HEIGHT) {
        if (WIDTH <= 1 || HEIGHT <= 1) {
            return;
        }
        if (this.off_Image != null) {
            this.off_Image.flush();
        }
        this.off_Image = this.createOffImage(WIDTH, HEIGHT);
        if (this.on_Image != null) {
            this.on_Image.flush();
        }
        this.on_Image = this.createOnImage(WIDTH, HEIGHT);
    }

    @Override
    protected void paintComponent(Graphics G) {
        Graphics2D G2 = (Graphics2D)G.create();
        G2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        G2.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        G2.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        G2.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_NORMALIZE);
        G2.translate(this.INNER_BOUNDS.x, this.INNER_BOUNDS.y);
        G2.drawImage((Image)this.off_Image, 0, 0, null);
        G2.drawImage((Image)this.on_Image, 0, 0, null);
        G2.dispose();
    }

    public int getNoOfArrows() {
        return this.noOfArrows;
    }

    public void setNoOfArrows(int NO_OF_ARROWS) {
        this.noOfArrows = NO_OF_ARROWS < 3 ? 3 : (NO_OF_ARROWS > 10 ? 10 : NO_OF_ARROWS);
        this.init(this.INNER_BOUNDS.width, this.INNER_BOUNDS.height);
        this.repaint(this.INNER_BOUNDS);
    }

    public int getScore() {
        return this.score;
    }

    public void setScore(int SCORE) {
        this.score = SCORE < 0 ? 0 : (SCORE > this.noOfArrows ? this.noOfArrows : SCORE);
        this.init(this.INNER_BOUNDS.width, this.INNER_BOUNDS.height);
        this.repaint(this.INNER_BOUNDS);
    }

    public boolean isTextVisible() {
        return this.textVisible;
    }

    public void setTextVisible(boolean TEXT_VISIBLE) {
        this.textVisible = TEXT_VISIBLE;
        this.init(this.INNER_BOUNDS.width, this.INNER_BOUNDS.height);
        this.repaint(this.INNER_BOUNDS);
    }

    public Color getTextColor() {
        return this.textColor;
    }

    public void setTextColor(Color TEXT_COLOR) {
        this.textColor = TEXT_COLOR;
        this.init(this.INNER_BOUNDS.width, this.INNER_BOUNDS.height);
        this.repaint(this.INNER_BOUNDS);
    }

    public ColorDirection getColorDirection() {
        return this.colorDirection;
    }

    public void setColorDirection(ColorDirection COLOR_DIRECTION) {
        this.colorDirection = COLOR_DIRECTION;
        this.init(this.INNER_BOUNDS.width, this.INNER_BOUNDS.height);
        this.repaint(this.INNER_BOUNDS);
    }

    public int getHorizontalAlignment() {
        return this.horizontalAlignment;
    }

    public void setHorizontalAlignment(int HORIZONTAL_ALIGNMENT) {
        this.horizontalAlignment = HORIZONTAL_ALIGNMENT;
    }

    public int getVerticalAlignment() {
        return this.verticalAlignment;
    }

    public void setVerticalAlignment(int VERTICAL_ALIGNMENT) {
        this.verticalAlignment = VERTICAL_ALIGNMENT;
    }

    @Override
    public void addPropertyChangeListener(PropertyChangeListener LISTENER) {
        if (this.isShowing()) {
            this.propertySupport.addPropertyChangeListener(LISTENER);
        }
    }

    @Override
    public void removePropertyChangeListener(PropertyChangeListener LISTENER) {
        this.propertySupport.removePropertyChangeListener(LISTENER);
    }

    private void calcInnerBounds() {
        Insets INSETS = this.getInsets();
        this.INNER_BOUNDS.setBounds(INSETS.left, INSETS.top, this.getWidth() - INSETS.left - INSETS.right, this.getHeight() - INSETS.top - INSETS.bottom);
    }

    public Rectangle getInnerBounds() {
        return this.INNER_BOUNDS;
    }

    @Override
    public Dimension getMinimumSize() {
        return new Dimension(141, 51);
    }

    @Override
    public void setPreferredSize(Dimension DIM) {
        super.setPreferredSize(DIM);
        this.calcInnerBounds();
        this.init(this.INNER_BOUNDS.width, this.INNER_BOUNDS.height);
    }

    @Override
    public void setSize(int WIDTH, int HEIGHT) {
        super.setSize(WIDTH, HEIGHT);
        this.calcInnerBounds();
        this.init(this.INNER_BOUNDS.width, this.INNER_BOUNDS.height);
    }

    @Override
    public void setSize(Dimension DIM) {
        super.setSize(DIM);
        this.calcInnerBounds();
        this.init(this.INNER_BOUNDS.width, this.INNER_BOUNDS.height);
    }

    @Override
    public void setBounds(Rectangle BOUNDS) {
        super.setBounds(BOUNDS);
        this.calcInnerBounds();
        this.init(this.INNER_BOUNDS.width, this.INNER_BOUNDS.height);
    }

    @Override
    public void setBounds(int X, int Y, int WIDTH, int HEIGHT) {
        super.setBounds(X, Y, WIDTH, HEIGHT);
        this.calcInnerBounds();
        this.init(this.INNER_BOUNDS.width, this.INNER_BOUNDS.height);
    }

    private BufferedImage createImage(int WIDTH, int HEIGHT, int TRANSPARENCY) {
        GraphicsConfiguration GFX_CONF = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getDefaultConfiguration();
        if (WIDTH <= 0 || HEIGHT <= 0) {
            return GFX_CONF.createCompatibleImage(1, 1, TRANSPARENCY);
        }
        BufferedImage IMAGE = GFX_CONF.createCompatibleImage(WIDTH, HEIGHT, TRANSPARENCY);
        return IMAGE;
    }

    public BufferedImage createOffImage(int WIDTH, int HEIGHT) {
        int i;
        if (WIDTH <= 0 || HEIGHT <= 0) {
            return this.createImage(1, 1, 3);
        }
        BufferedImage IMAGE = this.createImage(WIDTH, HEIGHT, 3);
        Graphics2D G2 = IMAGE.createGraphics();
        G2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        G2.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        G2.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_NORMALIZE);
        G2.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        int IMAGE_WIDTH = IMAGE.getWidth();
        int IMAGE_HEIGHT = IMAGE.getHeight();
        int FONT_SIZE = (int)(0.05 * (double)IMAGE_WIDTH);
        Font FONT = new Font("sans-serif", 0, FONT_SIZE);
        int SPACER = (int)((double)IMAGE_WIDTH * 0.04);
        int ARROW_WIDTH = IMAGE_WIDTH / this.noOfArrows + (int)((double)IMAGE_WIDTH * 0.032);
        int ARROW_HEIGHT = this.textVisible ? IMAGE_HEIGHT - FONT_SIZE : IMAGE_HEIGHT;
        for (i = this.score; i < this.noOfArrows; ++i) {
            BufferedImage arrow = this.createArrow(ARROW_WIDTH, ARROW_HEIGHT, Color.GRAY, false);
            G2.drawImage((Image)arrow, i * (ARROW_WIDTH - SPACER), 0, null);
        }
        if (this.textVisible) {
            G2.setPaint(this.textColor);
            for (i = 0; i < this.noOfArrows; ++i) {
                AttributedString TEXT = new AttributedString(Integer.toString(i + 1));
                TEXT.addAttribute(TextAttribute.FONT, FONT);
                TEXT.addAttribute(TextAttribute.WEIGHT, TextAttribute.WEIGHT_BOLD);
                G2.setFont(FONT);
                float fontOffsetY = 1.0196079f * (float)IMAGE_HEIGHT - new TextLayout(Integer.toString(i + 1), G2.getFont(), G2.getFontRenderContext()).getDescent();
                G2.drawString(TEXT.getIterator(), (float)(i * (ARROW_WIDTH - SPACER) + ARROW_WIDTH / 3), fontOffsetY);
            }
        }
        G2.dispose();
        return IMAGE;
    }

    public BufferedImage createOnImage(int WIDTH, int HEIGHT) {
        if (WIDTH <= 0 || HEIGHT <= 0) {
            return this.createImage(1, 1, 3);
        }
        BufferedImage IMAGE = this.createImage(WIDTH, HEIGHT, 3);
        Graphics2D G2 = IMAGE.createGraphics();
        G2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        G2.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        G2.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_NORMALIZE);
        G2.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        int IMAGE_WIDTH = IMAGE.getWidth();
        int IMAGE_HEIGHT = IMAGE.getHeight();
        int FONT_SIZE = (int)(0.05 * (double)IMAGE_WIDTH);
        Font FONT = new Font("sans-serif", 0, FONT_SIZE);
        int SPACER = (int)((double)IMAGE_WIDTH * 0.04);
        int ARROW_WIDTH = IMAGE_WIDTH / this.noOfArrows + (int)((double)IMAGE_WIDTH * 0.032);
        int ARROW_HEIGHT = this.textVisible ? IMAGE_HEIGHT - FONT_SIZE - (int)(0.005 * (double)IMAGE_WIDTH) : IMAGE_HEIGHT;
        float COLOR_STEP = 1.0f / (float)(this.noOfArrows - 1);
        Color[] LOOKUP_COLORS = this.colorDirection == ColorDirection.RED_TO_GREEN ? new Color[]{Color.RED, Color.YELLOW, Color.GREEN} : new Color[]{Color.GREEN, Color.YELLOW, Color.RED};
        GradientWrapper COLOR_LOOKUP = new GradientWrapper(new Point2D.Double(0.0, 0.0), new Point2D.Double(100.0, 0.0), new float[]{0.0f, 0.5f, 1.0f}, LOOKUP_COLORS);
        for (int i = 0; i < this.score; ++i) {
            BufferedImage arrow = this.createArrow(ARROW_WIDTH, ARROW_HEIGHT, COLOR_LOOKUP.getColorAt((float)i * COLOR_STEP), true);
            G2.drawImage((Image)arrow, i * (ARROW_WIDTH - SPACER), 0, null);
        }
        G2.dispose();
        return IMAGE;
    }

    public BufferedImage createArrow(int WIDTH, int HEIGHT, Color COLOR, boolean FILLED) {
        if (WIDTH <= 0 || HEIGHT <= 0) {
            return this.createImage(1, 1, 3);
        }
        BufferedImage IMAGE = this.createImage(WIDTH, HEIGHT, 3);
        Graphics2D G2 = IMAGE.createGraphics();
        G2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        G2.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        G2.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_NORMALIZE);
        G2.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        int IMAGE_WIDTH = IMAGE.getWidth();
        int IMAGE_HEIGHT = IMAGE.getHeight();
        GeneralPath ARROW = new GeneralPath();
        ARROW.setWindingRule(0);
        if (FILLED) {
            ARROW.moveTo((double)IMAGE_WIDTH, 0.5135135135135135 * (double)IMAGE_HEIGHT);
            ARROW.lineTo(0.65625 * (double)IMAGE_WIDTH, (double)IMAGE_HEIGHT);
            ARROW.lineTo(0.0, (double)IMAGE_HEIGHT);
            ARROW.lineTo(0.34375 * (double)IMAGE_WIDTH, 0.5135135135135135 * (double)IMAGE_HEIGHT);
            ARROW.lineTo(0.0, 0.0);
            ARROW.lineTo(0.65625 * (double)IMAGE_WIDTH, 0.0);
            ARROW.closePath();
        } else {
            ARROW.moveTo(0.9375 * (double)IMAGE_WIDTH, 0.5135135135135135 * (double)IMAGE_HEIGHT);
            ARROW.lineTo(0.625 * (double)IMAGE_WIDTH, 0.9459459459459459 * (double)IMAGE_HEIGHT);
            ARROW.lineTo(0.09375 * (double)IMAGE_WIDTH, 0.9459459459459459 * (double)IMAGE_HEIGHT);
            ARROW.lineTo(0.40625 * (double)IMAGE_WIDTH, 0.5135135135135135 * (double)IMAGE_HEIGHT);
            ARROW.lineTo(0.09375 * (double)IMAGE_WIDTH, 0.05405405405405406 * (double)IMAGE_HEIGHT);
            ARROW.lineTo(0.625 * (double)IMAGE_WIDTH, 0.05405405405405406 * (double)IMAGE_HEIGHT);
            ARROW.lineTo(0.9375 * (double)IMAGE_WIDTH, 0.5135135135135135 * (double)IMAGE_HEIGHT);
            ARROW.closePath();
            ARROW.moveTo((double)IMAGE_WIDTH, 0.5135135135135135 * (double)IMAGE_HEIGHT);
            ARROW.lineTo(0.65625 * (double)IMAGE_WIDTH, 0.0);
            ARROW.lineTo(0.0, 0.0);
            ARROW.lineTo(0.34375 * (double)IMAGE_WIDTH, 0.5135135135135135 * (double)IMAGE_HEIGHT);
            ARROW.lineTo(0.0, (double)IMAGE_HEIGHT);
            ARROW.lineTo(0.65625 * (double)IMAGE_WIDTH, (double)IMAGE_HEIGHT);
            ARROW.lineTo((double)IMAGE_WIDTH, 0.5135135135135135 * (double)IMAGE_HEIGHT);
            ARROW.closePath();
        }
        LinearGradientPaint ARROW_FILL = new LinearGradientPaint(new Point2D.Double(0.0, 0.0), new Point2D.Double(0.0, IMAGE_HEIGHT), new float[]{0.0f, 0.5f, 1.0f}, new Color[]{COLOR.darker().darker(), COLOR, COLOR.darker().darker()});
        G2.setPaint(ARROW_FILL);
        G2.fill(ARROW);
        this.addInnerShadow(G2, ARROW, Color.BLACK, 0, 0.65f, 4, 0);
        G2.dispose();
        return IMAGE;
    }

    public void addInnerShadow(Graphics2D G2, Shape SHAPE, Color SHADOW_COLOR, int DISTANCE, float ALPHA, int SOFTNESS, int ANGLE) {
        float COLOR_CONSTANT = 0.003921569f;
        float RED = 0.003921569f * (float)SHADOW_COLOR.getRed();
        float GREEN = 0.003921569f * (float)SHADOW_COLOR.getGreen();
        float BLUE = 0.003921569f * (float)SHADOW_COLOR.getBlue();
        float MAX_STROKE_WIDTH = SOFTNESS * 2;
        float ALPHA_STEP = 1.0f / (float)(2 * SOFTNESS + 2) * ALPHA;
        float TRANSLATE_X = (float)((double)DISTANCE * Math.cos(Math.toRadians(ANGLE)));
        float TRANSLATE_Y = (float)((double)DISTANCE * Math.sin(Math.toRadians(ANGLE)));
        G2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        Shape OLD_CLIP = G2.getClip();
        AffineTransform OLD_TRANSFORM = G2.getTransform();
        Stroke OLD_STROKE = G2.getStroke();
        Paint OLD_PAINT = G2.getPaint();
        G2.setColor(new Color(RED, GREEN, BLUE, ALPHA_STEP));
        G2.setComposite(AlphaComposite.SrcAtop);
        G2.translate(TRANSLATE_X, -TRANSLATE_Y);
        G2.setClip(SHAPE);
        for (float strokeWidth = (float)SOFTNESS; strokeWidth >= 1.0f; strokeWidth -= 1.0f) {
            G2.setStroke(new BasicStroke((float)((double)MAX_STROKE_WIDTH * Math.pow(0.85, strokeWidth))));
            G2.draw(SHAPE);
        }
        G2.setTransform(OLD_TRANSFORM);
        G2.setClip(OLD_CLIP);
        G2.setStroke(OLD_STROKE);
        G2.setPaint(OLD_PAINT);
    }

    public static enum ColorDirection {
        RED_TO_GREEN,
        GREEN_TO_RED;

    }
}

