/*
 * Decompiled with CFR 0.152.
 */
package eu.hansolo.custom;

import eu.hansolo.custom.RangeSliderUI;
import java.awt.Color;
import javax.swing.JSlider;

public class RangeSlider
extends JSlider {
    private int lowerValue;
    private int upperValue;
    private boolean rangeVisible = true;
    private boolean rangeSelectionEnabled = true;
    private ThumbShape thumbShape = ThumbShape.ROUND;
    private ThumbDesign thumbDesign = ThumbDesign.DARK;
    private TrackWidth trackWidth = TrackWidth.THIN;
    private boolean darkTrack = false;
    private Color rangeColor = new Color(51, 204, 255);

    public RangeSlider() {
        this(0, 100);
    }

    public RangeSlider(int min, int max) {
        super(min, max);
        this.setOpaque(false);
        this.setFocusTraversalKeysEnabled(true);
        this.initSlider();
    }

    private void initSlider() {
        this.setOrientation(0);
    }

    @Override
    public void updateUI() {
        this.setUI(new RangeSliderUI(this));
        this.updateLabelUIs();
    }

    @Override
    public int getValue() {
        return super.getValue();
    }

    @Override
    public void setValue(int value) {
        int oldValue = this.getValue();
        if (oldValue == value) {
            return;
        }
        int oldExtent = this.getExtent();
        int newValue = Math.min(Math.max(this.getMinimum(), value), oldValue + oldExtent);
        int newExtent = oldExtent + oldValue - newValue;
        this.lowerValue = newValue;
        this.getModel().setRangeProperties(newValue, newExtent, this.getMinimum(), this.getMaximum(), this.getValueIsAdjusting());
    }

    @Override
    public void setOrientation(int orientation) {
        super.setOrientation(orientation);
        this.updateUI();
    }

    public boolean isRangeVisible() {
        return this.rangeVisible;
    }

    public void setRangeVisible(boolean RANGE_VISIBLE) {
        this.rangeVisible = RANGE_VISIBLE;
        this.updateUI();
    }

    public boolean isRangeSelectionEnabled() {
        return this.rangeSelectionEnabled;
    }

    public void setRangeSelectionEnabled(boolean RANGE_SELECTION_ENABLED) {
        this.rangeSelectionEnabled = RANGE_SELECTION_ENABLED;
        if (!RANGE_SELECTION_ENABLED) {
            this.rangeVisible = false;
            this.setUpperValue(this.getMaximum());
        }
        this.updateUI();
    }

    public int getLowerValue() {
        return this.lowerValue;
    }

    public void setLowerValue(int LOWER_VALUE) {
        this.setValue(LOWER_VALUE);
    }

    public int getUpperValue() {
        return this.upperValue;
    }

    public void setUpperValue(int UPPER_VALUE) {
        this.lowerValue = this.getValue();
        int newExtent = Math.min(Math.max(0, UPPER_VALUE - this.lowerValue), this.getMaximum() - this.lowerValue);
        this.setExtent(newExtent);
        this.upperValue = UPPER_VALUE > this.lowerValue ? this.lowerValue + newExtent : this.lowerValue;
        this.getModel().setExtent(newExtent);
    }

    public ThumbShape getThumbShape() {
        return this.thumbShape;
    }

    public void setThumbShape(ThumbShape THUMB_SHAPE) {
        this.thumbShape = THUMB_SHAPE;
        this.updateUI();
    }

    public ThumbDesign getThumbDesign() {
        return this.thumbDesign;
    }

    public void setThumbDesign(ThumbDesign THUMB_DESIGN) {
        this.thumbDesign = THUMB_DESIGN;
        this.updateUI();
    }

    public TrackWidth getTrackWidth() {
        return this.trackWidth;
    }

    public void setTrackWidth(TrackWidth TRACK_DESIGN) {
        this.trackWidth = TRACK_DESIGN;
        this.updateUI();
    }

    public boolean isDarkTrack() {
        return this.darkTrack;
    }

    public void setDarkTrack(boolean DARK_TRACK) {
        this.darkTrack = DARK_TRACK;
        this.updateUI();
    }

    public Color getRangeColor() {
        return this.rangeColor;
    }

    public void setRangeColor(Color RANGE_COLOR) {
        this.rangeColor = RANGE_COLOR;
        this.updateUI();
    }

    public static enum TrackWidth {
        THIN,
        MEDIUM,
        THICK;

    }

    public static enum ThumbDesign {
        BRIGHT,
        DARK,
        STAINLESS,
        DARK_STAINLESS;

    }

    public static enum ThumbShape {
        ROUND,
        SQUARE,
        RECTANGULAR,
        DROP,
        NONE;

    }
}

